/*
 * Decompiled with CFR 0.152.
 */
package rsp;

import com.ib.client.Contract;
import com.ib.controller.ApiController;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class InteractiveBrokerApiComponent
implements ApiController.IConnectionHandler {
    private static final Logger log = LogManager.getLogger(InteractiveBrokerApiComponent.class);
    public ApiController api;
    private boolean isConnected = false;

    @EventListener(value={ApplicationReadyEvent.class})
    public void init() {
        this.api = new ApiController((ApiController.IConnectionHandler)this);
        this.api.connect("localhost", 4001, 0, null);
    }

    public void destroy() {
        if (this.isConnected && this.api.client().isConnected()) {
            this.api.disconnect();
        }
    }

    public void connected() {
        if (this.isConnected) {
            return;
        }
        this.isConnected = true;
        this.api.reqMktDataType(1);
    }

    public Contract buildContract(String symbol) {
        Contract contract = new Contract();
        contract.conid(0);
        contract.symbol(symbol);
        contract.strike(0.0);
        contract.secType("STK");
        contract.exchange("SMART");
        contract.currency("USD");
        return contract;
    }

    public void disconnected() {
        this.isConnected = false;
    }

    public void accountList(List<String> list) {
        System.out.printf("Account List %s%n", list);
    }

    public void error(Exception e) {
        System.err.println("Error: " + e.getMessage());
    }

    public void message(int id, int errorCode, String errorMsg, String advancedOrderRejectJson) {
        System.err.printf("message or error: %s %s %s %s%n", id, errorCode, errorMsg, advancedOrderRejectJson);
    }

    public void show(String string) {
        System.out.printf("show: %s%n", string);
    }
}

