/*
 * Decompiled with CFR 0.152.
 */
package com.ib.controller;

import com.ib.client.CommissionReport;
import com.ib.client.Contract;
import com.ib.client.ContractDescription;
import com.ib.client.ContractDetails;
import com.ib.client.Decimal;
import com.ib.client.DeltaNeutralContract;
import com.ib.client.DepthMktDataDescription;
import com.ib.client.EClientErrors;
import com.ib.client.EClientSocket;
import com.ib.client.EJavaSignal;
import com.ib.client.EReader;
import com.ib.client.EReaderSignal;
import com.ib.client.EWrapper;
import com.ib.client.Execution;
import com.ib.client.ExecutionFilter;
import com.ib.client.FamilyCode;
import com.ib.client.HistogramEntry;
import com.ib.client.HistoricalSession;
import com.ib.client.HistoricalTick;
import com.ib.client.HistoricalTickBidAsk;
import com.ib.client.HistoricalTickLast;
import com.ib.client.NewsProvider;
import com.ib.client.Order;
import com.ib.client.OrderState;
import com.ib.client.OrderStatus;
import com.ib.client.PriceIncrement;
import com.ib.client.ScannerSubscription;
import com.ib.client.SoftDollarTier;
import com.ib.client.TagValue;
import com.ib.client.TickAttrib;
import com.ib.client.TickAttribBidAsk;
import com.ib.client.TickAttribLast;
import com.ib.client.TickType;
import com.ib.client.Types;
import com.ib.client.WshEventData;
import com.ib.controller.AccountSummaryTag;
import com.ib.controller.AdvisorUtil;
import com.ib.controller.ApiConnection;
import com.ib.controller.ApiController;
import com.ib.controller.Bar;
import com.ib.controller.ConcurrentHashSet;
import com.ib.controller.Group;
import com.ib.controller.MarketValueTag;
import com.ib.controller.Position;
import com.ib.controller.Profile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * Exception performing whole class analysis ignored.
 */
public class ApiController
implements EWrapper {
    private ApiConnection m_client;
    private final ApiConnection.ILogger m_outLogger;
    private final ApiConnection.ILogger m_inLogger;
    private int m_reqId;
    private int m_orderId;
    private final IConnectionHandler m_connectionHandler;
    private ITradeReportHandler m_tradeReportHandler;
    private ICompletedOrdersHandler m_completedOrdersHandler;
    private IAdvisorHandler m_advisorHandler;
    private IScannerHandler m_scannerHandler;
    private ITimeHandler m_timeHandler;
    private IBulletinHandler m_bulletinHandler;
    private IUserInfoHandler m_userInfoHandler;
    private final Map<Integer, IInternalHandler> m_contractDetailsMap = new HashMap();
    private final Map<Integer, IOptHandler> m_optionCompMap = new HashMap();
    private final Map<Integer, IEfpHandler> m_efpMap = new HashMap();
    private final Map<Integer, ITopMktDataHandler> m_topMktDataMap = new HashMap();
    private final Map<Integer, IDeepMktDataHandler> m_deepMktDataMap = new HashMap();
    private final Map<Integer, IScannerHandler> m_scannerMap = new HashMap();
    private final Map<Integer, IRealTimeBarHandler> m_realTimeBarMap = new HashMap();
    private final Map<Integer, IHistoricalDataHandler> m_historicalDataMap = new HashMap();
    private final Map<Integer, IHeadTimestampHandler> m_headTimestampMap = new HashMap();
    private final Map<Integer, IHistogramDataHandler> m_histogramDataMap = new HashMap();
    private final Map<Integer, IFundamentalsHandler> m_fundMap = new HashMap();
    private final Map<Integer, IOrderHandler> m_orderHandlers = new HashMap();
    private final Map<Integer, IOrderCancelHandler> m_orderCancelHandlers = new HashMap();
    private final Map<Integer, IAccountSummaryHandler> m_acctSummaryHandlers = new HashMap();
    private final Map<Integer, IMarketValueSummaryHandler> m_mktValSummaryHandlers = new HashMap();
    private final Set<IPositionHandler> m_positionHandlers = new ConcurrentHashSet();
    private final Set<IAccountHandler> m_accountHandlers = new ConcurrentHashSet();
    private final Set<ILiveOrderHandler> m_liveOrderHandlers = new ConcurrentHashSet();
    private final Map<Integer, IPositionMultiHandler> m_positionMultiMap = new HashMap();
    private final Map<Integer, IAccountUpdateMultiHandler> m_accountUpdateMultiMap = new HashMap();
    private final Map<Integer, ISecDefOptParamsReqHandler> m_secDefOptParamsReqMap = new HashMap();
    private final Map<Integer, ISoftDollarTiersReqHandler> m_softDollarTiersReqMap = new HashMap();
    private final Set<IFamilyCodesHandler> m_familyCodesHandlers = new ConcurrentHashSet();
    private final Map<Integer, ISymbolSamplesHandler> m_symbolSamplesHandlerMap = new HashMap();
    private final Set<IMktDepthExchangesHandler> m_mktDepthExchangesHandlers = new ConcurrentHashSet();
    private final Map<Integer, ITickNewsHandler> m_tickNewsHandlerMap = new HashMap();
    private final Map<Integer, ISmartComponentsHandler> m_smartComponentsHandler = new HashMap();
    private final Set<INewsProvidersHandler> m_newsProvidersHandlers = new ConcurrentHashSet();
    private final Map<Integer, INewsArticleHandler> m_newsArticleHandlerMap = new HashMap();
    private final Map<Integer, IHistoricalNewsHandler> m_historicalNewsHandlerMap = new HashMap();
    private final Set<IMarketRuleHandler> m_marketRuleHandlers = new ConcurrentHashSet();
    private final Map<Integer, IPnLHandler> m_pnlMap = new HashMap();
    private final Map<Integer, IPnLSingleHandler> m_pnlSingleMap = new HashMap();
    private final Map<Integer, IHistoricalTickHandler> m_historicalTicksMap = new HashMap();
    private final Map<Integer, ITickByTickDataHandler> m_tickByTickDataMap = new HashMap();
    private final Map<Integer, IWshMetaDataHandler> m_wshMetaDataMap = new HashMap();
    private final Map<Integer, IWshEventDataHandler> m_wshEventDataMap = new HashMap();
    private final Map<Integer, IHistoricalScheduleHandler> m_historicalScheduleMap = new HashMap();
    private boolean m_connected = false;
    private static final int REPLACE_FA_GROUPS_REQ_ID = 0;
    private static final int REPLACE_FA_PROFILES_REQ_ID = 1;

    public ApiConnection client() {
        return this.m_client;
    }

    public ApiController(IConnectionHandler handler) {
        this(handler, null, null);
    }

    public ApiController(IConnectionHandler handler, ApiConnection.ILogger inLogger, ApiConnection.ILogger outLogger) {
        this.m_connectionHandler = handler;
        this.m_client = new ApiConnection((EWrapper)this, inLogger, outLogger);
        this.m_inLogger = inLogger;
        this.m_outLogger = outLogger;
    }

    private void startMsgProcessingThread() {
        EJavaSignal signal = new EJavaSignal();
        EReader reader = new EReader((EClientSocket)this.client(), (EReaderSignal)signal);
        reader.start();
        new Thread(() -> this.lambda$startMsgProcessingThread$0((EReaderSignal)signal, reader)).start();
    }

    public void connect(String host, int port, int clientId, String connectionOpts) {
        if (!this.m_client.isConnected()) {
            this.m_client.eConnect(host, port, clientId);
            this.startMsgProcessingThread();
            this.sendEOM();
        }
    }

    public void disconnect() {
        if (!this.checkConnection()) {
            return;
        }
        this.m_client.eDisconnect();
        this.m_connectionHandler.disconnected();
        this.m_connected = false;
        this.sendEOM();
    }

    public void managedAccounts(String accounts) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(accounts, ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        this.m_connectionHandler.accountList(list);
        this.recEOM();
    }

    public void nextValidId(int orderId) {
        this.m_orderId = orderId;
        this.m_reqId = this.m_orderId + 10000000;
        this.m_connected = true;
        if (this.m_connectionHandler != null) {
            this.m_connectionHandler.connected();
        }
        this.recEOM();
    }

    public void error(Exception e) {
        this.m_connectionHandler.error(e);
    }

    public void error(int id, int errorCode, String errorMsg, String advancedOrderRejectJson) {
        IInternalHandler hand;
        IOrderCancelHandler orderCancelHandler;
        IOrderHandler handler = (IOrderHandler)this.m_orderHandlers.get(id);
        if (handler != null) {
            handler.handle(errorCode, errorMsg);
        }
        if ((orderCancelHandler = (IOrderCancelHandler)this.m_orderCancelHandlers.get(id)) != null) {
            orderCancelHandler.handle(errorCode, errorMsg);
        }
        for (ILiveOrderHandler liveHandler : this.m_liveOrderHandlers) {
            liveHandler.handle(id, errorCode, errorMsg);
        }
        if (errorCode == 200 && (hand = (IInternalHandler)this.m_contractDetailsMap.remove(id)) != null) {
            hand.contractDetailsEnd();
        }
        this.m_connectionHandler.message(id, errorCode, errorMsg, advancedOrderRejectJson);
        this.recEOM();
    }

    public void connectionClosed() {
        this.m_connectionHandler.disconnected();
        this.m_connected = false;
    }

    public void reqAccountUpdates(boolean subscribe, String acctCode, IAccountHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_accountHandlers.add(handler);
        this.m_client.reqAccountUpdates(subscribe, acctCode);
        this.sendEOM();
    }

    public void updateAccountValue(String tag, String value, String currency, String account) {
        if ("Currency".equals(tag)) {
            return;
        }
        for (IAccountHandler handler : this.m_accountHandlers) {
            handler.accountValue(account, tag, value, currency);
        }
        this.recEOM();
    }

    public void updateAccountTime(String timeStamp) {
        for (IAccountHandler handler : this.m_accountHandlers) {
            handler.accountTime(timeStamp);
        }
        this.recEOM();
    }

    public void accountDownloadEnd(String account) {
        for (IAccountHandler handler : this.m_accountHandlers) {
            handler.accountDownloadEnd(account);
        }
        this.recEOM();
    }

    public void updatePortfolio(Contract contract, Decimal positionIn, double marketPrice, double marketValue, double averageCost, double unrealizedPNL, double realizedPNL, String account) {
        contract.exchange(contract.primaryExch());
        Position position = new Position(contract, account, positionIn, marketPrice, marketValue, averageCost, unrealizedPNL, realizedPNL);
        for (IAccountHandler handler : this.m_accountHandlers) {
            handler.updatePortfolio(position);
        }
        this.recEOM();
    }

    public void reqAccountSummary(String group, AccountSummaryTag[] tags, IAccountSummaryHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (AccountSummaryTag tag : tags) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(tag);
        }
        int reqId = this.m_reqId++;
        this.m_acctSummaryHandlers.put(reqId, handler);
        this.m_client.reqAccountSummary(reqId, group, sb.toString());
        this.sendEOM();
    }

    private boolean isConnected() {
        return this.m_connected;
    }

    public void cancelAccountSummary(IAccountSummaryHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer reqId = (Integer)ApiController.getAndRemoveKey((Map)this.m_acctSummaryHandlers, (Object)handler);
        if (reqId != null) {
            this.m_client.cancelAccountSummary(reqId.intValue());
            this.sendEOM();
        }
    }

    public void reqMarketValueSummary(String group, IMarketValueSummaryHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_mktValSummaryHandlers.put(reqId, handler);
        this.m_client.reqAccountSummary(reqId, group, "$LEDGER");
        this.sendEOM();
    }

    public void cancelMarketValueSummary(IMarketValueSummaryHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer reqId = (Integer)ApiController.getAndRemoveKey((Map)this.m_mktValSummaryHandlers, (Object)handler);
        if (reqId != null) {
            this.m_client.cancelAccountSummary(reqId.intValue());
            this.sendEOM();
        }
    }

    public void accountSummary(int reqId, String account, String tag, String value, String currency) {
        IMarketValueSummaryHandler handler2;
        if ("Currency".equals(tag)) {
            return;
        }
        IAccountSummaryHandler handler = (IAccountSummaryHandler)this.m_acctSummaryHandlers.get(reqId);
        if (handler != null) {
            handler.accountSummary(account, AccountSummaryTag.valueOf((String)tag), value, currency);
        }
        if ((handler2 = (IMarketValueSummaryHandler)this.m_mktValSummaryHandlers.get(reqId)) != null) {
            handler2.marketValueSummary(account, MarketValueTag.valueOf((String)tag), value, currency);
        }
        this.recEOM();
    }

    public void accountSummaryEnd(int reqId) {
        IMarketValueSummaryHandler handler2;
        IAccountSummaryHandler handler = (IAccountSummaryHandler)this.m_acctSummaryHandlers.get(reqId);
        if (handler != null) {
            handler.accountSummaryEnd();
        }
        if ((handler2 = (IMarketValueSummaryHandler)this.m_mktValSummaryHandlers.get(reqId)) != null) {
            handler2.marketValueSummaryEnd();
        }
        this.recEOM();
    }

    public void reqPositions(IPositionHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_positionHandlers.add(handler);
        this.m_client.reqPositions();
        this.sendEOM();
    }

    public void cancelPositions(IPositionHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_positionHandlers.remove(handler);
        this.m_client.cancelPositions();
        this.sendEOM();
    }

    public void position(String account, Contract contract, Decimal pos, double avgCost) {
        for (IPositionHandler handler : this.m_positionHandlers) {
            handler.position(account, contract, pos, avgCost);
        }
        this.recEOM();
    }

    public void positionEnd() {
        for (IPositionHandler handler : this.m_positionHandlers) {
            handler.positionEnd();
        }
        this.recEOM();
    }

    public void reqContractDetails(Contract contract, IContractDetailsHandler processor) {
        if (!this.checkConnection()) {
            return;
        }
        ArrayList list = new ArrayList();
        this.internalReqContractDetails(contract, (IInternalHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.sendEOM();
    }

    private void internalReqContractDetails(Contract contract, IInternalHandler processor) {
        int reqId = this.m_reqId++;
        this.m_contractDetailsMap.put(reqId, processor);
        this.m_orderHandlers.put(reqId, new /* Unavailable Anonymous Inner Class!! */);
        this.m_client.reqContractDetails(reqId, contract);
        this.sendEOM();
    }

    public void contractDetails(int reqId, ContractDetails contractDetails) {
        IInternalHandler handler = (IInternalHandler)this.m_contractDetailsMap.get(reqId);
        if (handler != null) {
            handler.contractDetails(contractDetails);
        } else {
            this.show("Error: no contract details handler for reqId " + reqId);
        }
        this.recEOM();
    }

    public void bondContractDetails(int reqId, ContractDetails contractDetails) {
        IInternalHandler handler = (IInternalHandler)this.m_contractDetailsMap.get(reqId);
        if (handler != null) {
            handler.contractDetails(contractDetails);
        } else {
            this.show("Error: no bond contract details handler for reqId " + reqId);
        }
        this.recEOM();
    }

    public void contractDetailsEnd(int reqId) {
        IInternalHandler handler = (IInternalHandler)this.m_contractDetailsMap.remove(reqId);
        if (handler != null) {
            handler.contractDetailsEnd();
        } else {
            this.show("Error: no contract details handler for reqId " + reqId);
        }
        this.recEOM();
    }

    public void reqTopMktData(Contract contract, String genericTickList, boolean snapshot, boolean regulatorySnapshot, ITopMktDataHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_topMktDataMap.put(reqId, handler);
        this.m_client.reqMktData(reqId, contract, genericTickList, snapshot, regulatorySnapshot, Collections.emptyList());
        this.sendEOM();
    }

    public void reqOptionMktData(Contract contract, String genericTickList, boolean snapshot, boolean regulatorySnapshot, IOptHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_topMktDataMap.put(reqId, handler);
        this.m_optionCompMap.put(reqId, handler);
        this.m_client.reqMktData(reqId, contract, genericTickList, snapshot, regulatorySnapshot, Collections.emptyList());
        this.sendEOM();
    }

    public void reqEfpMktData(Contract contract, String genericTickList, boolean snapshot, boolean regulatorySnapshot, IEfpHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_topMktDataMap.put(reqId, handler);
        this.m_efpMap.put(reqId, handler);
        this.m_client.reqMktData(reqId, contract, genericTickList, snapshot, regulatorySnapshot, Collections.emptyList());
        this.sendEOM();
    }

    public void cancelTopMktData(ITopMktDataHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer reqId = (Integer)ApiController.getAndRemoveKey((Map)this.m_topMktDataMap, (Object)handler);
        if (reqId != null) {
            this.m_client.cancelMktData(reqId.intValue());
        } else {
            this.show("Error: could not cancel top market data");
        }
        this.sendEOM();
    }

    public void cancelOptionMktData(IOptHandler handler) {
        this.cancelTopMktData((ITopMktDataHandler)handler);
        ApiController.getAndRemoveKey((Map)this.m_optionCompMap, (Object)handler);
    }

    public void cancelEfpMktData(IEfpHandler handler) {
        this.cancelTopMktData((ITopMktDataHandler)handler);
        ApiController.getAndRemoveKey((Map)this.m_efpMap, (Object)handler);
    }

    public void reqMktDataType(int mktDataType) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_client.reqMarketDataType(mktDataType);
        this.sendEOM();
        switch (mktDataType) {
            case 1: {
                this.show("Frozen, Delayed and Delayed-Frozen market data types are disabled");
                break;
            }
            case 2: {
                this.show("Frozen market data type is enabled");
                break;
            }
            case 3: {
                this.show("Delayed market data type is enabled, Delayed-Frozen market data type is disabled");
                break;
            }
            case 4: {
                this.show("Delayed and Delayed-Frozen market data types are enabled");
                break;
            }
            default: {
                this.show("Unknown market data type");
            }
        }
    }

    public void tickPrice(int reqId, int tickType, double price, TickAttrib attribs) {
        ITopMktDataHandler handler = (ITopMktDataHandler)this.m_topMktDataMap.get(reqId);
        if (handler != null) {
            handler.tickPrice(TickType.get((int)tickType), price, attribs);
        }
        this.recEOM();
    }

    public void tickGeneric(int reqId, int tickType, double value) {
        ITopMktDataHandler handler = (ITopMktDataHandler)this.m_topMktDataMap.get(reqId);
        if (handler != null) {
            handler.tickPrice(TickType.get((int)tickType), value, new TickAttrib());
        }
        this.recEOM();
    }

    public void tickSize(int reqId, int tickType, Decimal size) {
        ITopMktDataHandler handler = (ITopMktDataHandler)this.m_topMktDataMap.get(reqId);
        if (handler != null) {
            handler.tickSize(TickType.get((int)tickType), size);
        }
        this.recEOM();
    }

    public void tickString(int reqId, int tickType, String value) {
        ITopMktDataHandler handler = (ITopMktDataHandler)this.m_topMktDataMap.get(reqId);
        if (handler != null) {
            handler.tickString(TickType.get((int)tickType), value);
        }
        this.recEOM();
    }

    public void tickEFP(int reqId, int tickType, double basisPoints, String formattedBasisPoints, double impliedFuture, int holdDays, String futureLastTradeDate, double dividendImpact, double dividendsToLastTradeDate) {
        IEfpHandler handler = (IEfpHandler)this.m_efpMap.get(reqId);
        if (handler != null) {
            handler.tickEFP(tickType, basisPoints, formattedBasisPoints, impliedFuture, holdDays, futureLastTradeDate, dividendImpact, dividendsToLastTradeDate);
        }
        this.recEOM();
    }

    public void tickSnapshotEnd(int reqId) {
        ITopMktDataHandler handler = (ITopMktDataHandler)this.m_topMktDataMap.get(reqId);
        if (handler != null) {
            handler.tickSnapshotEnd();
        }
        this.recEOM();
    }

    public void marketDataType(int reqId, int marketDataType) {
        ITopMktDataHandler handler = (ITopMktDataHandler)this.m_topMktDataMap.get(reqId);
        if (handler != null) {
            handler.marketDataType(marketDataType);
        }
        this.recEOM();
    }

    public void reqDeepMktData(Contract contract, int numRows, boolean isSmartDepth, IDeepMktDataHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_deepMktDataMap.put(reqId, handler);
        ArrayList mktDepthOptions = new ArrayList();
        this.m_client.reqMktDepth(reqId, contract, numRows, isSmartDepth, mktDepthOptions);
        this.sendEOM();
    }

    public void cancelDeepMktData(boolean isSmartDepth, IDeepMktDataHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer reqId = (Integer)ApiController.getAndRemoveKey((Map)this.m_deepMktDataMap, (Object)handler);
        if (reqId != null) {
            this.m_client.cancelMktDepth(reqId.intValue(), isSmartDepth);
            this.sendEOM();
        }
    }

    public void updateMktDepth(int reqId, int position, int operation, int side, double price, Decimal size) {
        IDeepMktDataHandler handler = (IDeepMktDataHandler)this.m_deepMktDataMap.get(reqId);
        if (handler != null) {
            handler.updateMktDepth(position, null, Types.DeepType.get((int)operation), Types.DeepSide.get((int)side), price, size);
        }
        this.recEOM();
    }

    public void updateMktDepthL2(int reqId, int position, String marketMaker, int operation, int side, double price, Decimal size, boolean isSmartDepth) {
        IDeepMktDataHandler handler = (IDeepMktDataHandler)this.m_deepMktDataMap.get(reqId);
        if (handler != null) {
            handler.updateMktDepth(position, marketMaker, Types.DeepType.get((int)operation), Types.DeepSide.get((int)side), price, size);
        }
        this.recEOM();
    }

    public void reqOptionVolatility(Contract c, double optPrice, double underPrice, IOptHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_optionCompMap.put(reqId, handler);
        this.m_client.calculateImpliedVolatility(reqId, c, optPrice, underPrice, null);
        this.sendEOM();
    }

    public void reqOptionComputation(Contract c, double vol, double underPrice, IOptHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_optionCompMap.put(reqId, handler);
        this.m_client.calculateOptionPrice(reqId, c, vol, underPrice, null);
        this.sendEOM();
    }

    void cancelOptionComp(IOptHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer reqId = (Integer)ApiController.getAndRemoveKey((Map)this.m_optionCompMap, (Object)handler);
        if (reqId != null) {
            this.m_client.cancelCalculateOptionPrice(reqId.intValue());
            this.sendEOM();
        }
    }

    public void tickOptionComputation(int reqId, int tickType, int tickAttrib, double impliedVol, double delta, double optPrice, double pvDividend, double gamma, double vega, double theta, double undPrice) {
        IOptHandler handler = (IOptHandler)this.m_optionCompMap.get(reqId);
        if (handler != null) {
            handler.tickOptionComputation(TickType.get((int)tickType), tickAttrib, impliedVol, delta, optPrice, pvDividend, gamma, vega, theta, undPrice);
        } else {
            System.out.println(String.format("not handled %s %s %s %s %s %s %s %s %s %s", tickType, tickAttrib, impliedVol, delta, optPrice, pvDividend, gamma, vega, theta, undPrice));
        }
        this.recEOM();
    }

    public void reqExecutions(ExecutionFilter filter, ITradeReportHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_tradeReportHandler = handler;
        this.m_client.reqExecutions(this.m_reqId++, filter);
        this.sendEOM();
    }

    public void execDetails(int reqId, Contract contract, Execution execution) {
        if (this.m_tradeReportHandler != null) {
            int i = execution.execId().lastIndexOf(46);
            String tradeKey = execution.execId().substring(0, i);
            this.m_tradeReportHandler.tradeReport(tradeKey, contract, execution);
        }
        this.recEOM();
    }

    public void execDetailsEnd(int reqId) {
        if (this.m_tradeReportHandler != null) {
            this.m_tradeReportHandler.tradeReportEnd();
        }
        this.recEOM();
    }

    public void commissionReport(CommissionReport commissionReport) {
        if (this.m_tradeReportHandler != null) {
            int i = commissionReport.execId().lastIndexOf(46);
            String tradeKey = commissionReport.execId().substring(0, i);
            this.m_tradeReportHandler.commissionReport(tradeKey, commissionReport);
        }
        this.recEOM();
    }

    public void reqAdvisorData(Types.FADataType type, IAdvisorHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_advisorHandler = handler;
        this.m_client.requestFA(type.ordinal());
        this.sendEOM();
    }

    public void updateGroups(List<Group> groups) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_client.replaceFA(0, Types.FADataType.GROUPS.ordinal(), AdvisorUtil.getGroupsXml(groups));
        this.sendEOM();
    }

    public void updateProfiles(List<Profile> profiles) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_client.replaceFA(1, Types.FADataType.PROFILES.ordinal(), AdvisorUtil.getProfilesXml(profiles));
        this.sendEOM();
    }

    public final void receiveFA(int faDataType, String xml) {
        if (this.m_advisorHandler == null) {
            return;
        }
        Types.FADataType type = Types.FADataType.get((int)faDataType);
        switch (3.$SwitchMap$com$ib$client$Types$FADataType[type.ordinal()]) {
            case 1: {
                List groups = AdvisorUtil.getGroups((String)xml);
                this.m_advisorHandler.groups(groups);
                break;
            }
            case 2: {
                List profiles = AdvisorUtil.getProfiles((String)xml);
                this.m_advisorHandler.profiles(profiles);
                break;
            }
            case 3: {
                List aliases = AdvisorUtil.getAliases((String)xml);
                this.m_advisorHandler.aliases(aliases);
                break;
            }
        }
        this.recEOM();
    }

    public final void replaceFAEnd(int reqId, String text) {
        switch (reqId) {
            case 0: {
                this.m_advisorHandler.updateGroupsEnd(text);
                break;
            }
            case 1: {
                this.m_advisorHandler.updateProfilesEnd(text);
                break;
            }
        }
        this.recEOM();
    }

    public int placeOrModifyOrder(Contract contract, Order order, IOrderHandler handler) {
        if (!this.checkConnection()) {
            return 0;
        }
        if (order.orderId() == 0) {
            order.orderId(this.m_orderId++);
            if (handler != null) {
                this.m_orderHandlers.put(order.orderId(), handler);
            }
        }
        this.m_client.placeOrder(contract, order);
        this.sendEOM();
        return order.orderId();
    }

    public void cancelOrder(int orderId, String manualOrderCancelTime, IOrderCancelHandler orderCancelHandler) {
        if (!this.checkConnection()) {
            return;
        }
        if (orderCancelHandler != null) {
            this.m_orderCancelHandlers.put(orderId, orderCancelHandler);
        }
        this.m_client.cancelOrder(orderId, manualOrderCancelTime);
        this.sendEOM();
    }

    public void cancelAllOrders() {
        if (!this.checkConnection()) {
            return;
        }
        this.m_client.reqGlobalCancel();
        this.sendEOM();
    }

    public void exerciseOption(String account, Contract contract, Types.ExerciseType type, int quantity, boolean override) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_client.exerciseOptions(this.m_reqId++, contract, type.ordinal(), quantity, account, override ? 1 : 0);
        this.sendEOM();
    }

    public void removeOrderHandler(IOrderHandler handler) {
        ApiController.getAndRemoveKey((Map)this.m_orderHandlers, (Object)handler);
    }

    public void removeOrderCancelHandler(IOrderCancelHandler orderCancelHandler) {
        ApiController.getAndRemoveKey((Map)this.m_orderCancelHandlers, (Object)orderCancelHandler);
    }

    public void reqLiveOrders(ILiveOrderHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_liveOrderHandlers.add(handler);
        this.m_client.reqAllOpenOrders();
        this.sendEOM();
    }

    public void takeTwsOrders(ILiveOrderHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_liveOrderHandlers.add(handler);
        this.m_client.reqOpenOrders();
        this.sendEOM();
    }

    public void takeFutureTwsOrders(ILiveOrderHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_liveOrderHandlers.add(handler);
        this.m_client.reqAutoOpenOrders(true);
        this.sendEOM();
    }

    public void removeLiveOrderHandler(ILiveOrderHandler handler) {
        this.m_liveOrderHandlers.remove(handler);
    }

    public void openOrder(int orderId, Contract contract, Order order, OrderState orderState) {
        IOrderHandler handler = (IOrderHandler)this.m_orderHandlers.get(orderId);
        if (handler != null) {
            handler.orderState(orderState);
        }
        if (!order.whatIf()) {
            for (ILiveOrderHandler liveHandler : this.m_liveOrderHandlers) {
                liveHandler.openOrder(contract, order, orderState);
            }
        }
        this.recEOM();
    }

    public void openOrderEnd() {
        for (ILiveOrderHandler handler : this.m_liveOrderHandlers) {
            handler.openOrderEnd();
        }
        this.recEOM();
    }

    public void orderStatus(int orderId, String status, Decimal filled, Decimal remaining, double avgFillPrice, int permId, int parentId, double lastFillPrice, int clientId, String whyHeld, double mktCapPrice) {
        IOrderCancelHandler orderCancelHandler;
        IOrderHandler handler = (IOrderHandler)this.m_orderHandlers.get(orderId);
        if (handler != null) {
            handler.orderStatus(OrderStatus.valueOf((String)status), filled, remaining, avgFillPrice, permId, parentId, lastFillPrice, clientId, whyHeld, mktCapPrice);
        }
        if ((orderCancelHandler = (IOrderCancelHandler)this.m_orderCancelHandlers.get(orderId)) != null) {
            orderCancelHandler.orderStatus(status);
        }
        for (ILiveOrderHandler liveOrderHandler : this.m_liveOrderHandlers) {
            liveOrderHandler.orderStatus(orderId, OrderStatus.valueOf((String)status), filled, remaining, avgFillPrice, permId, parentId, lastFillPrice, clientId, whyHeld, mktCapPrice);
        }
        this.recEOM();
    }

    public void reqScannerParameters(IScannerHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_scannerHandler = handler;
        this.m_client.reqScannerParameters();
        this.sendEOM();
    }

    public void reqScannerSubscription(ScannerSubscription sub, List<TagValue> filterOptions, IScannerHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_scannerMap.put(reqId, handler);
        this.m_client.reqScannerSubscription(reqId, sub, null, filterOptions);
        this.sendEOM();
    }

    public void cancelScannerSubscription(IScannerHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer reqId = (Integer)ApiController.getAndRemoveKey((Map)this.m_scannerMap, (Object)handler);
        if (reqId != null) {
            this.m_client.cancelScannerSubscription(reqId.intValue());
            this.sendEOM();
        }
    }

    public void scannerParameters(String xml) {
        this.m_scannerHandler.scannerParameters(xml);
        this.recEOM();
    }

    public void scannerData(int reqId, int rank, ContractDetails contractDetails, String distance, String benchmark, String projection, String legsStr) {
        IScannerHandler handler = (IScannerHandler)this.m_scannerMap.get(reqId);
        if (handler != null) {
            handler.scannerData(rank, contractDetails, legsStr);
        }
        this.recEOM();
    }

    public void scannerDataEnd(int reqId) {
        IScannerHandler handler = (IScannerHandler)this.m_scannerMap.get(reqId);
        if (handler != null) {
            handler.scannerDataEnd();
        }
        this.recEOM();
    }

    public void reqHistoricalData(Contract contract, String endDateTime, int duration, Types.DurationUnit durationUnit, Types.BarSize barSize, Types.WhatToShow whatToShow, boolean rthOnly, boolean keepUpToDate, IHistoricalDataHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_historicalDataMap.put(reqId, handler);
        String durationStr = duration + " " + durationUnit.toString().charAt(0);
        this.m_client.reqHistoricalData(reqId, contract, endDateTime, durationStr, barSize.toString(), whatToShow.toString(), rthOnly ? 1 : 0, 1, keepUpToDate, Collections.emptyList());
        this.sendEOM();
    }

    public void cancelHistoricalData(IHistoricalDataHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer reqId = (Integer)ApiController.getAndRemoveKey((Map)this.m_historicalDataMap, (Object)handler);
        if (reqId != null) {
            this.m_client.cancelHistoricalData(reqId.intValue());
            this.sendEOM();
        }
    }

    public void historicalData(int reqId, com.ib.client.Bar bar) {
        IHistoricalDataHandler handler = (IHistoricalDataHandler)this.m_historicalDataMap.get(reqId);
        if (handler != null) {
            if (bar.time().startsWith("finished")) {
                handler.historicalDataEnd();
            } else {
                Bar bar2 = new Bar(bar.time(), bar.high(), bar.low(), bar.open(), bar.close(), bar.wap(), bar.volume(), bar.count());
                handler.historicalData(bar2);
            }
        }
        this.recEOM();
    }

    public void reqRealTimeBars(Contract contract, Types.WhatToShow whatToShow, boolean rthOnly, IRealTimeBarHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_realTimeBarMap.put(reqId, handler);
        ArrayList realTimeBarsOptions = new ArrayList();
        this.m_client.reqRealTimeBars(reqId, contract, 0, whatToShow.toString(), rthOnly, realTimeBarsOptions);
        this.sendEOM();
    }

    public void cancelRealtimeBars(IRealTimeBarHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer reqId = (Integer)ApiController.getAndRemoveKey((Map)this.m_realTimeBarMap, (Object)handler);
        if (reqId != null) {
            this.m_client.cancelRealTimeBars(reqId.intValue());
            this.sendEOM();
        }
    }

    public void realtimeBar(int reqId, long time, double open, double high, double low, double close, Decimal volume, Decimal wap, int count) {
        IRealTimeBarHandler handler = (IRealTimeBarHandler)this.m_realTimeBarMap.get(reqId);
        if (handler != null) {
            Bar bar = new Bar(time, high, low, open, close, wap, volume, count);
            handler.realtimeBar(bar);
        }
        this.recEOM();
    }

    public void reqFundamentals(Contract contract, Types.FundamentalType reportType, IFundamentalsHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_fundMap.put(reqId, handler);
        this.m_client.reqFundamentalData(reqId, contract, reportType.getApiString(), null);
        this.sendEOM();
    }

    public void fundamentalData(int reqId, String data) {
        IFundamentalsHandler handler = (IFundamentalsHandler)this.m_fundMap.get(reqId);
        if (handler != null) {
            handler.fundamentals(data);
        }
        this.recEOM();
    }

    public void reqCurrentTime(ITimeHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_timeHandler = handler;
        this.m_client.reqCurrentTime();
        this.sendEOM();
    }

    protected boolean checkConnection() {
        if (!this.isConnected()) {
            this.error(-1, EClientErrors.NOT_CONNECTED.code(), EClientErrors.NOT_CONNECTED.msg(), null);
            return false;
        }
        return true;
    }

    public void currentTime(long time) {
        this.m_timeHandler.currentTime(time);
        this.recEOM();
    }

    public void reqBulletins(boolean allMessages, IBulletinHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_bulletinHandler = handler;
        this.m_client.reqNewsBulletins(allMessages);
        this.sendEOM();
    }

    public void cancelBulletins() {
        if (!this.checkConnection()) {
            return;
        }
        this.m_client.cancelNewsBulletins();
    }

    public void updateNewsBulletin(int msgId, int msgType, String message, String origExchange) {
        this.m_bulletinHandler.bulletin(msgId, Types.NewsType.get((int)msgType), message, origExchange);
        this.recEOM();
    }

    public void reqPositionsMulti(String account, String modelCode, IPositionMultiHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_positionMultiMap.put(reqId, handler);
        this.m_client.reqPositionsMulti(reqId, account, modelCode);
        this.sendEOM();
    }

    public void cancelPositionsMulti(IPositionMultiHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer reqId = (Integer)ApiController.getAndRemoveKey((Map)this.m_positionMultiMap, (Object)handler);
        if (reqId != null) {
            this.m_client.cancelPositionsMulti(reqId.intValue());
            this.sendEOM();
        }
    }

    public void positionMulti(int reqId, String account, String modelCode, Contract contract, Decimal pos, double avgCost) {
        IPositionMultiHandler handler = (IPositionMultiHandler)this.m_positionMultiMap.get(reqId);
        if (handler != null) {
            handler.positionMulti(account, modelCode, contract, pos, avgCost);
        }
        this.recEOM();
    }

    public void positionMultiEnd(int reqId) {
        IPositionMultiHandler handler = (IPositionMultiHandler)this.m_positionMultiMap.get(reqId);
        if (handler != null) {
            handler.positionMultiEnd();
        }
        this.recEOM();
    }

    public void reqAccountUpdatesMulti(String account, String modelCode, boolean ledgerAndNLV, IAccountUpdateMultiHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_accountUpdateMultiMap.put(reqId, handler);
        this.m_client.reqAccountUpdatesMulti(reqId, account, modelCode, ledgerAndNLV);
        this.sendEOM();
    }

    public void cancelAccountUpdatesMulti(IAccountUpdateMultiHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer reqId = (Integer)ApiController.getAndRemoveKey((Map)this.m_accountUpdateMultiMap, (Object)handler);
        if (reqId != null) {
            this.m_client.cancelAccountUpdatesMulti(reqId.intValue());
            this.sendEOM();
        }
    }

    public void accountUpdateMulti(int reqId, String account, String modelCode, String key, String value, String currency) {
        IAccountUpdateMultiHandler handler = (IAccountUpdateMultiHandler)this.m_accountUpdateMultiMap.get(reqId);
        if (handler != null) {
            handler.accountUpdateMulti(account, modelCode, key, value, currency);
        }
        this.recEOM();
    }

    public void accountUpdateMultiEnd(int reqId) {
        IAccountUpdateMultiHandler handler = (IAccountUpdateMultiHandler)this.m_accountUpdateMultiMap.get(reqId);
        if (handler != null) {
            handler.accountUpdateMultiEnd();
        }
        this.recEOM();
    }

    public void verifyMessageAPI(String apiData) {
    }

    public void verifyCompleted(boolean isSuccessful, String errorText) {
    }

    public void verifyAndAuthMessageAPI(String apiData, String xyzChallenge) {
    }

    public void verifyAndAuthCompleted(boolean isSuccessful, String errorText) {
    }

    public void displayGroupList(int reqId, String groups) {
    }

    public void displayGroupUpdated(int reqId, String contractInfo) {
    }

    public void deltaNeutralValidation(int reqId, DeltaNeutralContract deltaNeutralContract) {
        this.show("RECEIVED DN VALIDATION");
        this.recEOM();
    }

    protected void sendEOM() {
        if (this.m_outLogger != null) {
            this.m_outLogger.log("\n");
        }
    }

    private void recEOM() {
        if (this.m_inLogger != null) {
            this.m_inLogger.log("\n");
        }
    }

    public void show(String string) {
        this.m_connectionHandler.show(string);
    }

    private static <K, V> K getAndRemoveKey(Map<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (entry.getValue() != value) continue;
            map.remove(entry.getKey());
            return entry.getKey();
        }
        return null;
    }

    public void error(String str) {
        throw new RuntimeException();
    }

    public void connectAck() {
        if (this.m_client.isAsyncEConnect()) {
            this.m_client.startAPI();
        }
    }

    public void reqSecDefOptParams(String underlyingSymbol, String futFopExchange, String underlyingSecType, int underlyingConId, ISecDefOptParamsReqHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_secDefOptParamsReqMap.put(reqId, handler);
        this.m_client.reqSecDefOptParams(reqId, underlyingSymbol, futFopExchange, underlyingSecType, underlyingConId);
        this.sendEOM();
    }

    public void securityDefinitionOptionalParameter(int reqId, String exchange, int underlyingConId, String tradingClass, String multiplier, Set<String> expirations, Set<Double> strikes) {
        ISecDefOptParamsReqHandler handler = (ISecDefOptParamsReqHandler)this.m_secDefOptParamsReqMap.get(reqId);
        if (handler != null) {
            handler.securityDefinitionOptionalParameter(exchange, underlyingConId, tradingClass, multiplier, expirations, strikes);
        }
    }

    public void securityDefinitionOptionalParameterEnd(int reqId) {
        ISecDefOptParamsReqHandler handler = (ISecDefOptParamsReqHandler)this.m_secDefOptParamsReqMap.get(reqId);
        if (handler != null) {
            handler.securityDefinitionOptionalParameterEnd(reqId);
        }
    }

    public void reqSoftDollarTiers(ISoftDollarTiersReqHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_softDollarTiersReqMap.put(reqId, handler);
        this.m_client.reqSoftDollarTiers(reqId);
        this.sendEOM();
    }

    public void softDollarTiers(int reqId, SoftDollarTier[] tiers) {
        ISoftDollarTiersReqHandler handler = (ISoftDollarTiersReqHandler)this.m_softDollarTiersReqMap.get(reqId);
        if (handler != null) {
            handler.softDollarTiers(tiers);
        }
    }

    public void reqFamilyCodes(IFamilyCodesHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_familyCodesHandlers.add(handler);
        this.m_client.reqFamilyCodes();
        this.sendEOM();
    }

    public void familyCodes(FamilyCode[] familyCodes) {
        for (IFamilyCodesHandler handler : this.m_familyCodesHandlers) {
            handler.familyCodes(familyCodes);
        }
        this.recEOM();
    }

    public void reqMatchingSymbols(String pattern, ISymbolSamplesHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_symbolSamplesHandlerMap.put(reqId, handler);
        this.m_client.reqMatchingSymbols(reqId, pattern);
        this.sendEOM();
    }

    public void symbolSamples(int reqId, ContractDescription[] contractDescriptions) {
        ISymbolSamplesHandler handler = (ISymbolSamplesHandler)this.m_symbolSamplesHandlerMap.get(reqId);
        if (handler != null) {
            handler.symbolSamples(contractDescriptions);
        }
        this.recEOM();
    }

    public void historicalDataEnd(int reqId, String startDateStr, String endDateStr) {
        IHistoricalDataHandler handler = (IHistoricalDataHandler)this.m_historicalDataMap.get(reqId);
        if (handler != null) {
            handler.historicalDataEnd();
        }
    }

    public void reqMktDepthExchanges(IMktDepthExchangesHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_mktDepthExchangesHandlers.add(handler);
        this.m_client.reqMktDepthExchanges();
        this.sendEOM();
    }

    public void mktDepthExchanges(DepthMktDataDescription[] depthMktDataDescriptions) {
        for (IMktDepthExchangesHandler handler : this.m_mktDepthExchangesHandlers) {
            handler.mktDepthExchanges(depthMktDataDescriptions);
        }
        this.recEOM();
    }

    public void reqNewsTicks(Contract contract, ITickNewsHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int tickerId = this.m_reqId++;
        this.m_tickNewsHandlerMap.put(tickerId, handler);
        this.m_client.reqMktData(tickerId, contract, "mdoff,292", false, false, Collections.emptyList());
        this.sendEOM();
    }

    public void tickNews(int tickerId, long timeStamp, String providerCode, String articleId, String headline, String extraData) {
        ITickNewsHandler handler = (ITickNewsHandler)this.m_tickNewsHandlerMap.get(tickerId);
        if (handler != null) {
            handler.tickNews(timeStamp, providerCode, articleId, headline, extraData);
        }
        this.recEOM();
    }

    public void smartComponents(int reqId, Map<Integer, Map.Entry<String, Character>> theMap) {
        ISmartComponentsHandler handler = (ISmartComponentsHandler)this.m_smartComponentsHandler.get(reqId);
        if (handler != null) {
            handler.smartComponents(reqId, theMap);
        }
    }

    public void reqSmartComponents(String bboExchange, ISmartComponentsHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_smartComponentsHandler.put(reqId, handler);
        this.m_client.reqSmartComponents(reqId, bboExchange);
        this.sendEOM();
    }

    public void tickReqParams(int tickerId, double minTick, String bboExchange, int snapshotPermissions) {
        ITopMktDataHandler handler = (ITopMktDataHandler)this.m_topMktDataMap.get(tickerId);
        if (handler != null) {
            handler.tickReqParams(tickerId, minTick, bboExchange, snapshotPermissions);
        }
        this.recEOM();
    }

    public void reqNewsProviders(INewsProvidersHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_newsProvidersHandlers.add(handler);
        this.m_client.reqNewsProviders();
        this.sendEOM();
    }

    public void newsProviders(NewsProvider[] newsProviders) {
        for (INewsProvidersHandler handler : this.m_newsProvidersHandlers) {
            handler.newsProviders(newsProviders);
        }
        this.recEOM();
    }

    public void reqNewsArticle(String providerCode, String articleId, INewsArticleHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int requestId = this.m_reqId++;
        this.m_newsArticleHandlerMap.put(requestId, handler);
        this.m_client.reqNewsArticle(requestId, providerCode, articleId, Collections.emptyList());
        this.sendEOM();
    }

    public void newsArticle(int requestId, int articleType, String articleText) {
        INewsArticleHandler handler = (INewsArticleHandler)this.m_newsArticleHandlerMap.get(requestId);
        if (handler != null) {
            handler.newsArticle(articleType, articleText);
        }
        this.recEOM();
    }

    public void reqHistoricalNews(int conId, String providerCodes, String startDateTime, String endDateTime, int totalResults, IHistoricalNewsHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int requestId = this.m_reqId++;
        this.m_historicalNewsHandlerMap.put(requestId, handler);
        this.m_client.reqHistoricalNews(requestId, conId, providerCodes, startDateTime, endDateTime, totalResults, Collections.emptyList());
        this.sendEOM();
    }

    public void historicalNews(int requestId, String time, String providerCode, String articleId, String headline) {
        IHistoricalNewsHandler handler = (IHistoricalNewsHandler)this.m_historicalNewsHandlerMap.get(requestId);
        if (handler != null) {
            handler.historicalNews(time, providerCode, articleId, headline);
        }
        this.recEOM();
    }

    public void historicalNewsEnd(int requestId, boolean hasMore) {
        IHistoricalNewsHandler handler = (IHistoricalNewsHandler)this.m_historicalNewsHandlerMap.get(requestId);
        if (handler != null) {
            handler.historicalNewsEnd(hasMore);
        }
        this.recEOM();
    }

    public void reqHeadTimestamp(Contract contract, Types.WhatToShow whatToShow, boolean rthOnly, IHeadTimestampHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_headTimestampMap.put(reqId, handler);
        this.m_client.reqHeadTimestamp(reqId, contract, whatToShow.toString(), rthOnly ? 1 : 0, 2);
    }

    public void headTimestamp(int reqId, String headTimestamp) {
        IHeadTimestampHandler handler = (IHeadTimestampHandler)this.m_headTimestampMap.get(reqId);
        if (handler != null) {
            handler.headTimestamp(reqId, Long.parseLong(headTimestamp));
        }
        this.recEOM();
    }

    public void reqHistogramData(Contract contract, int duration, Types.DurationUnit durationUnit, boolean rthOnly, IHistogramDataHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        String durationStr = duration + " " + durationUnit.toString().toLowerCase() + "s";
        this.m_histogramDataMap.put(reqId, handler);
        this.m_client.reqHistogramData(reqId, contract, rthOnly, durationStr);
    }

    public void cancelHistogramData(IHistogramDataHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer reqId = (Integer)ApiController.getAndRemoveKey((Map)this.m_histogramDataMap, (Object)handler);
        if (reqId != null) {
            this.m_client.cancelHistogramData(reqId.intValue());
            this.sendEOM();
        }
    }

    public void histogramData(int reqId, List<HistogramEntry> items) {
        IHistogramDataHandler handler = (IHistogramDataHandler)this.m_histogramDataMap.get(reqId);
        if (handler != null) {
            handler.histogramData(reqId, items);
        }
        this.recEOM();
    }

    public void historicalDataUpdate(int reqId, com.ib.client.Bar bar) {
        this.historicalData(reqId, bar);
    }

    public void rerouteMktDataReq(int reqId, int conId, String exchange) {
        this.show("Re-route market data request. ReqId: " + reqId + ", ConId: " + conId + ", Exchange: " + exchange);
    }

    public void rerouteMktDepthReq(int reqId, int conId, String exchange) {
        this.show("Re-route market depth request. ReqId: " + reqId + ", ConId: " + conId + ", Exchange: " + exchange);
    }

    public void reqMarketRule(int marketRuleId, IMarketRuleHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_marketRuleHandlers.add(handler);
        this.m_client.reqMarketRule(marketRuleId);
        this.sendEOM();
    }

    public void marketRule(int marketRuleId, PriceIncrement[] priceIncrements) {
        for (IMarketRuleHandler handler : this.m_marketRuleHandlers) {
            handler.marketRule(marketRuleId, priceIncrements);
        }
        this.recEOM();
    }

    public void reqPnL(String account, String modelCode, IPnLHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_pnlMap.put(reqId, handler);
        this.m_client.reqPnL(reqId, account, modelCode);
    }

    public void cancelPnL(IPnLHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer reqId = (Integer)ApiController.getAndRemoveKey((Map)this.m_pnlMap, (Object)handler);
        if (reqId != null) {
            this.m_client.cancelPnL(reqId.intValue());
            this.sendEOM();
        }
    }

    public void pnl(int reqId, double dailyPnL, double unrealizedPnL, double realizedPnL) {
        IPnLHandler handler = (IPnLHandler)this.m_pnlMap.get(reqId);
        if (handler != null) {
            handler.pnl(reqId, dailyPnL, unrealizedPnL, realizedPnL);
        }
        this.recEOM();
    }

    public void reqPnLSingle(String account, String modelCode, int conId, IPnLSingleHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_pnlSingleMap.put(reqId, handler);
        this.m_client.reqPnLSingle(reqId, account, modelCode, conId);
    }

    public void cancelPnLSingle(IPnLSingleHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer reqId = (Integer)ApiController.getAndRemoveKey((Map)this.m_pnlSingleMap, (Object)handler);
        if (reqId != null) {
            this.m_client.cancelPnLSingle(reqId.intValue());
            this.sendEOM();
        }
    }

    public void pnlSingle(int reqId, Decimal pos, double dailyPnL, double unrealizedPnL, double realizedPnL, double value) {
        IPnLSingleHandler handler = (IPnLSingleHandler)this.m_pnlSingleMap.get(reqId);
        if (handler != null) {
            handler.pnlSingle(reqId, pos, dailyPnL, unrealizedPnL, realizedPnL, value);
        }
        this.recEOM();
    }

    public void reqHistoricalTicks(Contract contract, String startDateTime, String endDateTime, int numberOfTicks, String whatToShow, int useRth, boolean ignoreSize, IHistoricalTickHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_historicalTicksMap.put(reqId, handler);
        this.m_client.reqHistoricalTicks(reqId, contract, startDateTime, endDateTime, numberOfTicks, whatToShow, useRth, ignoreSize, Collections.emptyList());
    }

    public void historicalTicks(int reqId, List<HistoricalTick> ticks, boolean last) {
        ITickByTickDataHandler handlerTickByTick;
        IHistoricalTickHandler handler = (IHistoricalTickHandler)this.m_historicalTicksMap.get(reqId);
        if (handler != null) {
            handler.historicalTick(reqId, ticks);
        }
        if ((handlerTickByTick = (ITickByTickDataHandler)this.m_tickByTickDataMap.get(reqId)) != null) {
            handlerTickByTick.tickByTickHistoricalTick(reqId, ticks);
        }
        this.recEOM();
    }

    public void historicalTicksBidAsk(int reqId, List<HistoricalTickBidAsk> ticks, boolean done) {
        ITickByTickDataHandler handlerTickByTick;
        IHistoricalTickHandler handler = (IHistoricalTickHandler)this.m_historicalTicksMap.get(reqId);
        if (handler != null) {
            handler.historicalTickBidAsk(reqId, ticks);
        }
        if ((handlerTickByTick = (ITickByTickDataHandler)this.m_tickByTickDataMap.get(reqId)) != null) {
            handlerTickByTick.tickByTickHistoricalTickBidAsk(reqId, ticks);
        }
        this.recEOM();
    }

    public void historicalTicksLast(int reqId, List<HistoricalTickLast> ticks, boolean done) {
        ITickByTickDataHandler handlerTickByTick;
        IHistoricalTickHandler handler = (IHistoricalTickHandler)this.m_historicalTicksMap.get(reqId);
        if (handler != null) {
            handler.historicalTickLast(reqId, ticks);
        }
        if ((handlerTickByTick = (ITickByTickDataHandler)this.m_tickByTickDataMap.get(reqId)) != null) {
            handlerTickByTick.tickByTickHistoricalTickAllLast(reqId, ticks);
        }
        this.recEOM();
    }

    public void reqTickByTickData(Contract contract, String tickType, int numberOfTicks, boolean ignoreSize, ITickByTickDataHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_tickByTickDataMap.put(reqId, handler);
        this.m_client.reqTickByTickData(reqId, contract, tickType, numberOfTicks, ignoreSize);
        this.sendEOM();
    }

    public void cancelTickByTickData(ITickByTickDataHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer reqId = (Integer)ApiController.getAndRemoveKey((Map)this.m_tickByTickDataMap, (Object)handler);
        if (reqId != null) {
            this.m_client.cancelTickByTickData(reqId.intValue());
            this.sendEOM();
        }
    }

    public void tickByTickAllLast(int reqId, int tickType, long time, double price, Decimal size, TickAttribLast tickAttribLast, String exchange, String specialConditions) {
        ITickByTickDataHandler handler = (ITickByTickDataHandler)this.m_tickByTickDataMap.get(reqId);
        if (handler != null) {
            handler.tickByTickAllLast(reqId, tickType, time, price, size, tickAttribLast, exchange, specialConditions);
        }
        this.recEOM();
    }

    public void tickByTickBidAsk(int reqId, long time, double bidPrice, double askPrice, Decimal bidSize, Decimal askSize, TickAttribBidAsk tickAttribBidAsk) {
        ITickByTickDataHandler handler = (ITickByTickDataHandler)this.m_tickByTickDataMap.get(reqId);
        if (handler != null) {
            handler.tickByTickBidAsk(reqId, time, bidPrice, askPrice, bidSize, askSize, tickAttribBidAsk);
        }
        this.recEOM();
    }

    public void tickByTickMidPoint(int reqId, long time, double midPoint) {
        ITickByTickDataHandler handler = (ITickByTickDataHandler)this.m_tickByTickDataMap.get(reqId);
        if (handler != null) {
            handler.tickByTickMidPoint(reqId, time, midPoint);
        }
        this.recEOM();
    }

    public void orderBound(long orderId, int apiClientId, int apiOrderId) {
        this.show("Order bound. OrderId: " + orderId + ", apiClientId: " + apiClientId + ", apiOrderId: " + apiOrderId);
    }

    public void reqCompletedOrders(ICompletedOrdersHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_completedOrdersHandler = handler;
        this.m_client.reqCompletedOrders(false);
        this.sendEOM();
    }

    public void completedOrder(Contract contract, Order order, OrderState orderState) {
        if (this.m_completedOrdersHandler != null) {
            this.m_completedOrdersHandler.completedOrder(contract, order, orderState);
        }
        this.recEOM();
    }

    public void completedOrdersEnd() {
        if (this.m_completedOrdersHandler != null) {
            this.m_completedOrdersHandler.completedOrdersEnd();
        }
        this.recEOM();
    }

    public void reqWshMetaData(IWshMetaDataHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_wshMetaDataMap.put(reqId, handler);
        this.m_client.reqWshMetaData(reqId);
        this.sendEOM();
    }

    public void cancelWshMetaData(IWshMetaDataHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer reqId = (Integer)ApiController.getAndRemoveKey((Map)this.m_wshMetaDataMap, (Object)handler);
        if (reqId != null) {
            this.m_client.cancelWshMetaData(reqId.intValue());
            this.sendEOM();
        }
    }

    public void wshMetaData(int reqId, String dataJson) {
        IWshMetaDataHandler handler = (IWshMetaDataHandler)this.m_wshMetaDataMap.get(reqId);
        if (handler != null) {
            handler.wshMetaData(reqId, dataJson);
        }
        this.recEOM();
    }

    public void reqWshEventData(WshEventData wshEventData, IWshEventDataHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_wshEventDataMap.put(reqId, handler);
        this.m_client.reqWshEventData(reqId, wshEventData);
        this.sendEOM();
    }

    public void cancelWshEventData(IWshEventDataHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer reqId = (Integer)ApiController.getAndRemoveKey((Map)this.m_wshEventDataMap, (Object)handler);
        if (reqId != null) {
            this.m_client.cancelWshMetaData(reqId.intValue());
            this.sendEOM();
        }
    }

    public void wshEventData(int reqId, String dataJson) {
        IWshEventDataHandler handler = (IWshEventDataHandler)this.m_wshEventDataMap.get(reqId);
        if (handler != null) {
            handler.wshEventData(reqId, dataJson);
        }
        this.recEOM();
    }

    public void reqHistoricalSchedule(Contract contract, String endDateTime, int duration, Types.DurationUnit durationUnit, boolean rthOnly, IHistoricalScheduleHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        int reqId = this.m_reqId++;
        this.m_historicalScheduleMap.put(reqId, handler);
        String durationStr = duration + " " + durationUnit.toString().charAt(0);
        this.m_client.reqHistoricalData(reqId, contract, endDateTime, durationStr, Types.BarSize._1_day.toString(), Types.WhatToShow.SCHEDULE.name(), rthOnly ? 1 : 0, 2, false, Collections.emptyList());
        this.sendEOM();
    }

    public void cancelHistoricalSchedule(IHistoricalScheduleHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer reqId = (Integer)ApiController.getAndRemoveKey((Map)this.m_historicalScheduleMap, (Object)handler);
        if (reqId != null) {
            this.m_client.cancelHistoricalData(reqId.intValue());
            this.sendEOM();
        }
    }

    public void historicalSchedule(int reqId, String startDateTime, String endDateTime, String timeZone, List<HistoricalSession> sessions) {
        IHistoricalScheduleHandler handler = (IHistoricalScheduleHandler)this.m_historicalScheduleMap.get(reqId);
        if (handler != null) {
            handler.historicalSchedule(reqId, startDateTime, endDateTime, timeZone, sessions);
        }
        this.recEOM();
    }

    public void reqUserInfo(int reqId, IUserInfoHandler handler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_userInfoHandler = handler;
        this.m_client.reqUserInfo(reqId);
        this.sendEOM();
    }

    public void userInfo(int reqId, String whiteBrandingId) {
        this.m_userInfoHandler.userInfo(reqId, whiteBrandingId);
        this.recEOM();
    }

    private /* synthetic */ void lambda$startMsgProcessingThread$0(EReaderSignal signal, EReader reader) {
        while (this.client().isConnected()) {
            signal.waitForSignal();
            try {
                reader.processMsgs();
            }
            catch (IOException e) {
                this.error((Exception)e);
            }
        }
    }
}

