/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.Decimal;
import com.ib.client.TickAttribBidAsk;
import com.ib.client.TickAttribLast;

public class TickByTick {
    private int m_tickType;
    private long m_time;
    private double m_price;
    private Decimal m_size;
    private TickAttribLast m_tickAttribLast;
    private TickAttribBidAsk m_tickAttribBidAsk;
    private String m_exchange;
    private String m_specialConditions;
    private double m_bidPrice;
    private Decimal m_bidSize;
    private double m_askPrice;
    private Decimal m_askSize;
    private double m_midPoint;

    public TickByTick(int tickType, long time, double price, Decimal size, TickAttribLast tickAttribLast, String exchange, String specialConditions) {
        this.m_tickType = tickType;
        this.m_time = time;
        this.m_price = price;
        this.m_size = size;
        this.m_tickAttribLast = tickAttribLast;
        this.m_exchange = exchange;
        this.m_specialConditions = specialConditions;
    }

    public TickByTick(long time, double bidPrice, Decimal bidSize, double askPrice, Decimal askSize, TickAttribBidAsk tickAttribBidAsk) {
        this.m_tickType = 3;
        this.m_time = time;
        this.m_bidPrice = bidPrice;
        this.m_bidSize = bidSize;
        this.m_askPrice = askPrice;
        this.m_askSize = askSize;
        this.m_tickAttribBidAsk = tickAttribBidAsk;
    }

    public TickByTick(long time, double midPoint) {
        this.m_tickType = 4;
        this.m_time = time;
        this.m_midPoint = midPoint;
    }

    public int tickType() {
        return this.m_tickType;
    }

    public long time() {
        return this.m_time;
    }

    public double price() {
        return this.m_price;
    }

    public Decimal size() {
        return this.m_size;
    }

    public TickAttribLast tickAttribLast() {
        return this.m_tickAttribLast;
    }

    public TickAttribBidAsk tickAttribBidAsk() {
        return this.m_tickAttribBidAsk;
    }

    public String tickAttribLastStr() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_tickAttribLast.pastLimit() ? "PastLimit " : "");
        sb.append(this.m_tickAttribLast.unreported() ? "Unreported " : "");
        return sb.toString();
    }

    public String tickAttribBidAskStr() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_tickAttribBidAsk.bidPastLow() ? "BidPastLow " : "");
        sb.append(this.m_tickAttribBidAsk.askPastHigh() ? "AskPastHigh " : "");
        return sb.toString();
    }

    public String exchange() {
        return this.m_exchange;
    }

    public String specialConditions() {
        return this.m_specialConditions;
    }

    public double bidPrice() {
        return this.m_bidPrice;
    }

    public Decimal bidSize() {
        return this.m_bidSize;
    }

    public double askPrice() {
        return this.m_askPrice;
    }

    public Decimal askSize() {
        return this.m_askSize;
    }

    public double midPoint() {
        return this.m_midPoint;
    }
}

