/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.Decimal;

public class HistogramEntry
implements Comparable<HistogramEntry> {
    private double price;
    private Decimal size;

    public double price() {
        return this.price;
    }

    public void price(double price) {
        this.price = price;
    }

    public Decimal size() {
        return this.size;
    }

    public void size(Decimal size) {
        this.size = size;
    }

    public HistogramEntry(double price, Decimal size) {
        this.price = price;
        this.size = size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof HistogramEntry)) {
            return false;
        }
        HistogramEntry he = (HistogramEntry)o;
        return Double.compare(this.price, he.price) == 0 && Decimal.compare((Decimal)this.size, (Decimal)he.size) == 0;
    }

    public int hashCode() {
        long tempPrice = Double.doubleToLongBits(this.price);
        int result = (int)(tempPrice ^ tempPrice >>> 32);
        result = 31 * result + this.size.hashCode();
        return result;
    }

    @Override
    public int compareTo(HistogramEntry he) {
        int d = Double.compare(this.price, he.price);
        if (d != 0) {
            return d;
        }
        return Decimal.compare((Decimal)this.size, (Decimal)he.size);
    }

    public String toString() {
        return "HistogramEntry{price=" + this.price + ", size=" + String.valueOf(this.size) + "}";
    }
}

