/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.DefaultEWrapper;
import com.ib.client.EClient;
import com.ib.client.EClientErrors;
import com.ib.client.EClientMsgSink;
import com.ib.client.EClientSocket;
import com.ib.client.EDecoder;
import com.ib.client.EMessage;
import com.ib.client.EReader;
import com.ib.client.EReaderSignal;
import com.ib.client.EWrapper;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;

public class EReader
extends Thread {
    private EClientSocket m_clientSocket;
    private EReaderSignal m_signal;
    private EDecoder m_processMsgsDecoder;
    private static final EWrapper defaultWrapper = new DefaultEWrapper();
    private static final int IN_BUF_SIZE_DEFAULT = 8192;
    private byte[] m_iBuf = new byte[8192];
    private int m_iBufLen = 0;
    private final Deque<EMessage> m_msgQueue = new LinkedList();
    static final int MAX_MSG_LENGTH = 0xFFFFFF;

    protected boolean isUseV100Plus() {
        return this.m_clientSocket.isUseV100Plus();
    }

    protected EClient parent() {
        return this.m_clientSocket;
    }

    private EWrapper eWrapper() {
        return this.parent().wrapper();
    }

    public EReader(EClientSocket parent, EReaderSignal signal) {
        this.m_clientSocket = parent;
        this.m_signal = signal;
        this.m_processMsgsDecoder = new EDecoder(parent.serverVersion(), parent.wrapper(), (EClientMsgSink)parent);
    }

    @Override
    public void run() {
        try {
            while (!this.isInterrupted() && this.putMessageToQueue()) {
            }
        }
        catch (Exception ex) {
            if (ex instanceof EOFException) {
                this.eWrapper().error(-1, EClientErrors.BAD_LENGTH.code(), EClientErrors.BAD_LENGTH.msg() + " " + ex.getMessage(), null);
            } else {
                this.eWrapper().error(ex);
            }
            this.parent().eDisconnect();
        }
        this.m_signal.issueSignal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putMessageToQueue() throws IOException {
        EMessage msg = this.readSingleMessage();
        if (msg == null) {
            return false;
        }
        Deque deque = this.m_msgQueue;
        synchronized (deque) {
            this.m_msgQueue.addFirst(msg);
        }
        this.m_signal.issueSignal();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EMessage getMsg() {
        Deque deque = this.m_msgQueue;
        synchronized (deque) {
            return this.m_msgQueue.isEmpty() ? null : (EMessage)this.m_msgQueue.removeLast();
        }
    }

    public void processMsgs() throws IOException {
        EMessage msg = this.getMsg();
        while (msg != null && this.m_processMsgsDecoder.processMsg(msg) > 0) {
            msg = this.getMsg();
        }
    }

    private EMessage readSingleMessage() throws IOException {
        byte[] tmp;
        int msgSize;
        if (this.isUseV100Plus()) {
            int msgSize2 = 0;
            try {
                msgSize2 = this.m_clientSocket.readInt();
            }
            catch (Exception ex) {
                if (ex instanceof EOFException) {
                    this.parent().connectionError();
                    this.parent().eDisconnect();
                }
                return null;
            }
            if (msgSize2 > 0xFFFFFF) {
                throw new InvalidMessageLengthException("message is too long: " + msgSize2);
            }
            byte[] buf = new byte[msgSize2];
            for (int offset = 0; offset < msgSize2; offset += this.m_clientSocket.read(buf, offset, msgSize2 - offset)) {
            }
            return new EMessage(buf, buf.length);
        }
        if (this.m_iBufLen == 0) {
            this.m_iBufLen = this.appendIBuf();
        }
        while (true) {
            try {
                msgSize = 0;
                if (this.m_iBufLen <= 0) break;
                try (EDecoder decoder = new EDecoder(this.m_clientSocket.serverVersion(), defaultWrapper);){
                    msgSize = decoder.processMsg(new EMessage(this.m_iBuf, this.m_iBufLen));
                }
            }
            catch (IOException e) {
                if (this.m_iBufLen >= this.m_iBuf.length * 3 / 4) {
                    tmp = new byte[this.m_iBuf.length * 2];
                    System.arraycopy(this.m_iBuf, 0, tmp, 0, this.m_iBuf.length);
                    this.m_iBuf = tmp;
                }
                this.m_iBufLen += this.appendIBuf();
                continue;
            }
            break;
        }
        if (msgSize == 0) {
            return null;
        }
        EMessage msg = new EMessage(this.m_iBuf, msgSize);
        System.arraycopy(Arrays.copyOfRange(this.m_iBuf, msgSize, this.m_iBuf.length), 0, this.m_iBuf, 0, this.m_iBuf.length - msgSize);
        this.m_iBufLen -= msgSize;
        if (this.m_iBufLen < 8192 && this.m_iBuf.length > 8192) {
            tmp = new byte[8192];
            System.arraycopy(this.m_iBuf, 0, tmp, 0, tmp.length);
            this.m_iBuf = tmp;
        }
        return msg;
    }

    protected int appendIBuf() throws IOException {
        return this.m_clientSocket.read(this.m_iBuf, this.m_iBufLen, this.m_iBuf.length - this.m_iBufLen);
    }
}

