/*
 * Decompiled with CFR 0.152.
 */
package rsp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mndb.model.Config;
import com.mndb.model.Quote;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import rsp.ImbalanceTrader;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class LiveMarketDataComponent {
    private static final Logger log = LogManager.getLogger(LiveMarketDataComponent.class);
    private final AtomicBoolean stream = new AtomicBoolean(false);
    private final ObjectMapper mapper = new ObjectMapper();
    private final ImbalanceTrader trader = ImbalanceTrader.Instance;
    private final Map<String, String> instrumentOpiteMap = new HashMap();
    private final Set<String> symbols = new HashSet();

    public void testSetup() {
    }

    @PostConstruct
    public void loadInstruments() {
        try (InputStream is = LiveMarketDataComponent.class.getClassLoader().getResourceAsStream("instruments.json");){
            if (is == null) {
                return;
            }
            JsonNode root = this.mapper.readTree(is);
            JsonNode resultNode = root.path("result");
            Iterator fields = resultNode.fields();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                String key = (String)entry.getKey();
                JsonNode array = (JsonNode)entry.getValue();
                if (!array.isArray() || array.isEmpty()) continue;
                String sValue = array.get(0).path("s").asText();
                this.instrumentOpiteMap.put(sValue, LiveMarketDataComponent.convertSymbolFromDataBento((String)key));
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public void clearSymbols() {
        this.symbols.clear();
    }

    public void addSymbol(String symbol) {
        this.symbols.add(LiveMarketDataComponent.convertSymbolToDataBento((String)symbol));
    }

    protected void startInternal() throws IOException {
        try (Socket socket = new Socket("equs-mini.lsg.databento.com", 13000);){
            String line;
            InputStream is = socket.getInputStream();
            OutputStream os = socket.getOutputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is), 32768);
            log.info(reader.readLine());
            String cram = reader.readLine();
            log.info(cram);
            String a = this.auth(cram.split("cram=")[1], "EQUS.MINI");
            os.write(a.getBytes(StandardCharsets.UTF_8));
            os.write("\n".getBytes(StandardCharsets.UTF_8));
            os.flush();
            String authResult = reader.readLine();
            log.info(authResult);
            String[] tokens = authResult.split("\\|");
            if (tokens.length != 2 || !tokens[0].equals("success=1")) {
                throw new RuntimeException("Invalid auth response");
            }
            os.write(this.subscribe(this.symbols.stream().toList()).getBytes(StandardCharsets.UTF_8));
            os.write(this.startSession().getBytes(StandardCharsets.UTF_8));
            os.flush();
            long lastTimeNano = 0L;
            Quote quote = new Quote();
            while ((line = reader.readLine()) != null) {
                JsonNode body = this.mapper.readTree(line);
                if (Quote.fromDatabento((Quote)quote, (JsonNode)body)) {
                    quote.symbol = (String)this.instrumentOpiteMap.get(quote.instrumentId);
                    if (quote.timeNano >= lastTimeNano) {
                        lastTimeNano = quote.timeNano;
                        this.trader.handleQuote(quote);
                    }
                }
                if (this.stream.get()) continue;
                log.info("stream = false. So will stop stock streaming.");
                return;
            }
        }
    }

    public String auth(String cram, String dataset) {
        String key = "db-iXJFVr5gFAeuqvqL5RJrmkQMkGGcm";
        String str = "%s|%s".formatted(cram, key);
        String sha = this.sha256(str);
        return "auth=%s-%s|dataset=%s|encoding=json|ts_out=1".formatted(sha.substring(0, 64), key.substring(key.length() - 5), dataset);
    }

    private String subscribe(List<String> symbols) {
        return "schema=mbp-1|stype_in=raw_symbol|symbols=%s\n".formatted(String.join((CharSequence)",", symbols));
    }

    private String startSession() {
        return "start_session=1\n";
    }

    private String sha256(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not found!", e);
        }
    }

    @Async(value="marketExecutor")
    public void start() {
        if (!this.stream.get()) {
            this.stream.set(true);
            log.info("stream stock info from thread {}", (Object)Thread.currentThread().getName());
            this.trader.isConnectedMarketData.set(true);
            int problemCount = 0;
            while (problemCount < 5 && this.stream.get()) {
                try {
                    if (this.symbols.isEmpty()) break;
                    this.startInternal();
                }
                catch (Exception e) {
                    log.error((Object)e);
                    ++problemCount;
                }
            }
            this.stream.set(false);
            this.trader.isConnectedMarketData.set(false);
        }
    }

    public void stop() {
        if (this.stream.get()) {
            this.stream.set(false);
            this.trader.isConnectedMarketData.set(false);
        }
    }

    public void confChanged(Config conf) {
    }

    public static String convertSymbolFromDataBento(String symbol) {
        return symbol.replaceAll("-", ".PR");
    }

    public static String convertSymbolToDataBento(String symbol) {
        return symbol.replaceAll("\\.PR", "-");
    }
}

