/*
 * Decompiled with CFR 0.152.
 */
package rsp;

import com.mndb.model.Order;
import com.mndb.model.Quote;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import quickfix.FieldNotFound;
import quickfix.Message;
import rsp.AppHandler;
import rsp.ImbalanceTrader;

/*
 * Exception performing whole class analysis ignored.
 */
public enum ImbalanceTrader {
    Instance;

    private static final Logger log;
    public final AtomicBoolean started = new AtomicBoolean(false);
    public final AtomicBoolean simulate = new AtomicBoolean(false);
    public final AtomicBoolean foundBestImbalances = new AtomicBoolean(false);
    public final int defaultSize = 100;
    public final double defaultProfit = 0.05;
    public final double minSpread = 0.04;
    public final String destination = "NYSP";
    public final boolean disableOrderModifications = true;
    public final Map<String, OrderChain> orders = new HashMap();
    public AppHandler delegate;
    public final AtomicBoolean isConnectedMarketData = new AtomicBoolean(false);
    public final AtomicBoolean isConnectedOrderProcessor = new AtomicBoolean(false);
    private final AtomicInteger orderId = new AtomicInteger(8000);
    private static final double EPSILON = 1.0E-9;

    public int nextOrderId() {
        return this.orderId.incrementAndGet();
    }

    public static double round(double val) {
        val *= 1000.0;
        val = Math.round(val);
        return val / 1000.0;
    }

    public static double round2(double val) {
        val *= 100.0;
        val = Math.round(val);
        return val / 100.0;
    }

    public static double round(double val, boolean roundUp) {
        val = roundUp ? Math.ceil(val) : Math.floor(val *= 100.0);
        return val / 100.0;
    }

    public void handleQuote(Quote quote) {
        OrderChain oc = (OrderChain)this.orders.get(quote.symbol);
        if (oc != null) {
            oc.ask.set(quote.ask);
            oc.bid.set(quote.bid);
            return;
        }
    }

    public void handleQuoteAsk(String symbol, double ask) {
        OrderChain o = (OrderChain)this.orders.get(symbol);
        if (o != null) {
            o.ask.set(ask);
        }
    }

    public void handleQuoteBid(String symbol, double bid) {
        OrderChain o = (OrderChain)this.orders.get(symbol);
        if (o != null) {
            o.bid.set(bid);
        }
    }

    public void handleImbalance(String symbol, double imbalance) {
        OrderChain o = (OrderChain)this.orders.get(symbol);
        if (o != null) {
            if (imbalance > -10.0 && imbalance < 10.0) {
                return;
            }
            if (o.imbalance.get() > 0L && imbalance < 0.0 || o.imbalance.get() < 0L && imbalance > 0.0) {
                o.isTradable.set(false);
                this.tryToCloseOpenPosition(o);
            }
        }
    }

    public void handleNew(OrderChain oc, int orderId, String execId) {
        MktOrder mkt = (MktOrder)oc.mkt.get();
        LmtOrder lmt = (LmtOrder)oc.lmt.get();
        LmtOrder lmtEntry = (LmtOrder)oc.lmtEntry.get();
        LmtOrder lmtExit = (LmtOrder)oc.lmtExit.get();
        LmtOrder exitOrder = (LmtOrder)oc.exitOrder.get();
        if (mkt != null && mkt.orderId == orderId) {
            mkt.setAck(true);
            return;
        }
        if (lmt != null && lmt.orderId == orderId) {
            lmt.setAck(true);
            return;
        }
        if (lmtEntry != null && lmtEntry.orderId == orderId) {
            lmtEntry.setAck(true);
            return;
        }
        if (lmtExit != null && lmtExit.orderId == orderId) {
            lmtExit.setAck(true);
            return;
        }
        if (exitOrder != null && exitOrder.orderId == orderId) {
            exitOrder.setAck(true);
            return;
        }
    }

    public void handleReplaced(OrderChain oc, int orderId, String execId) {
    }

    public void handlePartial(OrderChain oc, double price, double filledSize, double remainingOrderQty, int orderId) {
        long filledSizeLong = Double.valueOf(filledSize).longValue();
        long remainingSizeLong = Double.valueOf(remainingOrderQty).longValue();
        log.info("Handle PARTIAL_FILL order: {} {} with price: {} filledSize: {} remainingSize {}", (Object)oc.symbol, (Object)orderId, (Object)price, (Object)filledSizeLong, (Object)remainingSizeLong);
        MktOrder mkt = (MktOrder)oc.mkt.get();
        LmtOrder lmt = (LmtOrder)oc.lmt.get();
        LmtOrder lmtEntry = (LmtOrder)oc.lmtEntry.get();
        LmtOrder lmtExit = (LmtOrder)oc.lmtExit.get();
        LmtOrder exitOrder = (LmtOrder)oc.exitOrder.get();
        if (mkt != null && mkt.orderId == orderId) {
            mkt.fillSize(filledSizeLong);
            return;
        }
        if (lmt != null && lmt.orderId == orderId && mkt != null) {
            lmt.fillSize(filledSizeLong);
            return;
        }
        if (lmtEntry != null && (lmtEntry.orderId == orderId || lmtEntry.prevOrderId == orderId) && mkt != null) {
            lmtEntry.fillSize(filledSizeLong);
            return;
        }
        if (lmtExit != null && (lmtExit.orderId == orderId || lmtExit.prevOrderId == orderId) && mkt != null) {
            lmtExit.fillSize(filledSizeLong);
            return;
        }
    }

    public void handleFill(OrderChain oc, double price, double filledSize, double remainingSize, int orderId) {
        long filledSizeLong = Double.valueOf(filledSize).longValue();
        long remainingSizeLong = Double.valueOf(remainingSize).longValue();
        log.info("Handle FILL order: {} {} with price: {} filledSize: {} remainingSize {}", (Object)oc.symbol, (Object)orderId, (Object)price, (Object)filledSizeLong, (Object)remainingSizeLong);
        if (oc == null) {
            log.error("PANIC, oc is null {}", (Object)orderId);
            return;
        }
        if (!oc.isTradable.get()) {
            log.error("PANIC, order is not tradable {}", (Object)orderId);
            return;
        }
        MktOrder mkt = (MktOrder)oc.mkt.get();
        LmtOrder lmt = (LmtOrder)oc.lmt.get();
        LmtOrder lmtEntry = (LmtOrder)oc.lmtEntry.get();
        LmtOrder lmtExit = (LmtOrder)oc.lmtExit.get();
        LmtOrder exitOrder = (LmtOrder)oc.exitOrder.get();
        if (mkt != null && mkt.orderId == orderId) {
            if (mkt.isFullFilled()) {
                log.error("PANIC, market order for symbol {} with id {} is full filled, but received the id again!!!", (Object)oc.symbol, (Object)orderId);
                return;
            }
            mkt.fillSize(filledSizeLong);
            mkt.setLastExecPrice(price);
            double lmtPrice = mkt.isLong() ? mkt.lastExecPrice() + 0.05 : mkt.lastExecPrice() - 0.05;
            oc.lmt.set(new LmtOrder(oc.symbol, !mkt.isLong(), this.nextOrderId(), ImbalanceTrader.round2((double)lmtPrice), (int)mkt.filledSize()));
            lmt = (LmtOrder)oc.lmt.get();
            this.delegate.newOrder(Order.LmtOrder((String)String.valueOf(lmt.orderId), (String)(lmt.isLong() ? "buy_to_cover" : "sell"), (String)lmt.symbol, (double)lmt.size, (double)lmt.price.get(), (String)"NYSP", null, (boolean)true));
            return;
        }
        if (lmt != null && lmt.orderId == orderId && mkt != null) {
            if (lmt.isFullFilled()) {
                log.error("PANIC, lmt order for symbol {} with id {} is full filled, but received the id again!!!", (Object)oc.symbol, (Object)orderId);
                return;
            }
            lmt.fillSize(filledSizeLong);
            oc.lmtEntry.set(new LmtOrder(oc.symbol, mkt.isLong(), this.nextOrderId(), mkt.isLong() ? this.buyEntryPrice(oc) : this.shortEntryPrice(oc), (int)lmt.filledSize()));
            lmtEntry = (LmtOrder)oc.lmtEntry.get();
            this.delegate.newOrder(Order.LmtOrder((String)String.valueOf(lmtEntry.orderId), (String)(lmtEntry.isLong() ? "buy" : "sell_short"), (String)lmtEntry.symbol, (double)lmtEntry.size, (double)lmtEntry.price.get(), (String)"NYSP", null, (boolean)true));
            return;
        }
        if (lmtEntry != null && (lmtEntry.orderId == orderId || lmtEntry.prevOrderId == orderId) && mkt != null) {
            if (lmtEntry.isFullFilled()) {
                log.error("PANIC, lmt entry order for symbol {} with id {} is full filled, but received the id again!!!", (Object)oc.symbol, (Object)orderId);
                return;
            }
            lmtEntry.fillSize(filledSizeLong);
            lmtEntry.setLastExecPrice(price);
            oc.lmtExit.set(new LmtOrder(oc.symbol, !mkt.isLong(), this.nextOrderId(), mkt.isLong() ? this.buyExitPrice(oc) : this.sellExitPrice(oc), (int)lmtEntry.filledSize()));
            lmtExit = (LmtOrder)oc.lmtExit.get();
            this.delegate.newOrder(Order.LmtOrder((String)String.valueOf(lmtExit.orderId), (String)(lmtExit.isLong() ? "buy_to_cover" : "sell"), (String)lmtExit.symbol, (double)lmtExit.size, (double)lmtExit.price.get(), (String)"NYSP", null, (boolean)true));
            return;
        }
        if (lmtExit != null && (lmtExit.orderId == orderId || lmtExit.prevOrderId == orderId) && mkt != null) {
            if (lmtExit.isFullFilled()) {
                log.error("PANIC, lmt exit entry order for symbol {} with id {} is full filled, but received the id again!!!", (Object)oc.symbol, (Object)orderId);
                return;
            }
            lmtExit.fillSize(filledSizeLong);
            oc.lmtEntry.set(new LmtOrder(oc.symbol, mkt.isLong(), this.nextOrderId(), mkt.isLong() ? this.buyEntryPrice(oc) : this.shortEntryPrice(oc), (int)lmtExit.filledSize()));
            lmtEntry = (LmtOrder)oc.lmtEntry.get();
            this.delegate.newOrder(Order.LmtOrder((String)String.valueOf(lmtEntry.orderId), (String)(lmtEntry.isLong() ? "buy" : "sell_short"), (String)lmtEntry.symbol, (double)lmtEntry.size, (double)lmtEntry.price.get(), (String)"NYSP", null, (boolean)true));
            return;
        }
        if (exitOrder != null && exitOrder.orderId == orderId) {
            exitOrder.fillSize(filledSizeLong);
            log.info("Handle close order no more action required");
            return;
        }
        log.error("PANIC, order id {} is not found for symbol {}", (Object)orderId, (Object)oc.symbol);
        for (String key : this.orders.keySet()) {
            OrderChain orderChain = (OrderChain)this.orders.get(key);
            log.error("PANIC, order chain {}", (Object)orderChain);
        }
    }

    public void handleCancel(OrderChain chain, int orderId) {
        log.info("Handle CANCEL order: {} with orderId {}", (Object)chain.symbol, (Object)orderId);
        if (chain == null) {
            log.error("PANIC, oc is null {}", (Object)orderId);
            return;
        }
        MktOrder mkt = (MktOrder)chain.mkt.get();
        LmtOrder lmt = (LmtOrder)chain.lmt.get();
        LmtOrder lmtEntry = (LmtOrder)chain.lmtEntry.get();
        LmtOrder lmtExit = (LmtOrder)chain.lmtExit.get();
        double ask = chain.ask.get();
        double bid = chain.bid.get();
        if (lmt != null && lmt.cancelId.get() == (long)orderId) {
            this.delegate.newOrder(Order.MktOrder((String)Integer.toString(this.nextOrderId()), (String)(mkt.isLong() ? "sell" : "buy_to_cover"), (String)chain.symbol, (double)mkt.filledSize(), (String)"NYSP", null));
            return;
        }
        if (lmtEntry != null && lmtEntry.cancelId.get() == (long)orderId) {
            return;
        }
        if (lmtExit != null && lmtExit.cancelId.get() == (long)orderId && lmtEntry != null) {
            this.delegate.newOrder(Order.MktOrder((String)Integer.toString(this.nextOrderId()), (String)(lmtEntry.isLong() ? "sell" : "buy_to_cover"), (String)chain.symbol, (double)lmtEntry.filledSize(), (String)"NYSP", null));
            return;
        }
    }

    public void tryToCloseActiveOrders() {
        this.orders.forEach((symbol, oc) -> this.tryToCloseOpenPosition(oc));
    }

    public void tryToCloseOpenPosition(OrderChain chain) {
        chain.isTradable.set(false);
        LmtOrder lmt = (LmtOrder)chain.lmt.get();
        LmtOrder lmtEntry = (LmtOrder)chain.lmtEntry.get();
        LmtOrder lmtExit = (LmtOrder)chain.lmtExit.get();
        if (lmt != null && !lmt.isFullFilled() && lmt.cancelId.get() <= 0L) {
            lmt.cancelId.set(this.nextOrderId());
            this.delegate.cancel(Order.Cancel((String)Integer.toString(lmt.orderId), (String)Integer.toString((int)lmt.cancelId.get())));
            return;
        }
        if (lmtEntry != null && !lmtEntry.isFullFilled() && lmtEntry.cancelId.get() <= 0L) {
            lmtEntry.cancelId.set(this.nextOrderId());
            this.delegate.cancel(Order.Cancel((String)Integer.toString(lmtEntry.orderId), (String)Integer.toString((int)lmtEntry.cancelId.get())));
            return;
        }
        if (lmtExit != null && !lmtExit.isFullFilled() && lmtExit.cancelId.get() <= 0L) {
            lmtExit.cancelId.set(this.nextOrderId());
            this.delegate.cancel(Order.Cancel((String)Integer.toString(lmtExit.orderId), (String)Integer.toString((int)lmtExit.cancelId.get())));
            return;
        }
        log.error("PANIC, we have open position for symbol {} but we don't know how to close it because not of the rules are passed. Chain {}", (Object)chain.symbol, (Object)chain);
    }

    public void changeConnectionOfOrderProcessor(boolean isConnected) {
        this.isConnectedOrderProcessor.set(isConnected);
    }

    public void handleExecReport(Message msg) throws FieldNotFound {
        int orderId;
        double originalOrderQty = msg.getDouble(38);
        double execOrderQty = msg.getDouble(32);
        double execPrice = msg.getDouble(31);
        double remainingOrderQty = msg.getDouble(151);
        String symbol = msg.getString(55);
        String symbolSuffix = null;
        try {
            symbolSuffix = msg.getString(65);
        }
        catch (FieldNotFound fieldNotFound) {
            // empty catch block
        }
        String ourOrderId = msg.getString(11);
        String execId = msg.getString(17);
        char type = msg.getChar(150);
        if (symbolSuffix != null && !symbolSuffix.isEmpty()) {
            symbol = String.format("%s.%s", symbol, symbolSuffix);
        }
        try {
            orderId = Integer.parseInt(ourOrderId);
        }
        catch (Exception e) {
            log.error("Invalid order id {}. Maybe is from other system", (Object)ourOrderId);
            return;
        }
        OrderChain oc = (OrderChain)this.orders.get(symbol);
        switch (type) {
            case 'E': {
                log.warn(">> Exec Report [PENDING_REPLACE]: symbol {} orderId {} execId {}", (Object)symbol, (Object)orderId, (Object)execId);
                break;
            }
            case '4': {
                log.warn(">> Exec Report [CANCEL]: symbol {} orderId {} execId {}", (Object)symbol, (Object)orderId, (Object)execId);
                this.handleCancel(oc, orderId);
                break;
            }
            case '0': {
                log.info(">> Exec Report [NEW]: symbol {} orderId {} execId {}", (Object)symbol, (Object)orderId, (Object)execId);
                this.handleNew(oc, orderId, execId);
                break;
            }
            case '5': {
                log.info(">> Exec Report [REPLACED]: symbol {} orderId {} execId {}", (Object)symbol, (Object)orderId, (Object)execId);
                this.handleReplaced(oc, orderId, execId);
                break;
            }
            case '1': {
                log.info(">> Exec Report [PARTIAL_FILL]: symbol {} orderId {} execId {}", (Object)symbol, (Object)orderId, (Object)execId);
                this.handlePartial(oc, execPrice, execOrderQty, remainingOrderQty, orderId);
                log.warn("Skip partial fill");
                break;
            }
            case '2': {
                log.info(">> Exec Report [FILL]: symbol {} orderId {} execId {}", (Object)symbol, (Object)orderId, (Object)execId);
                this.handleFill(oc, execPrice, execOrderQty, remainingOrderQty, orderId);
                break;
            }
            case '8': {
                String reason;
                try {
                    reason = msg.getString(58);
                }
                catch (FieldNotFound fnf) {
                    reason = "message is not exists";
                }
                log.info("== EXEC REPORT [REJECTED] symbol {} order id {} exec id {} reason {}", (Object)symbol, (Object)ourOrderId, (Object)execId, (Object)reason);
                break;
            }
            default: {
                log.info("== EXEC REPORT [{}] NOT HANDLE CASE symbol {} order id {} exec id {}", (Object)Character.valueOf(type), (Object)symbol, (Object)ourOrderId, (Object)execId);
            }
        }
    }

    public static boolean isPriceMidPoint(double price) {
        return Math.abs((price *= 1000.0) - (double)Math.round(price)) < 1.0E-9;
    }

    private double buyEntryPrice(OrderChain ch) {
        return ImbalanceTrader.round2((double)((MktOrder)ch.mkt.get()).lastExecPrice());
    }

    private double shortEntryPrice(OrderChain ch) {
        return ImbalanceTrader.round2((double)((MktOrder)ch.mkt.get()).lastExecPrice());
    }

    private double buyExitPrice(OrderChain ch) {
        return ImbalanceTrader.round2((double)(((MktOrder)ch.mkt.get()).lastExecPrice() + 0.05));
    }

    private double sellExitPrice(OrderChain ch) {
        return ImbalanceTrader.round2((double)(((MktOrder)ch.mkt.get()).lastExecPrice() - 0.05));
    }

    static {
        log = LogManager.getLogger(ImbalanceTrader.class);
    }
}

