/*
 * Decompiled with CFR 0.152.
 */
package rsp;

import com.mndb.model.Order;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.DefaultMessageFactory;
import quickfix.DoNotSend;
import quickfix.FieldNotFound;
import quickfix.FileLogFactory;
import quickfix.FileStoreFactory;
import quickfix.IncorrectDataFormat;
import quickfix.IncorrectTagValue;
import quickfix.LogFactory;
import quickfix.Message;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RejectLogon;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.ThreadedSocketInitiator;
import quickfix.UnsupportedMessageType;
import quickfix.fix44.OrderCancelReplaceRequest;
import quickfix.fix44.OrderCancelRequest;
import rsp.AppHandler;
import rsp.FixApiConnector;
import rsp.ImbalanceTrader;

@Component
@Profile(value={"!test"})
public class FixApiConnector
implements Application,
AppHandler {
    private static final Logger log = LogManager.getLogger(FixApiConnector.class);
    private Session defaultSession;
    private int lastProcessedSeqNum = 0;
    private final Set<String> processedExecIds = new HashSet();
    private final ImbalanceTrader trader = ImbalanceTrader.Instance;

    @PostConstruct
    public void post() {
        this.trader.delegate = this;
    }

    public void connect() throws ConfigError, IOException {
        SessionSettings settings;
        try (InputStream conf = this.getClass().getResourceAsStream("/fix.conf");){
            assert (conf != null);
            settings = new SessionSettings(conf);
        }
        FileStoreFactory storeFactory = new FileStoreFactory(settings);
        FileLogFactory logFactory = new FileLogFactory(settings);
        DefaultMessageFactory messageFactory = new DefaultMessageFactory();
        new ThreadedSocketInitiator((Application)this, (MessageStoreFactory)storeFactory, settings, (LogFactory)logFactory, (MessageFactory)messageFactory).start();
    }

    public void disconnect() {
        if (this.defaultSession != null) {
            this.defaultSession.logout();
        }
    }

    public boolean isLogon() {
        return this.defaultSession != null && this.defaultSession.isLoggedOn();
    }

    public void onCreate(SessionID sessionID) {
        log.info("onCreate sessionID: {}", (Object)sessionID);
        this.defaultSession = Session.lookupSession((SessionID)sessionID);
    }

    public void onLogon(SessionID sessionID) {
        this.defaultSession = Session.lookupSession((SessionID)sessionID);
        log.info("onLogon");
        this.trader.changeConnectionOfOrderProcessor(true);
    }

    public void onLogout(SessionID sessionID) {
        log.info("onLogout sessionID: {}", (Object)sessionID);
        this.trader.changeConnectionOfOrderProcessor(false);
    }

    public void toAdmin(Message message, SessionID sessionID) {
        log.info("toAdmin message: {} sessionID: {}", (Object)message, (Object)sessionID);
        try {
            String msgType = message.getHeader().getString(35);
            if (msgType.equals("D") && message.isSetField(153)) {
                log.info("WARNING: Removing unsupported tag 153 from NewOrderSingle");
                message.removeField(153);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void fromAdmin(Message message, SessionID sessionID) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, RejectLogon {
        log.info("fromAdmin message: {} sessionID: {}", (Object)message, (Object)sessionID);
    }

    public void toApp(Message message, SessionID sessionID) throws DoNotSend {
        log.info("toApp message: {} sessionID: {}", (Object)message, (Object)sessionID);
        try {
            String msgType = message.getHeader().getString(35);
            if (msgType.equals("D") && message.isSetField(153)) {
                log.info("WARNING: Removing unsupported tag 153 from NewOrderSingle");
                message.removeField(153);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void fromApp(Message message, SessionID sessionID) throws FieldNotFound, IncorrectDataFormat, IncorrectTagValue, UnsupportedMessageType {
        int msgSeqNum = message.getHeader().getInt(34);
        boolean possDupFlag = false;
        if (message.getHeader().isSetField(43)) {
            possDupFlag = message.getHeader().getBoolean(43);
        }
        if (possDupFlag && msgSeqNum <= this.lastProcessedSeqNum) {
            log.info("\u0414\u0443\u0431\u043b\u0438\u0440\u0430\u043d\u043e \u0441\u044a\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0441 PossDupFlag. \u0418\u0433\u043d\u043e\u0440\u0438\u0440\u0430\u043d\u0435.");
            return;
        }
        if (message.isSetField(17)) {
            String execId = message.getString(17);
            if (this.processedExecIds.contains(execId)) {
                log.info("\u0414\u0443\u0431\u043b\u0438\u0440\u0430\u043d\u043e \u0441\u044a\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043f\u043e ExecID. \u0418\u0433\u043d\u043e\u0440\u0438\u0440\u0430\u043d\u0435. {}", (Object)execId);
                return;
            }
            this.processedExecIds.add(execId);
        }
        if (8 == message.getHeader().getInt(35)) {
            try {
                this.trader.handleExecReport(message);
            }
            catch (Exception e) {
                log.error(String.format("Error while handle execution %s", e.getMessage()), (Throwable)e);
            }
        }
        this.lastProcessedSeqNum = msgSeqNum;
    }

    @Deprecated
    public void orderRequest(Order order) {
        if (!this.isLogon()) {
            log.error("Not connected to FIX. Order will not be executed. Order details: {}", (Object)order);
        }
        switch (order.getAction()) {
            case "single": {
                this.defaultSession.send((Message)order.toMktOrder());
                break;
            }
            case "single-lmt": {
                this.defaultSession.send((Message)order.toLmtOrder());
                break;
            }
            case "single-mdf": {
                this.defaultSession.send((Message)order.toMdfOrder());
                break;
            }
            case "cancel-pending": {
                this.defaultSession.send((Message)order.toCancelPendingOrder());
            }
        }
    }

    public void cancel(OrderCancelRequest cancel) {
        if (!this.isLogon()) {
            log.error("Not connected to FIX. Order will not be executed. Order details: {}", (Object)cancel);
        }
        this.defaultSession.send((Message)cancel);
    }

    @EventListener(value={NewOrderSingleExtend.class})
    public void newOrder(NewOrderSingleExtend order) {
        if (!this.isLogon()) {
            log.error("Not connected to FIX. Order will not be executed. Order details: {}", (Object)order);
        }
        this.defaultSession.send((Message)order);
    }

    public void mdf(OrderCancelReplaceRequest mdf) {
        if (!this.isLogon()) {
            log.error("Not connected to FIX. Order will not be executed. Order details: {}", (Object)mdf);
        }
        this.defaultSession.send((Message)mdf);
    }
}

