/*
 * Decompiled with CFR 0.152.
 */
package rsp;

import com.ib.controller.ApiController;
import com.mndb.model.Config;
import com.mndb.model.Order;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import quickfix.ConfigError;
import rsp.AppHandler;
import rsp.Application;
import rsp.FixApiConnector;
import rsp.ImbalanceTrader;
import rsp.InteractiveBrokerApiComponent;
import rsp.LiveMarketDataComponent;

@EnableAsync
@SpringBootApplication
@RestController
@EnableScheduling
public class Application {
    private static final Logger log = LogManager.getLogger(Application.class);
    private final FixApiConnector fixApiConnector;
    private final LiveMarketDataComponent marketDataComponent;
    private final InteractiveBrokerApiComponent interactiveBrokerApiComponent;
    private final ImbalanceTrader imbalanceTrader = ImbalanceTrader.Instance;
    private final Map<String, VolImb> volImbMap = new HashMap();
    private long simulateImbalanceChangeTime = System.currentTimeMillis();

    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
    }

    @RequestMapping(value={"/"})
    public String index() {
        return "";
    }

    @PostMapping(value={"/order"})
    public void order(@RequestBody Order order) {
        this.fixApiConnector.orderRequest(order);
    }

    @PostMapping(value={"/order-v2"})
    public void orderV2(@RequestBody Order order) {
        this.fixApiConnector.orderRequest(order);
    }

    @PostMapping(value={"/order-test"})
    public void orderTest(@RequestBody Map<String, String> data) throws ConfigError, IOException {
        this.fixApiConnector.connect();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fixApiConnector.newOrder(Order.MktOrder((String)"1", (String)"buy", (String)data.getOrDefault("symbol", "MFM"), (double)1.0, (String)data.getOrDefault("ex", "NYSP"), null));
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fixApiConnector.disconnect();
    }

    @PostMapping(value={"/order-lmt-test"})
    public void orderLmtTest(@RequestBody Map<String, String> data) throws ConfigError, IOException {
        this.fixApiConnector.connect();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fixApiConnector.newOrder(Order.LmtOrder((String)Integer.toString(this.imbalanceTrader.nextOrderId()), (String)"buy", (String)data.getOrDefault("symbol", "MFM"), (double)Integer.parseInt(data.getOrDefault("size", "1")), (double)Double.parseDouble(data.getOrDefault("price", "1")), (String)data.getOrDefault("ex", "NYSP"), null, (boolean)true));
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fixApiConnector.disconnect();
    }

    @PostMapping(value={"/start-simulation"})
    public void startSimulation() {
        this.imbalanceTrader.simulate.set(true);
    }

    @PostMapping(value={"/stop-simulation"})
    public void stopSimulation() {
        this.imbalanceTrader.simulate.set(false);
    }

    @PostMapping(value={"/force-close"})
    public void forceClose() {
        this.imbalanceTrader.tryToCloseActiveOrders();
    }

    @PostMapping(value={"/start-imbalance"})
    public void startImbalance() throws ConfigError, IOException {
        this.volImbMap.clear();
        HashSet<String> ss = new HashSet<String>();
        int maxCount = 498;
        int currentCount = 1;
        try {
            Scanner sc = new Scanner(new File("./export.csv"));
            while (sc.hasNextLine()) {
                String symbol = sc.nextLine();
                ss.add(symbol.replaceAll(" PR", ".PR"));
                if (currentCount++ <= maxCount) continue;
                break;
            }
        }
        catch (FileNotFoundException fnf) {
            System.exit(0);
        }
        this.volImbMap.putAll(ss.stream().collect(Collectors.toMap(s -> s, s -> new VolImb())));
        this.fixApiConnector.connect();
        this.interactiveBrokerApiComponent.connected();
        HashMap<String, 1> listeners = new HashMap<String, 1>();
        for (String symbol : ss) {
            listeners.put(symbol, new /* Unavailable Anonymous Inner Class!! */);
            this.interactiveBrokerApiComponent.api.reqTopMktData(this.interactiveBrokerApiComponent.buildContract(symbol.replaceAll("\\.PR", " PR")), "225,236,233", false, false, (ApiController.ITopMktDataHandler)listeners.get(symbol));
        }
    }

    @PostMapping(value={"/force-find-imbalance-stocks"})
    public void forceCalcImbalanceStocks() {
        this.calcImbalanceAndVolume();
    }

    @PostMapping(value={"/stop-imbalance"})
    public void stopImbalance() {
        this.fixApiConnector.disconnect();
        this.interactiveBrokerApiComponent.disconnected();
        this.imbalanceTrader.started.set(false);
        this.marketDataComponent.stop();
    }

    @PostMapping(value={"/start"})
    public void start() throws ConfigError, IOException {
        this.marketDataComponent.start();
        this.fixApiConnector.connect();
    }

    @PostMapping(value={"/stop"})
    public void stop() {
        this.marketDataComponent.stop();
        this.fixApiConnector.disconnect();
    }

    @PostMapping(value={"/start-fix"})
    public void startFix() throws ConfigError, IOException {
        this.fixApiConnector.connect();
    }

    @PostMapping(value={"/stop-fix"})
    public void stopFix() {
        this.fixApiConnector.disconnect();
    }

    @PostMapping(value={"/config"})
    public void config(@RequestBody Config config) {
        this.marketDataComponent.confChanged(config);
    }

    @PostMapping(value={"/restart"})
    public void restart() throws IOException {
        new ProcessBuilder("nohup", "bash", "./restart.sh").redirectOutput(ProcessBuilder.Redirect.to(new File("restart-log.txt"))).redirectErrorStream(true).start();
    }

    @Bean(value={"marketExecutor"})
    public Executor marketExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(1);
        executor.setMaxPoolSize(1);
        executor.setQueueCapacity(100);
        executor.setThreadNamePrefix("market-");
        executor.initialize();
        return executor;
    }

    @Scheduled(cron="57 59 15 * * *")
    public void schedule() {
        this.imbalanceTrader.tryToCloseActiveOrders();
    }

    @Scheduled(cron="1 50 15 * * *")
    public void calcImbalanceAndVolume() {
        List<Map.Entry> filtered = this.volImbMap.entrySet().stream().filter(e -> {
            VolImb vi = (VolImb)e.getValue();
            return vi.volume.get() > 0L && Math.abs(vi.imbalance.get()) > 10L;
        }).map(e -> {
            VolImb vi = (VolImb)e.getValue();
            double percent = (double)Math.abs(vi.imbalance.get()) * 1.0 / (double)vi.volume.get() * 100.0;
            return Map.entry((String)e.getKey(), percent);
        }).sorted((e1, e2) -> Double.compare((Double)e2.getValue(), (Double)e1.getValue())).limit(45L).toList();
        log.info("Filtered stocks are {}", filtered);
        filtered.forEach(e -> {
            this.marketDataComponent.addSymbol((String)e.getKey());
            VolImb vi = (VolImb)this.volImbMap.get(e.getKey());
            log.info("Tradable symbol will be {} with imbalance percent {}% imbalance {} and volume {}", e.getKey(), e.getValue(), (Object)vi.imbalance.get(), (Object)vi.volume.get());
            ImbalanceTrader.OrderChain oc = new ImbalanceTrader.OrderChain((String)e.getKey());
            this.imbalanceTrader.orders.put((String)e.getKey(), oc);
            oc.isTradable.set(true);
            oc.volume.set(vi.volume.get());
            oc.imbalance.set(vi.imbalance.get());
            AtomicReference atomicReference = oc.mkt;
            String string = (String)e.getKey();
            boolean bl = vi.imbalance.get() > 10L;
            int n = this.imbalanceTrader.nextOrderId();
            Objects.requireNonNull(this.imbalanceTrader);
            atomicReference.set(new ImbalanceTrader.MktOrder(string, bl, n, 100));
            ImbalanceTrader.MktOrder mkt = (ImbalanceTrader.MktOrder)oc.mkt.get();
            AppHandler appHandler = this.imbalanceTrader.delegate;
            String string2 = Integer.toString(mkt.orderId);
            String string3 = mkt.isLong() ? "buy" : "sell_short";
            String string4 = mkt.symbol;
            double d = mkt.size;
            Objects.requireNonNull(this.imbalanceTrader);
            appHandler.newOrder(Order.MktOrder((String)string2, (String)string3, (String)string4, (double)d, (String)"NYSP", null));
        });
        this.marketDataComponent.start();
        this.imbalanceTrader.started.set(true);
    }

    public Application(FixApiConnector fixApiConnector, LiveMarketDataComponent marketDataComponent, InteractiveBrokerApiComponent interactiveBrokerApiComponent) {
        this.fixApiConnector = fixApiConnector;
        this.marketDataComponent = marketDataComponent;
        this.interactiveBrokerApiComponent = interactiveBrokerApiComponent;
    }
}

