/*
 * Decompiled with CFR 0.152.
 */
package com.mndb.model;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;

public class Quote {
    public String symbol;
    public String instrumentId;
    public long time;
    public long timeNano;
    public double ask;
    public double bid;
    public boolean isLong;

    public void reset() {
        this.symbol = null;
        this.instrumentId = null;
        this.time = 0L;
        this.timeNano = 0L;
        this.ask = 0.0;
        this.bid = 0.0;
        this.isLong = false;
    }

    public String toString() {
        return String.format("Q => time: %s, symbol: %s, ask: %s, bid: %s", this.time, this.symbol, this.ask, this.bid);
    }

    public static Quote fromMap(Map map) {
        Quote q = new Quote();
        q.symbol = ((String)map.get("s")).replaceAll("_S U", "");
        q.timeNano = Long.parseLong((String)map.get("tm"));
        q.time = q.timeNano / 1000000L;
        if (map.containsKey("a")) {
            q.ask = Double.parseDouble((String)map.get("a"));
        }
        if (map.containsKey("b")) {
            q.bid = Double.parseDouble((String)map.get("b"));
        }
        return q;
    }

    public static Quote fromDatabento(Map map) {
        if (map.get("action") == null || !"A".equals(map.get("action")) && !"M".equals(map.get("action"))) {
            return null;
        }
        Quote q = new Quote();
        q.instrumentId = String.valueOf(((Map)map.get("hd")).get("instrument_id"));
        q.timeNano = Long.parseLong((String)map.get("ts_recv"));
        q.time = q.timeNano / 1000000L;
        if (!map.containsKey("levels")) {
            return null;
        }
        Map levels = (Map)((List)map.get("levels")).get(0);
        if (levels.containsKey("ask_px")) {
            q.ask = Double.parseDouble((String)levels.get("ask_px")) / 1.0E9;
        }
        if (levels.containsKey("bid_px")) {
            q.bid = Double.parseDouble((String)levels.get("bid_px")) / 1.0E9;
        }
        if (q.ask == 0.0 && q.bid == 0.0) {
            return null;
        }
        return q;
    }

    public static boolean fromDatabento(Quote q, JsonNode map) {
        if (map.path("action") == null || !"A".equals(map.path("action").asText()) && !"M".equals(map.path("action").asText())) {
            return false;
        }
        q.reset();
        JsonNode levels = map.path("levels");
        JsonNode hd = map.path("hd");
        q.instrumentId = hd.path("instrument_id").asText();
        q.timeNano = map.path("ts_recv").asLong();
        q.time = q.timeNano / 1000000L;
        if (levels == null) {
            return false;
        }
        JsonNode zeroEl = levels.get(0);
        JsonNode el = zeroEl.path("ask_px");
        if (el != null) {
            q.ask = el.asDouble() / 1.0E9;
        }
        if ((el = zeroEl.path("bid_px")) != null) {
            q.bid = el.asDouble() / 1.0E9;
        }
        return q.ask != 0.0 || q.bid != 0.0;
    }
}

