/*
 * Decompiled with CFR 0.152.
 */
package com.mndb.model;

import com.mndb.model.Order;
import quickfix.StringField;
import quickfix.field.ClOrdID;
import quickfix.field.ExDestination;
import quickfix.field.OrdType;
import quickfix.field.OrderQty;
import quickfix.field.OrigClOrdID;
import quickfix.field.Price;
import quickfix.field.Side;
import quickfix.field.Symbol;
import quickfix.field.TimeInForce;
import quickfix.fix44.OrderCancelReplaceRequest;
import quickfix.fix44.OrderCancelRequest;
import rsp.FixApiConnector;

/*
 * Exception performing whole class analysis ignored.
 */
public class Order {
    private String action = "single";
    private String orderId;
    private String newOrderId;
    private String side = "buy";
    private String symbol = "IBM";
    private Double quantity = 1.0;
    private String destination = "INET-FIX";
    private String currency = "USD";
    private String securityExchange = "NASDAQ";
    private String securityType = "STK";
    private double price = 0.0;

    public static Order from(Action action, String orderId, String symbol, double quantity, String side, double price, String exchange) {
        return new Order(action.v(), orderId, "", side, symbol, Double.valueOf(quantity), exchange, "USD", exchange, "STK", price);
    }

    public FixApiConnector.NewOrderSingleExtend toMktOrder() {
        FixApiConnector.NewOrderSingleExtend single = new FixApiConnector.NewOrderSingleExtend();
        single.set(new ClOrdID(this.orderId));
        single.set(new Side(Order.side((String)this.side)));
        single.set(new OrdType('1'));
        single.set(new Symbol(this.symbol));
        single.set(new OrderQty(this.quantity.doubleValue()));
        single.set(new ExDestination(this.destination));
        return single;
    }

    public FixApiConnector.NewOrderSingleExtend toLmtOrder() {
        FixApiConnector.NewOrderSingleExtend single = new FixApiConnector.NewOrderSingleExtend();
        single.set(new ClOrdID(this.orderId));
        single.set(new Side(Order.side((String)this.side)));
        single.set(new OrdType('2'));
        single.set(new Price(this.price));
        single.set(new Symbol(this.symbol));
        single.set(new OrderQty(this.quantity.doubleValue()));
        single.set(new ExDestination(this.destination));
        single.set(new TimeInForce('0'));
        return single;
    }

    public OrderCancelReplaceRequest toMdfOrder() {
        OrderCancelReplaceRequest ocrr = new OrderCancelReplaceRequest();
        ocrr.set(new ClOrdID(this.newOrderId));
        ocrr.set(new OrigClOrdID(this.orderId));
        ocrr.set(new OrdType('2'));
        ocrr.set(new Price(this.price));
        ocrr.set(new OrderQty(this.quantity.doubleValue()));
        return ocrr;
    }

    public OrderCancelRequest toCancelPendingOrder() {
        OrderCancelRequest ocr = new OrderCancelRequest();
        ocr.set(new ClOrdID(this.newOrderId));
        ocr.set(new OrigClOrdID(this.orderId));
        return ocr;
    }

    public static OrderCancelRequest Cancel(String orderIdToCancel, String newOrderId) {
        OrderCancelRequest ocr = new OrderCancelRequest();
        ocr.set(new ClOrdID(newOrderId));
        ocr.set(new OrigClOrdID(orderIdToCancel));
        return ocr;
    }

    public static OrderCancelRequest CancelAll(String orderIdToCancel, String newOrderId) {
        FixApiConnector.OrderCancelRequestExtend ocr = new FixApiConnector.OrderCancelRequestExtend();
        ocr.set(new ClOrdID(newOrderId));
        ocr.set(new OrigClOrdID(orderIdToCancel));
        ocr.set(new StringField(9020, "Y"));
        return ocr;
    }

    public static FixApiConnector.NewOrderSingleExtend LmtOrder(String orderId, String side, String symbol, double quantity, double price, String destination, String strategy, boolean hidden) {
        FixApiConnector.NewOrderSingleExtend single = new FixApiConnector.NewOrderSingleExtend();
        single.set(new ClOrdID(orderId));
        single.set(new Side(Order.side((String)side)));
        single.set(new OrdType('2'));
        single.set(new Price(price));
        single.set(new Symbol(symbol));
        single.set(new OrderQty(quantity));
        single.set(new ExDestination(destination));
        single.set(new TimeInForce('0'));
        if (strategy != null) {
            single.set(new StringField(9100, strategy));
        }
        if (hidden) {
            single.set(new StringField(9003, "Y"));
        }
        return single;
    }

    public static OrderCancelReplaceRequest MdfOrder(String orderToModify, String newOrderId, double price, double quantity) {
        OrderCancelReplaceRequest ocrr = new OrderCancelReplaceRequest();
        ocrr.set(new ClOrdID(newOrderId));
        ocrr.set(new OrigClOrdID(orderToModify));
        ocrr.set(new OrdType('2'));
        ocrr.set(new Price(price));
        ocrr.set(new OrderQty(quantity));
        return ocrr;
    }

    public static OrderCancelReplaceRequest Copy(OrderCancelReplaceRequest mdf, String orderToModify) {
        try {
            OrderCancelReplaceRequest ocrr = new OrderCancelReplaceRequest();
            ocrr.set(new ClOrdID(mdf.getClOrdID().getValue()));
            ocrr.set(new OrigClOrdID(orderToModify));
            ocrr.set(new OrdType('2'));
            ocrr.set(new Price(mdf.getPrice().getValue()));
            ocrr.set(new OrderQty(mdf.getOrderQty().getValue()));
            return ocrr;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static FixApiConnector.NewOrderSingleExtend MktOrder(String orderId, String side, String symbol, double quantity, String destination, String strategy) {
        FixApiConnector.NewOrderSingleExtend single = new FixApiConnector.NewOrderSingleExtend();
        single.set(new ClOrdID(orderId));
        single.set(new Side(Order.side((String)side)));
        single.set(new OrdType('1'));
        single.set(new Symbol(symbol));
        single.set(new OrderQty(quantity));
        single.set(new ExDestination(destination));
        if (strategy != null) {
            single.set(new StringField(9100, strategy));
        }
        return single;
    }

    public static char side(String side) {
        switch (side) {
            case "buy": {
                return '1';
            }
            case "sell": {
                return '2';
            }
            case "sell_short": {
                return '5';
            }
            case "buy_to_cover": {
                return '9';
            }
        }
        throw new RuntimeException("Not supported side: " + side);
    }

    public static OrderBuilder builder() {
        return new OrderBuilder();
    }

    public String getAction() {
        return this.action;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getNewOrderId() {
        return this.newOrderId;
    }

    public String getSide() {
        return this.side;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Double getQuantity() {
        return this.quantity;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getSecurityExchange() {
        return this.securityExchange;
    }

    public String getSecurityType() {
        return this.securityType;
    }

    public double getPrice() {
        return this.price;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setNewOrderId(String newOrderId) {
        this.newOrderId = newOrderId;
    }

    public void setSide(String side) {
        this.side = side;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setSecurityExchange(String securityExchange) {
        this.securityExchange = securityExchange;
    }

    public void setSecurityType(String securityType) {
        this.securityType = securityType;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Order)) {
            return false;
        }
        Order other = (Order)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (Double.compare(this.getPrice(), other.getPrice()) != 0) {
            return false;
        }
        Double this$quantity = this.getQuantity();
        Double other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$orderId = this.getOrderId();
        String other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
            return false;
        }
        String this$newOrderId = this.getNewOrderId();
        String other$newOrderId = other.getNewOrderId();
        if (this$newOrderId == null ? other$newOrderId != null : !this$newOrderId.equals(other$newOrderId)) {
            return false;
        }
        String this$side = this.getSide();
        String other$side = other.getSide();
        if (this$side == null ? other$side != null : !this$side.equals(other$side)) {
            return false;
        }
        String this$symbol = this.getSymbol();
        String other$symbol = other.getSymbol();
        if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
            return false;
        }
        String this$destination = this.getDestination();
        String other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$securityExchange = this.getSecurityExchange();
        String other$securityExchange = other.getSecurityExchange();
        if (this$securityExchange == null ? other$securityExchange != null : !this$securityExchange.equals(other$securityExchange)) {
            return false;
        }
        String this$securityType = this.getSecurityType();
        String other$securityType = other.getSecurityType();
        return !(this$securityType == null ? other$securityType != null : !this$securityType.equals(other$securityType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Order;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $price = Double.doubleToLongBits(this.getPrice());
        result = result * 59 + (int)($price >>> 32 ^ $price);
        Double $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
        String $newOrderId = this.getNewOrderId();
        result = result * 59 + ($newOrderId == null ? 43 : $newOrderId.hashCode());
        String $side = this.getSide();
        result = result * 59 + ($side == null ? 43 : $side.hashCode());
        String $symbol = this.getSymbol();
        result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
        String $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $securityExchange = this.getSecurityExchange();
        result = result * 59 + ($securityExchange == null ? 43 : $securityExchange.hashCode());
        String $securityType = this.getSecurityType();
        result = result * 59 + ($securityType == null ? 43 : $securityType.hashCode());
        return result;
    }

    public String toString() {
        return "Order(action=" + this.getAction() + ", orderId=" + this.getOrderId() + ", newOrderId=" + this.getNewOrderId() + ", side=" + this.getSide() + ", symbol=" + this.getSymbol() + ", quantity=" + this.getQuantity() + ", destination=" + this.getDestination() + ", currency=" + this.getCurrency() + ", securityExchange=" + this.getSecurityExchange() + ", securityType=" + this.getSecurityType() + ", price=" + this.getPrice() + ")";
    }

    public Order() {
    }

    public Order(String action, String orderId, String newOrderId, String side, String symbol, Double quantity, String destination, String currency, String securityExchange, String securityType, double price) {
        this.action = action;
        this.orderId = orderId;
        this.newOrderId = newOrderId;
        this.side = side;
        this.symbol = symbol;
        this.quantity = quantity;
        this.destination = destination;
        this.currency = currency;
        this.securityExchange = securityExchange;
        this.securityType = securityType;
        this.price = price;
    }
}

