/*
 * Decompiled with CFR 0.152.
 */
package com.mndb.model;

import java.util.concurrent.atomic.AtomicLong;

public class AtomicDouble {
    private final AtomicLong bits;

    public AtomicDouble(double initialValue) {
        this.bits = new AtomicLong(Double.doubleToRawLongBits(initialValue));
    }

    public final double get() {
        return Double.longBitsToDouble(this.bits.get());
    }

    public final void set(double newValue) {
        this.bits.set(Double.doubleToRawLongBits(newValue));
    }

    public final boolean compareAndSet(double expect, double update) {
        return this.bits.compareAndSet(Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update));
    }

    public final double getAndSet(double newValue) {
        return Double.longBitsToDouble(this.bits.getAndSet(Double.doubleToRawLongBits(newValue)));
    }

    public final double addAndGet(double delta) {
        double next;
        double current;
        while (!this.compareAndSet(current = this.get(), next = current + delta)) {
        }
        return next;
    }
}

