/*
 * Decompiled with CFR 0.152.
 */
package com.ib.controller;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Formats {
    private static final Format FMT8 = new DecimalFormat("#,##0.00000000");
    private static final Format FMT2 = new DecimalFormat("#,##0.00");
    private static final Format FMT0 = new DecimalFormat("#,##0");
    private static final Format PCT = new DecimalFormat("0.0%");
    private static final ThreadLocal<DateFormat> GMT_DATE_TIME_FORMAT_CACHE = ThreadLocal.withInitial(() -> {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd-HH:mm:ss");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format;
    });
    private static final ThreadLocal<DateFormat> DATE_TIME_FORMAT_CACHE = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMdd-HH:mm:ss"));
    private static final ThreadLocal<DateFormat> TIME_FORMAT_CACHE = ThreadLocal.withInitial(() -> new SimpleDateFormat("HH:mm:ss"));

    public static String fmt8(double v) {
        return v == Double.MAX_VALUE ? null : FMT8.format(v);
    }

    public static String fmt(double v) {
        return v == Double.MAX_VALUE ? null : FMT2.format(v);
    }

    public static String fmtNz(double v) {
        return v == Double.MAX_VALUE || v == 0.0 ? null : FMT2.format(v);
    }

    public static String fmt0(double v) {
        return v == Double.MAX_VALUE ? null : FMT0.format(v);
    }

    public static String fmtPct(double v) {
        return v == Double.MAX_VALUE ? null : PCT.format(v);
    }

    public static String fmtDate(long ms) {
        return ((DateFormat)DATE_TIME_FORMAT_CACHE.get()).format(new Date(ms));
    }

    public static String fmtDateGmt(long ms) {
        return ((DateFormat)GMT_DATE_TIME_FORMAT_CACHE.get()).format(new Date(ms));
    }

    public static String fmtTime(long ms) {
        return ((DateFormat)TIME_FORMAT_CACHE.get()).format(new Date(ms));
    }
}

