/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.Contract;
import com.ib.client.ContractDetails;
import com.ib.client.Decimal;
import com.ib.controller.ApiController;
import com.ib.controller.Formats;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

/*
 * Exception performing whole class analysis ignored.
 */
public class Util {
    public static final String SPACE_SYMBOL = " ";
    public static final String EQUALS_SIGN = "=";

    public static String decimalToStringNoZero(Decimal value) {
        return Decimal.isValidNotZeroValue((Decimal)value) ? value.toString() : "";
    }

    public static boolean isValidValue(double value) {
        return value != Double.MAX_VALUE && !Double.isNaN(value) && !Double.isInfinite(value);
    }

    public static boolean StringIsEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String NormalizeString(String str) {
        return str != null ? str : "";
    }

    public static int StringCompare(String lhs, String rhs) {
        return Util.NormalizeString((String)lhs).compareTo(Util.NormalizeString((String)rhs));
    }

    public static int StringCompareIgnCase(String lhs, String rhs) {
        return Util.NormalizeString((String)lhs).compareToIgnoreCase(Util.NormalizeString((String)rhs));
    }

    public static boolean listsEqualUnordered(List<?> lhs, List<?> rhs) {
        int rhsCount;
        if (lhs == rhs) {
            return true;
        }
        int lhsCount = lhs == null ? 0 : lhs.size();
        int n = rhsCount = rhs == null ? 0 : rhs.size();
        if (lhsCount != rhsCount) {
            return false;
        }
        if (lhsCount == 0) {
            return true;
        }
        boolean[] matchedRhsElems = new boolean[rhsCount];
        for (int lhsIdx = 0; lhsIdx < lhsCount; ++lhsIdx) {
            int rhsIdx;
            Object lhsElem = lhs.get(lhsIdx);
            for (rhsIdx = 0; rhsIdx < rhsCount; ++rhsIdx) {
                if (matchedRhsElems[rhsIdx] || !lhsElem.equals(rhs.get(rhsIdx))) continue;
                matchedRhsElems[rhsIdx] = true;
                break;
            }
            if (rhsIdx < rhsCount) continue;
            return false;
        }
        return true;
    }

    public static String LongMaxString(long value) {
        return value == Long.MAX_VALUE ? "" : String.valueOf(value);
    }

    public static String IntMaxString(int value) {
        return value == Integer.MAX_VALUE ? "" : String.valueOf(value);
    }

    public static String DoubleMaxString(double value) {
        return Util.DoubleMaxString((double)value, (String)"");
    }

    public static String DoubleMaxString(double value, String defValue) {
        return value == Double.MAX_VALUE ? defValue : new DecimalFormat("0.########").format(value);
    }

    public static String UnixMillisecondsToString(long milliseconds, String dateFormat) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(milliseconds);
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String UnixSecondsToString(long seconds, String dateFormat) {
        return Util.UnixMillisecondsToString((long)(seconds * 1000L), (String)dateFormat);
    }

    public static List<ContractDetails> lookupContract(ApiController controller, Contract contract) {
        if (controller == null) {
            return new ArrayList<ContractDetails>();
        }
        CompletableFuture future = new CompletableFuture();
        controller.reqContractDetails(contract, (ApiController.IContractDetailsHandler)new /* Unavailable Anonymous Inner Class!! */);
        try {
            return (List)future.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
            return new ArrayList<ContractDetails>();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return new ArrayList<ContractDetails>();
        }
    }

    public static void appendNonEmptyString(StringBuilder sb, String name, String value, String excludeValue) {
        if (!Util.StringIsEmpty((String)value) && !value.equals(excludeValue)) {
            sb.append(" ").append(name).append("=").append(value);
        }
    }

    public static void appendNonEmptyString(StringBuilder sb, String name, String value) {
        if (!Util.StringIsEmpty((String)value)) {
            sb.append(" ").append(name).append("=").append(value);
        }
    }

    public static void appendPositiveIntValue(StringBuilder sb, String name, int value) {
        if (value > 0) {
            Util.appendValidIntValue((StringBuilder)sb, (String)name, (int)value);
        }
    }

    public static void appendValidIntValue(StringBuilder sb, String name, int value) {
        if (value != Integer.MAX_VALUE) {
            sb.append(" ").append(name).append("=").append(Util.IntMaxString((int)value));
        }
    }

    public static void appendPositiveDoubleValue(StringBuilder sb, String name, double value) {
        if (value > 0.0) {
            Util.appendValidDoubleValue((StringBuilder)sb, (String)name, (double)value);
        }
    }

    public static void appendValidDoubleValue(StringBuilder sb, String name, double value) {
        if (value != Double.MAX_VALUE) {
            sb.append(" ").append(name).append("=").append(Util.DoubleMaxString((double)value));
        }
    }

    public static void appendBooleanFlag(StringBuilder sb, String flag, Boolean value) {
        if (value != null && value.booleanValue()) {
            sb.append(" ").append(flag);
        }
    }

    public static void appendBooleanFlag(StringBuilder sb, String flag, int value) {
        if (value > 0) {
            sb.append(" ").append(flag);
        }
    }

    public static void appendValidDoubleValue(StringBuilder sb, String name, String strValue) {
        Double value;
        if (!Util.StringIsEmpty((String)strValue) && (value = Double.valueOf(Double.parseDouble(strValue))) != Double.MAX_VALUE) {
            sb.append(" ").append(name).append("=").append(Formats.fmt((double)value));
        }
    }

    public static void appendValidLongValue(StringBuilder sb, String name, long value) {
        if (value != Long.MAX_VALUE) {
            sb.append(" ").append(name).append("=").append(Util.LongMaxString((long)value));
        }
    }
}

