/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.ContractCondition;
import com.ib.client.ContractLookuper;
import com.ib.client.OrderConditionType;
import com.ib.client.Util;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class PriceCondition
extends ContractCondition {
    public static final OrderConditionType conditionType = OrderConditionType.Price;
    private double m_price;
    private int m_triggerMethod;
    private static String[] mthdNames = new String[]{"default", "double bid/ask", "last", "double last", "bid/ask", "", "", "last of bid/ask", "mid-point"};

    protected PriceCondition() {
    }

    public String toString() {
        return this.toString(null);
    }

    public double price() {
        return this.m_price;
    }

    public void price(double m_price) {
        this.m_price = m_price;
    }

    public String toString(ContractLookuper lookuper) {
        return this.strTriggerMethod() + " " + super.toString(lookuper);
    }

    public int triggerMethod() {
        return this.m_triggerMethod;
    }

    String strTriggerMethod() {
        return mthdNames[this.triggerMethod()];
    }

    public void triggerMethod(int m_triggerMethod) {
        this.m_triggerMethod = m_triggerMethod;
    }

    protected String valueToString() {
        return Util.DoubleMaxString((double)this.m_price);
    }

    protected void valueFromString(String v) {
        this.m_price = Double.parseDouble(v);
    }

    public void readFrom(ObjectInput in) throws IOException {
        super.readFrom(in);
        this.m_triggerMethod = in.readInt();
    }

    public void writeTo(ObjectOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.m_triggerMethod);
    }
}

