/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.ExecutionCondition;
import com.ib.client.MarginCondition;
import com.ib.client.OrderCondition;
import com.ib.client.OrderConditionType;
import com.ib.client.PercentChangeCondition;
import com.ib.client.PriceCondition;
import com.ib.client.TimeCondition;
import com.ib.client.VolumeCondition;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class OrderCondition {
    private OrderConditionType m_type;
    private boolean m_isConjunctionConnection;

    public void readFrom(ObjectInput in) throws IOException {
        this.conjunctionConnection(in.readUTF().compareToIgnoreCase("a") == 0);
    }

    public void writeTo(ObjectOutput out) throws IOException {
        out.writeUTF(this.conjunctionConnection() ? "a" : "o");
    }

    public String toString() {
        return this.conjunctionConnection() ? "<AND>" : "<OR>";
    }

    public boolean conjunctionConnection() {
        return this.m_isConjunctionConnection;
    }

    public void conjunctionConnection(boolean isConjunctionConnection) {
        this.m_isConjunctionConnection = isConjunctionConnection;
    }

    public OrderConditionType type() {
        return this.m_type;
    }

    public static OrderCondition create(OrderConditionType type) {
        ExecutionCondition orderCondition;
        switch (1.$SwitchMap$com$ib$client$OrderConditionType[type.ordinal()]) {
            case 1: {
                orderCondition = new ExecutionCondition();
                break;
            }
            case 2: {
                orderCondition = new MarginCondition();
                break;
            }
            case 3: {
                orderCondition = new PercentChangeCondition();
                break;
            }
            case 4: {
                orderCondition = new PriceCondition();
                break;
            }
            case 5: {
                orderCondition = new TimeCondition();
                break;
            }
            case 6: {
                orderCondition = new VolumeCondition();
                break;
            }
            default: {
                return null;
            }
        }
        orderCondition.m_type = type;
        return orderCondition;
    }
}

