/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.ComboLeg;
import com.ib.client.CommissionReport;
import com.ib.client.Contract;
import com.ib.client.ContractDescription;
import com.ib.client.ContractDetails;
import com.ib.client.Decimal;
import com.ib.client.DeltaNeutralContract;
import com.ib.client.DepthMktDataDescription;
import com.ib.client.EClient;
import com.ib.client.Execution;
import com.ib.client.FamilyCode;
import com.ib.client.HistogramEntry;
import com.ib.client.HistoricalSession;
import com.ib.client.MarketDataType;
import com.ib.client.NewsProvider;
import com.ib.client.Order;
import com.ib.client.OrderComboLeg;
import com.ib.client.OrderCondition;
import com.ib.client.OrderState;
import com.ib.client.PriceIncrement;
import com.ib.client.SoftDollarTier;
import com.ib.client.TagValue;
import com.ib.client.TickAttrib;
import com.ib.client.TickAttribBidAsk;
import com.ib.client.TickAttribLast;
import com.ib.client.TickType;
import com.ib.client.Util;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * Exception performing whole class analysis ignored.
 */
public class EWrapperMsgGenerator {
    public static final String SCANNER_PARAMETERS = "SCANNER PARAMETERS:";
    public static final String FINANCIAL_ADVISOR = "FA:";

    public static String tickPrice(int tickerId, int field, double price, TickAttrib attribs) {
        return "id=" + tickerId + "  " + TickType.getField((int)field) + "=" + Util.DoubleMaxString((double)price) + " " + (attribs.canAutoExecute() ? " canAutoExecute" : " noAutoExecute") + " pastLimit = " + attribs.pastLimit() + (String)(field == TickType.BID.index() || field == TickType.ASK.index() ? " preOpen = " + attribs.preOpen() : "");
    }

    public static String tickSize(int tickerId, int field, Decimal size) {
        return "id=" + tickerId + "  " + TickType.getField((int)field) + "=" + String.valueOf(size);
    }

    public static String tickOptionComputation(int tickerId, int field, int tickAttrib, double impliedVol, double delta, double optPrice, double pvDividend, double gamma, double vega, double theta, double undPrice) {
        return "id=" + tickerId + "  " + TickType.getField((int)field) + ": tickAttrib = " + Util.IntMaxString((int)tickAttrib) + " impliedVol = " + Util.DoubleMaxString((double)impliedVol, (String)"N/A") + " delta = " + Util.DoubleMaxString((double)delta, (String)"N/A") + " gamma = " + Util.DoubleMaxString((double)gamma, (String)"N/A") + " vega = " + Util.DoubleMaxString((double)vega, (String)"N/A") + " theta = " + Util.DoubleMaxString((double)theta, (String)"N/A") + " optPrice = " + Util.DoubleMaxString((double)optPrice, (String)"N/A") + " pvDividend = " + Util.DoubleMaxString((double)pvDividend, (String)"N/A") + " undPrice = " + Util.DoubleMaxString((double)undPrice, (String)"N/A");
    }

    public static String tickGeneric(int tickerId, int tickType, double value) {
        return "id=" + tickerId + "  " + TickType.getField((int)tickType) + "=" + Util.DoubleMaxString((double)value);
    }

    public static String tickString(int tickerId, int tickType, String value) {
        return "id=" + tickerId + "  " + TickType.getField((int)tickType) + "=" + value;
    }

    public static String tickEFP(int tickerId, int tickType, double basisPoints, String formattedBasisPoints, double impliedFuture, int holdDays, String futureLastTradeDate, double dividendImpact, double dividendsToLastTradeDate) {
        return "id=" + tickerId + "  " + TickType.getField((int)tickType) + ": basisPoints = " + Util.DoubleMaxString((double)basisPoints) + "/" + formattedBasisPoints + " impliedFuture = " + Util.DoubleMaxString((double)impliedFuture) + " holdDays = " + Util.IntMaxString((int)holdDays) + " futureLastTradeDate = " + futureLastTradeDate + " dividendImpact = " + Util.DoubleMaxString((double)dividendImpact) + " dividends to expiry = " + Util.DoubleMaxString((double)dividendsToLastTradeDate);
    }

    public static String orderStatus(int orderId, String status, Decimal filled, Decimal remaining, double avgFillPrice, int permId, int parentId, double lastFillPrice, int clientId, String whyHeld, double mktCapPrice) {
        return "order status: orderId=" + orderId + " clientId=" + Util.IntMaxString((int)clientId) + " permId=" + Util.IntMaxString((int)permId) + " status=" + status + " filled=" + String.valueOf(filled) + " remaining=" + String.valueOf(remaining) + " avgFillPrice=" + Util.DoubleMaxString((double)avgFillPrice) + " lastFillPrice=" + Util.DoubleMaxString((double)lastFillPrice) + " parent Id=" + Util.IntMaxString((int)parentId) + " whyHeld=" + whyHeld + " mktCapPrice=" + Util.DoubleMaxString((double)mktCapPrice);
    }

    public static String openOrder(int orderId, Contract contract, Order order, OrderState orderState) {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("open order:");
        EWrapperMsgGenerator.appendOrderFields((StringBuilder)sb, (int)orderId, (Contract)contract, (Order)order, (OrderState)orderState, (boolean)true);
        return sb.toString();
    }

    public static String openOrderEnd() {
        return " =============== end ===============";
    }

    public static String updateAccountValue(String key, String value, String currency, String accountName) {
        return "updateAccountValue: " + key + " " + value + " " + currency + " " + accountName;
    }

    public static String updatePortfolio(Contract contract, Decimal position, double marketPrice, double marketValue, double averageCost, double unrealizedPNL, double realizedPNL, String accountName) {
        return "updatePortfolio: " + EWrapperMsgGenerator.contractMsg((Contract)contract) + String.valueOf(position) + " " + Util.DoubleMaxString((double)marketPrice) + " " + Util.DoubleMaxString((double)marketValue) + " " + Util.DoubleMaxString((double)averageCost) + " " + Util.DoubleMaxString((double)unrealizedPNL) + " " + Util.DoubleMaxString((double)realizedPNL) + " " + accountName;
    }

    public static String updateAccountTime(String timeStamp) {
        return "updateAccountTime: " + timeStamp;
    }

    public static String accountDownloadEnd(String accountName) {
        return "accountDownloadEnd: " + accountName;
    }

    public static String nextValidId(int orderId) {
        return "Next Valid Order ID: " + orderId;
    }

    public static String contractDetails(int reqId, ContractDetails contractDetails) {
        Contract contract = contractDetails.contract();
        return "reqId = " + reqId + " ===================================\n ---- Contract Details begin ----\n" + EWrapperMsgGenerator.contractMsg((Contract)contract) + EWrapperMsgGenerator.contractDetailsMsg((ContractDetails)contractDetails) + " ---- Contract Details End ----\n";
    }

    private static String contractDetailsMsg(ContractDetails contractDetails) {
        return "marketName = " + contractDetails.marketName() + "\nminTick = " + Util.DoubleMaxString((double)contractDetails.minTick()) + "\nprice magnifier = " + Util.IntMaxString((int)contractDetails.priceMagnifier()) + "\norderTypes = " + contractDetails.orderTypes() + "\nvalidExchanges = " + contractDetails.validExchanges() + "\nunderConId = " + Util.IntMaxString((int)contractDetails.underConid()) + "\nlongName = " + contractDetails.longName() + "\ncontractMonth = " + contractDetails.contractMonth() + "\nindustry = " + contractDetails.industry() + "\ncategory = " + contractDetails.category() + "\nsubcategory = " + contractDetails.subcategory() + "\ntimeZoneId = " + contractDetails.timeZoneId() + "\ntradingHours = " + contractDetails.tradingHours() + "\nliquidHours = " + contractDetails.liquidHours() + "\nevRule = " + contractDetails.evRule() + "\nevMultiplier = " + Util.DoubleMaxString((double)contractDetails.evMultiplier()) + "\naggGroup = " + Util.IntMaxString((int)contractDetails.aggGroup()) + "\nunderSymbol = " + contractDetails.underSymbol() + "\nunderSecType = " + contractDetails.underSecType() + "\nmarketRuleIds = " + contractDetails.marketRuleIds() + "\nrealExpirationDate = " + contractDetails.realExpirationDate() + "\nlastTradeTime = " + contractDetails.lastTradeTime() + "\nstockType = " + contractDetails.stockType() + "\nminSize = " + String.valueOf(contractDetails.minSize()) + "\nsizeIncrement = " + String.valueOf(contractDetails.sizeIncrement()) + "\nsuggestedSizeIncrement = " + String.valueOf(contractDetails.suggestedSizeIncrement()) + "\n" + EWrapperMsgGenerator.contractDetailsSecIdList((ContractDetails)contractDetails);
    }

    private static String contractMsg(Contract contract) {
        return "conid = " + contract.conid() + "\nsymbol = " + contract.symbol() + "\nsecType = " + contract.getSecType() + "\nlastTradeDate = " + contract.lastTradeDateOrContractMonth() + "\nstrike = " + Util.DoubleMaxString((double)contract.strike()) + "\nright = " + contract.getRight() + "\nmultiplier = " + contract.multiplier() + "\nexchange = " + contract.exchange() + "\nprimaryExch = " + contract.primaryExch() + "\ncurrency = " + contract.currency() + "\nlocalSymbol = " + contract.localSymbol() + "\ntradingClass = " + contract.tradingClass() + "\n";
    }

    public static String bondContractDetails(int reqId, ContractDetails contractDetails) {
        Contract contract = contractDetails.contract();
        return "reqId = " + reqId + " ===================================\n ---- Bond Contract Details begin ----\nsymbol = " + contract.symbol() + "\nsecType = " + contract.getSecType() + "\ncusip = " + contractDetails.cusip() + "\ncoupon = " + Util.DoubleMaxString((double)contractDetails.coupon()) + "\nmaturity = " + contractDetails.maturity() + "\nissueDate = " + contractDetails.issueDate() + "\nratings = " + contractDetails.ratings() + "\nbondType = " + contractDetails.bondType() + "\ncouponType = " + contractDetails.couponType() + "\nconvertible = " + contractDetails.convertible() + "\ncallable = " + contractDetails.callable() + "\nputable = " + contractDetails.putable() + "\ndescAppend = " + contractDetails.descAppend() + "\nexchange = " + contract.exchange() + "\ncurrency = " + contract.currency() + "\nmarketName = " + contractDetails.marketName() + "\ntradingClass = " + contract.tradingClass() + "\nconid = " + contract.conid() + "\nminTick = " + Util.DoubleMaxString((double)contractDetails.minTick()) + "\norderTypes = " + contractDetails.orderTypes() + "\nvalidExchanges = " + contractDetails.validExchanges() + "\nnextOptionDate = " + contractDetails.nextOptionDate() + "\nnextOptionType = " + contractDetails.nextOptionType() + "\nnextOptionPartial = " + contractDetails.nextOptionPartial() + "\nnotes = " + contractDetails.notes() + "\nlongName = " + contractDetails.longName() + "\nevRule = " + contractDetails.evRule() + "\nevMultiplier = " + Util.DoubleMaxString((double)contractDetails.evMultiplier()) + "\naggGroup = " + Util.IntMaxString((int)contractDetails.aggGroup()) + "\nmarketRuleIds = " + contractDetails.marketRuleIds() + "\ntimeZoneId = " + contractDetails.timeZoneId() + "\nlastTradeTime = " + contractDetails.lastTradeTime() + "\nminSize = " + String.valueOf(contractDetails.minSize()) + "\nsizeIncrement = " + String.valueOf(contractDetails.sizeIncrement()) + "\nsuggestedSizeIncrement = " + String.valueOf(contractDetails.suggestedSizeIncrement()) + "\n" + EWrapperMsgGenerator.contractDetailsSecIdList((ContractDetails)contractDetails) + " ---- Bond Contract Details End ----\n";
    }

    private static String contractDetailsSecIdList(ContractDetails contractDetails) {
        StringBuilder sb = new StringBuilder(32);
        sb.append("secIdList={");
        if (contractDetails.secIdList() != null) {
            for (TagValue param : contractDetails.secIdList()) {
                sb.append(param.m_tag).append("=").append(param.m_value).append(',');
            }
            if (!contractDetails.secIdList().isEmpty()) {
                sb.setLength(sb.length() - 1);
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    public static String contractDetailsEnd(int reqId) {
        return "reqId = " + reqId + " =============== end ===============";
    }

    public static String execDetails(int reqId, Contract contract, Execution execution) {
        return " ---- Execution Details begin ----\nreqId = " + reqId + "\norderId = " + execution.orderId() + "\nclientId = " + Util.IntMaxString((int)execution.clientId()) + "\n" + EWrapperMsgGenerator.contractMsg((Contract)contract) + "execId = " + execution.execId() + "\ntime = " + execution.time() + "\nacctNumber = " + execution.acctNumber() + "\nexecutionExchange = " + execution.exchange() + "\nside = " + execution.side() + "\nshares = " + String.valueOf(execution.shares()) + "\nprice = " + Util.DoubleMaxString((double)execution.price()) + "\npermId = " + Util.IntMaxString((int)execution.permId()) + "\nliquidation = " + Util.IntMaxString((int)execution.liquidation()) + "\ncumQty = " + String.valueOf(execution.cumQty()) + "\navgPrice = " + Util.DoubleMaxString((double)execution.avgPrice()) + "\norderRef = " + execution.orderRef() + "\nevRule = " + execution.evRule() + "\nevMultiplier = " + Util.DoubleMaxString((double)execution.evMultiplier()) + "\nmodelCode = " + execution.modelCode() + "\nlastLiquidity = " + String.valueOf(execution.lastLiquidity()) + "\n ---- Execution Details end ----\n";
    }

    public static String execDetailsEnd(int reqId) {
        return "reqId = " + reqId + " =============== end ===============";
    }

    public static String updateMktDepth(int tickerId, int position, int operation, int side, double price, Decimal size) {
        return "updateMktDepth: " + tickerId + " " + position + " " + operation + " " + side + " " + Util.DoubleMaxString((double)price) + " " + String.valueOf(size);
    }

    public static String updateMktDepthL2(int tickerId, int position, String marketMaker, int operation, int side, double price, Decimal size, boolean isSmartDepth) {
        return "updateMktDepth: " + tickerId + " " + position + " " + marketMaker + " " + operation + " " + side + " " + Util.DoubleMaxString((double)price) + " " + String.valueOf(size) + " " + isSmartDepth;
    }

    public static String updateNewsBulletin(int msgId, int msgType, String message, String origExchange) {
        return "MsgId=" + msgId + " :: MsgType=" + Util.IntMaxString((int)msgType) + " :: Origin=" + origExchange + " :: Message=" + message;
    }

    public static String managedAccounts(String accountsList) {
        return "Connected : The list of managed accounts are : [" + accountsList + "]";
    }

    public static String receiveFA(int faDataType, String xml) {
        return "FA: " + EClient.faMsgTypeName((int)faDataType) + " " + xml;
    }

    public static String historicalData(int reqId, String date, double open, double high, double low, double close, Decimal volume, int count, Decimal WAP) {
        return "id=" + reqId + " date = " + date + " open=" + Util.DoubleMaxString((double)open) + " high=" + Util.DoubleMaxString((double)high) + " low=" + Util.DoubleMaxString((double)low) + " close=" + Util.DoubleMaxString((double)close) + " volume=" + String.valueOf(volume) + " count=" + Util.IntMaxString((int)count) + " WAP=" + String.valueOf(WAP);
    }

    public static String historicalDataEnd(int reqId, String startDate, String endDate) {
        return "id=" + reqId + " start date = " + startDate + " end date=" + endDate;
    }

    public static String realtimeBar(int reqId, long time, double open, double high, double low, double close, Decimal volume, Decimal wap, int count) {
        return "id=" + reqId + " time = " + Util.LongMaxString((long)time) + " open=" + Util.DoubleMaxString((double)open) + " high=" + Util.DoubleMaxString((double)high) + " low=" + Util.DoubleMaxString((double)low) + " close=" + Util.DoubleMaxString((double)close) + " volume=" + String.valueOf(volume) + " count=" + Util.IntMaxString((int)count) + " WAP=" + String.valueOf(wap);
    }

    public static String scannerParameters(String xml) {
        return "SCANNER PARAMETERS:\n" + xml;
    }

    public static String scannerData(int reqId, int rank, ContractDetails contractDetails, String distance, String benchmark, String projection, String legsStr) {
        Contract contract = contractDetails.contract();
        return "id = " + reqId + " rank=" + Util.IntMaxString((int)rank) + " symbol=" + contract.symbol() + " secType=" + contract.getSecType() + " lastTradeDate=" + contract.lastTradeDateOrContractMonth() + " strike=" + Util.DoubleMaxString((double)contract.strike()) + " right=" + contract.getRight() + " exchange=" + contract.exchange() + " currency=" + contract.currency() + " localSymbol=" + contract.localSymbol() + " marketName=" + contractDetails.marketName() + " tradingClass=" + contract.tradingClass() + " distance=" + distance + " benchmark=" + benchmark + " projection=" + projection + " legsStr=" + legsStr;
    }

    public static String scannerDataEnd(int reqId) {
        return "id = " + reqId + " =============== end ===============";
    }

    public static String currentTime(long time) {
        return "current time = " + time + " (" + DateFormat.getDateTimeInstance().format(new Date(time * 1000L)) + ")";
    }

    public static String fundamentalData(int reqId, String data) {
        return "id  = " + reqId + " len = " + data.length() + "\n" + data;
    }

    public static String deltaNeutralValidation(int reqId, DeltaNeutralContract deltaNeutralContract) {
        return "id = " + reqId + " deltaNeutralContract.conId =" + deltaNeutralContract.conid() + " deltaNeutralContract.delta =" + Util.DoubleMaxString((double)deltaNeutralContract.delta()) + " deltaNeutralContract.price =" + Util.DoubleMaxString((double)deltaNeutralContract.price());
    }

    public static String tickSnapshotEnd(int tickerId) {
        return "id=" + tickerId + " =============== end ===============";
    }

    public static String marketDataType(int reqId, int marketDataType) {
        return "id=" + reqId + " marketDataType = " + MarketDataType.getField((int)marketDataType);
    }

    public static String commissionReport(CommissionReport commissionReport) {
        return "commission report: execId=" + commissionReport.execId() + " commission=" + Util.DoubleMaxString((double)commissionReport.commission()) + " currency=" + commissionReport.currency() + " realizedPNL=" + Util.DoubleMaxString((double)commissionReport.realizedPNL()) + " yield=" + Util.DoubleMaxString((double)commissionReport.yield()) + " yieldRedemptionDate=" + Util.IntMaxString((int)commissionReport.yieldRedemptionDate());
    }

    public static String position(String account, Contract contract, Decimal pos, double avgCost) {
        return " ---- Position begin ----\naccount = " + account + "\n" + EWrapperMsgGenerator.contractMsg((Contract)contract) + "position = " + String.valueOf(pos) + "\navgCost = " + Util.DoubleMaxString((double)avgCost) + "\n ---- Position end ----\n";
    }

    public static String positionEnd() {
        return " =============== end ===============";
    }

    public static String accountSummary(int reqId, String account, String tag, String value, String currency) {
        return " ---- Account Summary begin ----\nreqId = " + reqId + "\naccount = " + account + "\ntag = " + tag + "\nvalue = " + value + "\ncurrency = " + currency + "\n ---- Account Summary end ----\n";
    }

    public static String accountSummaryEnd(int reqId) {
        return "id=" + reqId + " =============== end ===============";
    }

    public static String positionMulti(int reqId, String account, String modelCode, Contract contract, Decimal pos, double avgCost) {
        return " ---- Position begin ----\nid = " + reqId + "\naccount = " + account + "\nmodelCode = " + modelCode + "\n" + EWrapperMsgGenerator.contractMsg((Contract)contract) + "position = " + String.valueOf(pos) + "\navgCost = " + Util.DoubleMaxString((double)avgCost) + "\n ---- Position end ----\n";
    }

    public static String positionMultiEnd(int reqId) {
        return "id = " + reqId + " =============== end ===============";
    }

    public static String accountUpdateMulti(int reqId, String account, String modelCode, String key, String value, String currency) {
        return " id = " + reqId + " account = " + account + " modelCode = " + modelCode + " key = " + key + " value = " + value + " currency = " + currency;
    }

    public static String accountUpdateMultiEnd(int reqId) {
        return "id = " + reqId + " =============== end ===============";
    }

    public static String securityDefinitionOptionalParameter(int reqId, String exchange, int underlyingConId, String tradingClass, String multiplier, Set<String> expirations, Set<Double> strikes) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(" id = ").append(reqId).append(" exchange = ").append(exchange).append(" underlyingConId = ").append(underlyingConId).append(" tradingClass = ").append(tradingClass).append(" multiplier = ").append(multiplier).append(" expirations: ");
        for (String expiration : expirations) {
            sb.append(expiration).append(", ");
        }
        sb.append(" strikes: ");
        for (Double strike : strikes) {
            sb.append(Util.DoubleMaxString((double)strike)).append(", ");
        }
        return sb.toString();
    }

    public static String securityDefinitionOptionalParameterEnd(int reqId) {
        return "id = " + reqId + " =============== end ===============";
    }

    public static String softDollarTiers(int reqId, SoftDollarTier[] tiers) {
        StringBuilder sb = new StringBuilder();
        sb.append("==== Soft Dollar Tiers Begin (total=").append(tiers.length).append(") reqId: ").append(reqId).append(" ====\n");
        for (int i = 0; i < tiers.length; ++i) {
            sb.append("Soft Dollar Tier [").append(i).append("] - name: ").append(tiers[i].name()).append(", value: ").append(tiers[i].value()).append("\n");
        }
        sb.append("==== Soft Dollar Tiers End (total=").append(tiers.length).append(") ====\n");
        return sb.toString();
    }

    public static String familyCodes(FamilyCode[] familyCodes) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("==== Family Codes Begin (total=").append(familyCodes.length).append(") ====\n");
        for (int i = 0; i < familyCodes.length; ++i) {
            sb.append("Family Code [").append(i).append("] - accountID: ").append(familyCodes[i].accountID()).append(", familyCode: ").append(familyCodes[i].familyCodeStr()).append("\n");
        }
        sb.append("==== Family Codes End (total=").append(familyCodes.length).append(") ====\n");
        return sb.toString();
    }

    public static String symbolSamples(int reqId, ContractDescription[] contractDescriptions) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("==== Symbol Samples Begin (total=").append(contractDescriptions.length).append(") reqId: ").append(reqId).append(" ====\n");
        for (int i = 0; i < contractDescriptions.length; ++i) {
            sb.append("---- Contract Description Begin (").append(i).append(") ----\n");
            sb.append("conId: ").append(contractDescriptions[i].contract().conid()).append("\n");
            sb.append("symbol: ").append(contractDescriptions[i].contract().symbol()).append("\n");
            sb.append("secType: ").append(contractDescriptions[i].contract().secType()).append("\n");
            sb.append("primaryExch: ").append(contractDescriptions[i].contract().primaryExch()).append("\n");
            sb.append("currency: ").append(contractDescriptions[i].contract().currency()).append("\n");
            sb.append("derivativeSecTypes (total=").append(contractDescriptions[i].derivativeSecTypes().length).append("): ");
            for (int j = 0; j < contractDescriptions[i].derivativeSecTypes().length; ++j) {
                sb.append(contractDescriptions[i].derivativeSecTypes()[j]).append(' ');
            }
            sb.append("\n");
            sb.append("description: ").append(Util.NormalizeString((String)contractDescriptions[i].contract().description())).append("\n");
            sb.append("issuerId: ").append(Util.NormalizeString((String)contractDescriptions[i].contract().issuerId())).append("\n");
            sb.append("---- Contract Description End (").append(i).append(") ----\n");
        }
        sb.append("==== Symbol Samples End (total=").append(contractDescriptions.length).append(") reqId: ").append(reqId).append(" ====\n");
        return sb.toString();
    }

    public static String mktDepthExchanges(DepthMktDataDescription[] depthMktDataDescriptions) {
        StringBuilder sb = new StringBuilder();
        sb.append("==== Market Depth Exchanges Begin (total=").append(depthMktDataDescriptions.length).append(") ====\n");
        for (int i = 0; i < depthMktDataDescriptions.length; ++i) {
            sb.append("Depth Market Data Description [").append(i).append("] - exchange: ").append(depthMktDataDescriptions[i].exchange()).append(", secType: ").append(depthMktDataDescriptions[i].secType()).append(", listingExch: ").append(depthMktDataDescriptions[i].listingExch()).append(", serviceDataType: ").append(depthMktDataDescriptions[i].serviceDataType()).append(", aggGroup: ").append(Util.IntMaxString((int)depthMktDataDescriptions[i].aggGroup())).append("\n");
        }
        sb.append("==== Market Depth Exchanges End (total=").append(depthMktDataDescriptions.length).append(") ====\n");
        return sb.toString();
    }

    public static String tickNews(int tickerId, long timeStamp, String providerCode, String articleId, String headline, String extraData) {
        return "TickNews. tickerId: " + tickerId + ", timeStamp: " + Util.UnixMillisecondsToString((long)timeStamp, (String)"yyyyMMdd-HH:mm:ss") + ", providerCode: " + providerCode + ", articleId: " + articleId + ", headline: " + headline + ", extraData: " + extraData;
    }

    public static String newsProviders(NewsProvider[] newsProviders) {
        StringBuilder sb = new StringBuilder();
        sb.append("==== News Providers Begin (total=").append(newsProviders.length).append(") ====\n");
        for (int i = 0; i < newsProviders.length; ++i) {
            sb.append("News Provider [").append(i).append("] - providerCode: ").append(newsProviders[i].providerCode()).append(", providerName: ").append(newsProviders[i].providerName()).append("\n");
        }
        sb.append("==== News Providers End (total=").append(newsProviders.length).append(") ====\n");
        return sb.toString();
    }

    public static String error(Exception ex) {
        return "Error - " + String.valueOf(ex);
    }

    public static String error(String str) {
        return str;
    }

    public static String error(int id, int errorCode, String errorMsg, String advancedOrderRejectJson) {
        String ret = id + " | " + errorCode + " | " + errorMsg;
        if (advancedOrderRejectJson != null) {
            ret = ret + " | " + advancedOrderRejectJson;
        }
        return ret;
    }

    public static String connectionClosed() {
        return "Connection Closed";
    }

    public static String softDollarTiers(SoftDollarTier[] tiers) {
        StringBuilder sb = new StringBuilder();
        sb.append("==== Soft Dollar Tiers Begin (total=").append(tiers.length).append(") ====\n");
        for (SoftDollarTier tier : tiers) {
            sb.append(tier).append("\n");
        }
        sb.append("==== Soft Dollar Tiers End (total=").append(tiers.length).append(") ====\n");
        return sb.toString();
    }

    public static String tickReqParams(int tickerId, double minTick, String bboExchange, int snapshotPermissions) {
        return "id=" + tickerId + " minTick = " + Util.DoubleMaxString((double)minTick) + " bboExchange = " + bboExchange + " snapshotPermissions = " + Util.IntMaxString((int)snapshotPermissions);
    }

    public static String smartComponents(int reqId, Map<Integer, Map.Entry<String, Character>> theMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("==== Smart Components Begin (total=").append(theMap.entrySet().size()).append(") reqId = ").append(reqId).append("====\n");
        for (Map.Entry<Integer, Map.Entry<String, Character>> item : theMap.entrySet()) {
            sb.append("bit number: ").append(item.getKey()).append(", exchange: ").append(item.getValue().getKey()).append(", exchange letter: ").append(item.getValue().getValue()).append("\n");
        }
        sb.append("==== Smart Components End (total=").append(theMap.entrySet().size()).append(") reqId = ").append(reqId).append("====\n");
        return sb.toString();
    }

    public static String newsArticle(int requestId, int articleType, String articleText) {
        StringBuilder sb = new StringBuilder();
        sb.append("==== News Article Begin requestId: ").append(requestId).append(" ====\n");
        if (articleType == 0) {
            sb.append("---- Article type is text or html ----\n");
            sb.append(articleText).append("\n");
        } else if (articleType == 1) {
            sb.append("---- Article type is binary/pdf ----\n");
            sb.append("Binary/pdf article text cannot be displayed\n");
        }
        sb.append("==== News Article End requestId: ").append(requestId).append(" ====\n");
        return sb.toString();
    }

    public static String historicalNews(int requestId, String time, String providerCode, String articleId, String headline) {
        return "Historical News. RequestId: " + requestId + ", time: " + time + ", providerCode: " + providerCode + ", articleId: " + articleId + ", headline: " + headline;
    }

    public static String historicalNewsEnd(int requestId, boolean hasMore) {
        return "Historical News End. RequestId: " + requestId + ", hasMore: " + hasMore;
    }

    public static String headTimestamp(int reqId, String headTimestamp) {
        return "Head timestamp. Req Id: " + reqId + ", headTimestamp: " + headTimestamp;
    }

    public static String histogramData(int reqId, List<HistogramEntry> items) {
        StringBuilder sb = new StringBuilder();
        sb.append("Histogram data. Req Id: ").append(reqId).append(", Data (").append(items.size()).append("):\n");
        items.forEach(i -> sb.append("\tPrice: ").append(Util.DoubleMaxString((double)i.price())).append(", Size: ").append(i.size()).append("\n"));
        return sb.toString();
    }

    public static String rerouteMktDataReq(int reqId, int conId, String exchange) {
        return "Re-route market data request. Req Id: " + reqId + ", Con Id: " + conId + ", Exchange: " + exchange;
    }

    public static String rerouteMktDepthReq(int reqId, int conId, String exchange) {
        return "Re-route market depth request. Req Id: " + reqId + ", Con Id: " + conId + ", Exchange: " + exchange;
    }

    public static String marketRule(int marketRuleId, PriceIncrement[] priceIncrements) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("==== Market Rule Begin (marketRuleId=").append(marketRuleId).append(") ====\n");
        for (PriceIncrement priceIncrement : priceIncrements) {
            sb.append("Low Edge: ").append(Util.DoubleMaxString((double)priceIncrement.lowEdge()));
            sb.append(", Increment: ").append(Util.DoubleMaxString((double)priceIncrement.increment()));
            sb.append("\n");
        }
        sb.append("==== Market Rule End (marketRuleId=").append(marketRuleId).append(") ====\n");
        return sb.toString();
    }

    public static String pnl(int reqId, double dailyPnL, double unrealizedPnL, double realizedPnL) {
        return "Daily PnL. Req Id: " + reqId + ", daily PnL: " + Util.DoubleMaxString((double)dailyPnL) + ", unrealizedPnL: " + Util.DoubleMaxString((double)unrealizedPnL) + ", realizedPnL: " + Util.DoubleMaxString((double)realizedPnL);
    }

    public static String pnlSingle(int reqId, Decimal pos, double dailyPnL, double unrealizedPnL, double realizedPnL, double value) {
        return "Daily PnL Single. Req Id: " + reqId + ", pos: " + String.valueOf(pos) + ", daily PnL: " + Util.DoubleMaxString((double)dailyPnL) + ", unrealizedPnL: " + Util.DoubleMaxString((double)unrealizedPnL) + ", realizedPnL: " + Util.DoubleMaxString((double)realizedPnL) + ", value: " + Util.DoubleMaxString((double)value);
    }

    public static String historicalTick(int reqId, long time, double price, Decimal size) {
        return "Historical Tick. Req Id: " + reqId + ", time: " + Util.UnixSecondsToString((long)time, (String)"yyyyMMdd-HH:mm:ss") + ", price: " + Util.DoubleMaxString((double)price) + ", size: " + String.valueOf(size);
    }

    public static String historicalTickBidAsk(int reqId, long time, TickAttribBidAsk tickAttribBidAsk, double priceBid, double priceAsk, Decimal sizeBid, Decimal sizeAsk) {
        return "Historical Tick Bid/Ask. Req Id: " + reqId + ", time: " + Util.UnixSecondsToString((long)time, (String)"yyyyMMdd-HH:mm:ss") + ", bid price: " + Util.DoubleMaxString((double)priceBid) + ", ask price: " + Util.DoubleMaxString((double)priceAsk) + ", bid size: " + String.valueOf(sizeBid) + ", ask size: " + String.valueOf(sizeAsk) + ", tick attribs: " + (tickAttribBidAsk.bidPastLow() ? "bidPastLow " : "") + (tickAttribBidAsk.askPastHigh() ? "askPastHigh " : "");
    }

    public static String historicalTickLast(int reqId, long time, TickAttribLast tickAttribLast, double price, Decimal size, String exchange, String specialConditions) {
        return "Historical Tick Last. Req Id: " + reqId + ", time: " + Util.UnixSecondsToString((long)time, (String)"yyyyMMdd-HH:mm:ss") + ", price: " + Util.DoubleMaxString((double)price) + ", size: " + String.valueOf(size) + ", exchange: " + exchange + ", special conditions:" + specialConditions + ", tick attribs: " + (tickAttribLast.pastLimit() ? "pastLimit " : "") + (tickAttribLast.unreported() ? "unreported " : "");
    }

    public static String tickByTickAllLast(int reqId, int tickType, long time, double price, Decimal size, TickAttribLast tickAttribLast, String exchange, String specialConditions) {
        return (tickType == 1 ? "Last." : "AllLast.") + " Req Id: " + reqId + " Time: " + Util.UnixSecondsToString((long)time, (String)"yyyyMMdd-HH:mm:ss") + " Price: " + Util.DoubleMaxString((double)price) + " Size: " + String.valueOf(size) + " Exch: " + exchange + " Spec Cond: " + specialConditions + " Tick Attibs: " + (tickAttribLast.pastLimit() ? "pastLimit " : "") + (tickType == 1 ? "" : (tickAttribLast.unreported() ? "unreported " : ""));
    }

    public static String tickByTickBidAsk(int reqId, long time, double bidPrice, double askPrice, Decimal bidSize, Decimal askSize, TickAttribBidAsk tickAttribBidAsk) {
        return "BidAsk. Req Id: " + reqId + " Time: " + Util.UnixSecondsToString((long)time, (String)"yyyyMMdd-HH:mm:ss") + " BidPrice: " + Util.DoubleMaxString((double)bidPrice) + " AskPrice: " + Util.DoubleMaxString((double)askPrice) + " BidSize: " + String.valueOf(bidSize) + " AskSize: " + String.valueOf(askSize) + " Tick Attibs: " + (tickAttribBidAsk.bidPastLow() ? "bidPastLow " : "") + (tickAttribBidAsk.askPastHigh() ? "askPastHigh " : "");
    }

    public static String tickByTickMidPoint(int reqId, long time, double midPoint) {
        return "MidPoint. Req Id: " + reqId + " Time: " + Util.UnixSecondsToString((long)time, (String)"yyyyMMdd-HH:mm:ss") + " MidPoint: " + Util.DoubleMaxString((double)midPoint);
    }

    public static String orderBound(long orderId, int apiClientId, int apiOrderId) {
        return "order bound: apiOrderId=" + Util.IntMaxString((int)apiOrderId) + " apiClientId=" + Util.IntMaxString((int)apiClientId) + " permId=" + Util.LongMaxString((long)orderId);
    }

    public static String completedOrder(Contract contract, Order order, OrderState orderState) {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("completed order:");
        EWrapperMsgGenerator.appendOrderFields((StringBuilder)sb, (int)Integer.MAX_VALUE, (Contract)contract, (Order)order, (OrderState)orderState, (boolean)false);
        return sb.toString();
    }

    public static String completedOrdersEnd() {
        return "=============== end ===============";
    }

    public static String replaceFAEnd(int reqId, String text) {
        return "id = " + reqId + " ===== " + text + " =====";
    }

    public static String wshMetaData(int reqId, String dataJson) {
        return "wshMetaData. id = " + reqId + " dataJson= " + dataJson;
    }

    public static String wshEventData(int reqId, String dataJson) {
        return "wshEventData. id = " + reqId + " dataJson= " + dataJson;
    }

    public static String historicalSchedule(int reqId, String startDateTime, String endDateTime, String timeZone, List<HistoricalSession> sessions) {
        StringBuilder sb = new StringBuilder();
        sb.append("==== Historical Schedule Begin (ReqId=").append(reqId).append(") ====\n");
        sb.append("Start: ").append(startDateTime);
        sb.append(" End: ").append(endDateTime);
        sb.append(" Time Zone: ").append(timeZone);
        sb.append("\n");
        for (HistoricalSession session : sessions) {
            sb.append("Session: ");
            sb.append("Start: ").append(session.startDateTime());
            sb.append(" End: ").append(session.endDateTime());
            sb.append(" Ref Date: ").append(session.refDate());
            sb.append("\n");
        }
        sb.append("==== Historical Schedule End (ReqId=").append(reqId).append(") ====\n");
        return sb.toString();
    }

    public static String userInfo(int reqId, String whiteBrandingId) {
        return "UserInfo. Req Id: " + reqId + " White Branding Id: " + whiteBrandingId;
    }

    private static void appendOrderFields(StringBuilder sb, int orderId, Contract contract, Order order, OrderState orderState, boolean isOpenOrder) {
        Util.appendValidIntValue((StringBuilder)sb, (String)"orderId", (int)orderId);
        Util.appendNonEmptyString((StringBuilder)sb, (String)"action", (String)order.getAction());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"quantity", (String)order.totalQuantity().toString());
        Util.appendPositiveDoubleValue((StringBuilder)sb, (String)"cashQty", (double)order.cashQty());
        Util.appendPositiveIntValue((StringBuilder)sb, (String)"conid", (int)contract.conid());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"symbol", (String)contract.symbol());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"secType", (String)contract.getSecType());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"lastTradeDate", (String)contract.lastTradeDateOrContractMonth());
        Util.appendPositiveDoubleValue((StringBuilder)sb, (String)"strike", (double)contract.strike());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"right", (String)contract.getRight(), (String)"?");
        Util.appendNonEmptyString((StringBuilder)sb, (String)"multiplier", (String)contract.multiplier());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"exchange", (String)contract.exchange());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"primaryExch", (String)contract.primaryExch());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"currency", (String)contract.currency());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"localSymbol", (String)contract.localSymbol());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"tradingClass", (String)contract.tradingClass());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"type", (String)order.getOrderType());
        Util.appendValidDoubleValue((StringBuilder)sb, (String)"lmtPrice", (double)order.lmtPrice());
        Util.appendValidDoubleValue((StringBuilder)sb, (String)"auxPrice", (double)order.auxPrice());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"TIF", (String)order.getTif());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"openClose", (String)order.openClose());
        Util.appendValidIntValue((StringBuilder)sb, (String)"origin", (int)order.origin());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"orderRef", (String)order.orderRef());
        Util.appendValidIntValue((StringBuilder)sb, (String)"clientId", (int)order.clientId());
        Util.appendValidIntValue((StringBuilder)sb, (String)"parentId", (int)order.parentId());
        Util.appendValidIntValue((StringBuilder)sb, (String)"permId", (int)order.permId());
        Util.appendBooleanFlag((StringBuilder)sb, (String)"outsideRth", (Boolean)order.outsideRth());
        Util.appendBooleanFlag((StringBuilder)sb, (String)"hidden", (Boolean)order.hidden());
        Util.appendValidDoubleValue((StringBuilder)sb, (String)"discretionaryAmt", (double)order.discretionaryAmt());
        Util.appendPositiveIntValue((StringBuilder)sb, (String)"displaySize", (int)order.displaySize());
        Util.appendValidIntValue((StringBuilder)sb, (String)"triggerMethod", (int)order.getTriggerMethod());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"goodAfterTime", (String)order.goodAfterTime());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"goodTillDate", (String)order.goodTillDate());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"faGroup", (String)order.faGroup());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"faMethod", (String)order.getFaMethod());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"faPercentage", (String)order.faPercentage());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"faProfile", (String)order.faProfile());
        Util.appendPositiveIntValue((StringBuilder)sb, (String)"shortSaleSlot", (int)order.shortSaleSlot());
        if (order.shortSaleSlot() > 0) {
            Util.appendNonEmptyString((StringBuilder)sb, (String)"designatedLocation", (String)order.designatedLocation());
            Util.appendValidIntValue((StringBuilder)sb, (String)"exemptCode", (int)order.exemptCode());
        }
        Util.appendNonEmptyString((StringBuilder)sb, (String)"ocaGroup", (String)order.ocaGroup());
        Util.appendPositiveIntValue((StringBuilder)sb, (String)"ocaType", (int)order.getOcaType());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"rule80A", (String)order.getRule80A());
        Util.appendBooleanFlag((StringBuilder)sb, (String)"blockOrder", (Boolean)order.blockOrder());
        Util.appendBooleanFlag((StringBuilder)sb, (String)"sweepToFill", (Boolean)order.sweepToFill());
        Util.appendBooleanFlag((StringBuilder)sb, (String)"allOrNone", (Boolean)order.allOrNone());
        Util.appendValidIntValue((StringBuilder)sb, (String)"minQty", (int)order.minQty());
        Util.appendValidDoubleValue((StringBuilder)sb, (String)"percentOffset", (double)order.percentOffset());
        Util.appendBooleanFlag((StringBuilder)sb, (String)"optOutSmartRouting", (Boolean)order.optOutSmartRouting());
        Util.appendValidDoubleValue((StringBuilder)sb, (String)"startingPrice", (double)order.startingPrice());
        Util.appendValidDoubleValue((StringBuilder)sb, (String)"stockRefPrice", (double)order.stockRefPrice());
        Util.appendValidDoubleValue((StringBuilder)sb, (String)"delta", (double)order.delta());
        Util.appendValidDoubleValue((StringBuilder)sb, (String)"stockRangeLower", (double)order.stockRangeLower());
        Util.appendValidDoubleValue((StringBuilder)sb, (String)"stockRangeUpper", (double)order.stockRangeUpper());
        Util.appendValidDoubleValue((StringBuilder)sb, (String)"volatility", (double)order.volatility());
        if (order.volatility() != Double.MAX_VALUE) {
            Util.appendPositiveIntValue((StringBuilder)sb, (String)"volatilityType", (int)order.getVolatilityType());
            Util.appendNonEmptyString((StringBuilder)sb, (String)"deltaNeutralOrderType", (String)order.getDeltaNeutralOrderType());
            Util.appendValidDoubleValue((StringBuilder)sb, (String)"deltaNeutralAuxPrice", (double)order.deltaNeutralAuxPrice());
            Util.appendPositiveIntValue((StringBuilder)sb, (String)"deltaNeutralConId", (int)order.deltaNeutralConId());
            Util.appendNonEmptyString((StringBuilder)sb, (String)"deltaNeutralSettlingFirm", (String)order.deltaNeutralSettlingFirm());
            Util.appendNonEmptyString((StringBuilder)sb, (String)"deltaNeutralClearingAccount", (String)order.deltaNeutralClearingAccount());
            Util.appendNonEmptyString((StringBuilder)sb, (String)"deltaNeutralClearingIntent", (String)order.deltaNeutralClearingIntent());
            Util.appendNonEmptyString((StringBuilder)sb, (String)"deltaNeutralOpenClose", (String)order.deltaNeutralOpenClose(), (String)"?");
            Util.appendBooleanFlag((StringBuilder)sb, (String)"deltaNeutralShortSale", (Boolean)order.deltaNeutralShortSale());
            if (order.deltaNeutralShortSale()) {
                Util.appendValidIntValue((StringBuilder)sb, (String)"deltaNeutralShortSaleSlot", (int)order.deltaNeutralShortSaleSlot());
                Util.appendNonEmptyString((StringBuilder)sb, (String)"deltaNeutralDesignatedLocation", (String)order.deltaNeutralDesignatedLocation());
            }
            Util.appendBooleanFlag((StringBuilder)sb, (String)"continuousUpdate", (int)order.continuousUpdate());
            Util.appendValidIntValue((StringBuilder)sb, (String)"referencePriceType", (int)order.getReferencePriceType());
        }
        Util.appendValidDoubleValue((StringBuilder)sb, (String)"trailStopPrice", (double)order.trailStopPrice());
        Util.appendValidDoubleValue((StringBuilder)sb, (String)"trailingPercent", (double)order.trailingPercent());
        Util.appendValidDoubleValue((StringBuilder)sb, (String)"lmtPriceOffset", (double)order.lmtPriceOffset());
        Util.appendValidIntValue((StringBuilder)sb, (String)"scaleInitLevelSize", (int)order.scaleInitLevelSize());
        Util.appendValidIntValue((StringBuilder)sb, (String)"scaleSubsLevelSize", (int)order.scaleSubsLevelSize());
        Util.appendValidDoubleValue((StringBuilder)sb, (String)"scalePriceIncrement", (double)order.scalePriceIncrement());
        Util.appendValidDoubleValue((StringBuilder)sb, (String)"scalePriceAdjustValue", (double)order.scalePriceAdjustValue());
        Util.appendValidIntValue((StringBuilder)sb, (String)"scalePriceAdjustInterval", (int)order.scalePriceAdjustInterval());
        Util.appendValidDoubleValue((StringBuilder)sb, (String)"scaleProfitOffset", (double)order.scaleProfitOffset());
        Util.appendBooleanFlag((StringBuilder)sb, (String)"scaleAutoReset", (Boolean)order.scaleAutoReset());
        Util.appendValidIntValue((StringBuilder)sb, (String)"scaleInitPosition", (int)order.scaleInitPosition());
        Util.appendValidIntValue((StringBuilder)sb, (String)"scaleInitFillQty", (int)order.scaleInitFillQty());
        Util.appendBooleanFlag((StringBuilder)sb, (String)"scaleRandomPercent", (Boolean)order.scaleRandomPercent());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"hedgeType", (String)order.getHedgeType());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"hedgeParam", (String)order.hedgeParam());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"account", (String)order.account());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"modelCode", (String)order.modelCode());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"settlingFirm", (String)order.settlingFirm());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"clearingAccount", (String)order.clearingAccount());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"clearingIntent", (String)order.clearingIntent());
        Util.appendBooleanFlag((StringBuilder)sb, (String)"notHeld", (Boolean)order.notHeld());
        Util.appendBooleanFlag((StringBuilder)sb, (String)"whatIf", (Boolean)order.whatIf());
        Util.appendBooleanFlag((StringBuilder)sb, (String)"solicited", (Boolean)order.solicited());
        Util.appendBooleanFlag((StringBuilder)sb, (String)"randomizeSize", (Boolean)order.randomizeSize());
        Util.appendBooleanFlag((StringBuilder)sb, (String)"randomizePrice", (Boolean)order.randomizePrice());
        Util.appendBooleanFlag((StringBuilder)sb, (String)"dontUseAutoPriceForHedge", (Boolean)order.dontUseAutoPriceForHedge());
        Util.appendBooleanFlag((StringBuilder)sb, (String)"isOmsContainer", (Boolean)order.isOmsContainer());
        Util.appendBooleanFlag((StringBuilder)sb, (String)"discretionaryUpToLimitPrice", (Boolean)order.discretionaryUpToLimitPrice());
        Util.appendBooleanFlag((StringBuilder)sb, (String)"usePriceMgmtAlgo", (Boolean)order.usePriceMgmtAlgo());
        if ("PEG BENCH".equals(order.getOrderType())) {
            Util.appendPositiveIntValue((StringBuilder)sb, (String)"referenceContractId", (int)order.referenceContractId());
            Util.appendBooleanFlag((StringBuilder)sb, (String)"isPeggedChangeAmountDecrease", (Boolean)order.isPeggedChangeAmountDecrease());
            Util.appendValidDoubleValue((StringBuilder)sb, (String)"peggedChangeAmount", (double)order.peggedChangeAmount());
            Util.appendValidDoubleValue((StringBuilder)sb, (String)"referenceChangeAmount", (double)order.referenceChangeAmount());
            Util.appendNonEmptyString((StringBuilder)sb, (String)"referenceExchangeId", (String)order.referenceExchangeId());
        }
        if ("BAG".equals(contract.getSecType())) {
            if (contract.comboLegsDescrip() != null) {
                Util.appendNonEmptyString((StringBuilder)sb, (String)"comboLegsDescrip", (String)contract.comboLegsDescrip());
            }
            sb.append(" comboLegs={");
            if (contract.comboLegs() != null) {
                for (int i = 0; i < contract.comboLegs().size(); ++i) {
                    ComboLeg comboLeg = (ComboLeg)contract.comboLegs().get(i);
                    sb.append(" leg ").append(i + 1).append(":");
                    Util.appendPositiveIntValue((StringBuilder)sb, (String)"conid", (int)comboLeg.conid());
                    Util.appendPositiveIntValue((StringBuilder)sb, (String)"ratio", (int)comboLeg.ratio());
                    Util.appendNonEmptyString((StringBuilder)sb, (String)"action", (String)comboLeg.getAction());
                    Util.appendNonEmptyString((StringBuilder)sb, (String)"exchange", (String)comboLeg.exchange());
                    Util.appendValidIntValue((StringBuilder)sb, (String)"openClose", (int)comboLeg.getOpenClose());
                    Util.appendBooleanFlag((StringBuilder)sb, (String)"shortSaleSlot", (int)comboLeg.shortSaleSlot());
                    if (comboLeg.shortSaleSlot() > 0) {
                        Util.appendNonEmptyString((StringBuilder)sb, (String)"designatedLocation", (String)comboLeg.designatedLocation());
                        Util.appendValidIntValue((StringBuilder)sb, (String)"exemptCode", (int)comboLeg.exemptCode());
                    }
                    if (order.orderComboLegs() != null && contract.comboLegs().size() == order.orderComboLegs().size()) {
                        OrderComboLeg orderComboLeg = (OrderComboLeg)order.orderComboLegs().get(i);
                        Util.appendValidDoubleValue((StringBuilder)sb, (String)"price", (double)orderComboLeg.price());
                    }
                    sb.append(';');
                }
            }
            sb.append('}');
            if (order.basisPoints() != Double.MAX_VALUE) {
                Util.appendValidDoubleValue((StringBuilder)sb, (String)"basisPoints", (double)order.basisPoints());
                Util.appendValidIntValue((StringBuilder)sb, (String)"basisPointsType", (int)order.basisPointsType());
            }
        }
        if (contract.deltaNeutralContract() != null) {
            DeltaNeutralContract deltaNeutralContract = contract.deltaNeutralContract();
            sb.append(" deltaNeutralContract={");
            Util.appendPositiveIntValue((StringBuilder)sb, (String)"conid", (int)deltaNeutralContract.conid());
            Util.appendValidDoubleValue((StringBuilder)sb, (String)"delta", (double)deltaNeutralContract.delta());
            Util.appendValidDoubleValue((StringBuilder)sb, (String)"price", (double)deltaNeutralContract.price());
            sb.append("}");
        }
        if (!Util.StringIsEmpty((String)order.getAlgoStrategy())) {
            Util.appendNonEmptyString((StringBuilder)sb, (String)"algoStrategy", (String)order.getAlgoStrategy());
            if (order.algoParams() != null && order.algoParams().size() > 0) {
                sb.append(" algoParams={");
                for (TagValue param : order.algoParams()) {
                    sb.append(param.m_tag).append('=').append(param.m_value).append(',');
                }
                if (!order.algoParams().isEmpty()) {
                    sb.setLength(sb.length() - 1);
                }
                sb.append('}');
            }
        }
        if ("BAG".equals(contract.getSecType()) && order.smartComboRoutingParams() != null && order.smartComboRoutingParams().size() > 0) {
            sb.append(" smartComboRoutingParams={");
            for (TagValue param : order.smartComboRoutingParams()) {
                sb.append(param.m_tag).append('=').append(param.m_value).append(',');
            }
            if (!order.smartComboRoutingParams().isEmpty()) {
                sb.setLength(sb.length() - 1);
            }
            sb.append('}');
        }
        Util.appendNonEmptyString((StringBuilder)sb, (String)"autoCancelDate", (String)order.autoCancelDate());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"filledQuantity", (String)order.filledQuantity().toString());
        Util.appendPositiveIntValue((StringBuilder)sb, (String)"refFuturesConId", (int)order.refFuturesConId());
        Util.appendBooleanFlag((StringBuilder)sb, (String)"autoCancelParent", (Boolean)order.autoCancelParent());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"shareholder", (String)order.shareholder());
        Util.appendBooleanFlag((StringBuilder)sb, (String)"imbalanceOnly", (Boolean)order.imbalanceOnly());
        Util.appendBooleanFlag((StringBuilder)sb, (String)"routeMarketableToBbo", (Boolean)order.routeMarketableToBbo());
        Util.appendValidLongValue((StringBuilder)sb, (String)"parentPermId", (long)order.parentPermId());
        Util.appendValidIntValue((StringBuilder)sb, (String)"duration", (int)order.duration());
        Util.appendValidIntValue((StringBuilder)sb, (String)"postToAts", (int)order.postToAts());
        Util.appendValidIntValue((StringBuilder)sb, (String)"minTradeQty", (int)order.minTradeQty());
        Util.appendValidIntValue((StringBuilder)sb, (String)"minCompeteSize", (int)order.minCompeteSize());
        if (order.competeAgainstBestOffset() != Double.MAX_VALUE) {
            if (order.isCompeteAgainstBestOffsetUpToMid()) {
                sb.append(" ").append("competeAgainstBestOffsetUpToMid");
            } else {
                sb.append(" ").append("competeAgainstBestOffset").append("=").append(order.competeAgainstBestOffset());
            }
        }
        Util.appendValidDoubleValue((StringBuilder)sb, (String)"midOffsetAtWhole", (double)order.midOffsetAtWhole());
        Util.appendValidDoubleValue((StringBuilder)sb, (String)"midOffsetAtHalf", (double)order.midOffsetAtHalf());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"status", (String)orderState.getStatus());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"completedTime", (String)orderState.completedTime());
        Util.appendNonEmptyString((StringBuilder)sb, (String)"completedStatus", (String)orderState.completedStatus());
        if (order.whatIf()) {
            Util.appendValidDoubleValue((StringBuilder)sb, (String)"initMarginBefore", (String)orderState.initMarginBefore());
            Util.appendValidDoubleValue((StringBuilder)sb, (String)"maintMarginBefore", (String)orderState.maintMarginBefore());
            Util.appendValidDoubleValue((StringBuilder)sb, (String)"equityWithLoanBefore", (String)orderState.equityWithLoanBefore());
            Util.appendValidDoubleValue((StringBuilder)sb, (String)"initMarginChange", (String)orderState.initMarginChange());
            Util.appendValidDoubleValue((StringBuilder)sb, (String)"maintMarginChange", (String)orderState.maintMarginChange());
            Util.appendValidDoubleValue((StringBuilder)sb, (String)"equityWithLoanChange", (String)orderState.equityWithLoanChange());
            Util.appendValidDoubleValue((StringBuilder)sb, (String)"initMarginAfter", (String)orderState.initMarginAfter());
            Util.appendValidDoubleValue((StringBuilder)sb, (String)"maintMarginAfter", (String)orderState.maintMarginAfter());
            Util.appendValidDoubleValue((StringBuilder)sb, (String)"equityWithLoanAfter", (String)orderState.equityWithLoanAfter());
            Util.appendValidDoubleValue((StringBuilder)sb, (String)"commission", (double)orderState.commission());
            Util.appendValidDoubleValue((StringBuilder)sb, (String)"minCommission", (double)orderState.minCommission());
            Util.appendValidDoubleValue((StringBuilder)sb, (String)"maxCommission", (double)orderState.maxCommission());
            Util.appendNonEmptyString((StringBuilder)sb, (String)"commissionCurrency", (String)orderState.commissionCurrency());
            Util.appendNonEmptyString((StringBuilder)sb, (String)"warningText", (String)orderState.warningText());
        }
        if (order.conditions() != null && order.conditions().size() > 0) {
            sb.append(" conditions={");
            for (OrderCondition condition : order.conditions()) {
                sb.append(condition).append(";");
            }
            if (!order.conditions().isEmpty()) {
                sb.setLength(sb.length() - 1);
            }
            sb.append('}');
        }
    }
}

