/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.ComboLeg;
import com.ib.client.Contract;
import com.ib.client.DeltaNeutralContract;
import com.ib.client.EDecoder;
import com.ib.client.Order;
import com.ib.client.OrderComboLeg;
import com.ib.client.OrderCondition;
import com.ib.client.OrderConditionType;
import com.ib.client.OrderState;
import com.ib.client.OrderType;
import com.ib.client.SoftDollarTier;
import com.ib.client.TagValue;
import com.ib.client.Util;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.ArrayList;

public class EOrderDecoder {
    private final EDecoder m_eDecoder;
    private final Contract m_contract;
    private final Order m_order;
    private final OrderState m_orderState;
    private final int m_version;
    private final int m_serverVersion;

    EOrderDecoder(EDecoder eDecoder, Contract contract, Order order, OrderState orderState, int version, int serverVersion) {
        this.m_eDecoder = eDecoder;
        this.m_contract = contract;
        this.m_order = order;
        this.m_orderState = orderState;
        this.m_version = version;
        this.m_serverVersion = serverVersion;
    }

    public void readOrderId() throws IOException {
        this.m_order.orderId(this.m_eDecoder.readInt());
    }

    public void readContractFields() throws IOException {
        if (this.m_version >= 17) {
            this.m_contract.conid(this.m_eDecoder.readInt());
        }
        this.m_contract.symbol(this.m_eDecoder.readStr());
        this.m_contract.secType(this.m_eDecoder.readStr());
        this.m_contract.lastTradeDateOrContractMonth(this.m_eDecoder.readStr());
        this.m_contract.strike(this.m_eDecoder.readDouble());
        this.m_contract.right(this.m_eDecoder.readStr());
        if (this.m_version >= 32) {
            this.m_contract.multiplier(this.m_eDecoder.readStr());
        }
        this.m_contract.exchange(this.m_eDecoder.readStr());
        this.m_contract.currency(this.m_eDecoder.readStr());
        if (this.m_version >= 2) {
            this.m_contract.localSymbol(this.m_eDecoder.readStr());
        }
        if (this.m_version >= 32) {
            this.m_contract.tradingClass(this.m_eDecoder.readStr());
        }
    }

    public void readAction() throws IOException {
        this.m_order.action(this.m_eDecoder.readStr());
    }

    public void readTotalQuantity() throws IOException {
        this.m_order.totalQuantity(this.m_eDecoder.readDecimal());
    }

    public void readOrderType() throws IOException {
        this.m_order.orderType(this.m_eDecoder.readStr());
    }

    public void readLmtPrice() throws IOException {
        if (this.m_version < 29) {
            this.m_order.lmtPrice(this.m_eDecoder.readDouble());
        } else {
            this.m_order.lmtPrice(this.m_eDecoder.readDoubleMax());
        }
    }

    public void readAuxPrice() throws IOException {
        if (this.m_version < 30) {
            this.m_order.auxPrice(this.m_eDecoder.readDouble());
        } else {
            this.m_order.auxPrice(this.m_eDecoder.readDoubleMax());
        }
    }

    public void readTIF() throws IOException {
        this.m_order.tif(this.m_eDecoder.readStr());
    }

    public void readOcaGroup() throws IOException {
        this.m_order.ocaGroup(this.m_eDecoder.readStr());
    }

    public void readAccount() throws IOException {
        this.m_order.account(this.m_eDecoder.readStr());
    }

    public void readOpenClose() throws IOException {
        this.m_order.openClose(this.m_eDecoder.readStr());
    }

    public void readOrigin() throws IOException {
        this.m_order.origin(this.m_eDecoder.readInt());
    }

    public void readOrderRef() throws IOException {
        this.m_order.orderRef(this.m_eDecoder.readStr());
    }

    public void readClientId() throws IOException {
        if (this.m_version >= 3) {
            this.m_order.clientId(this.m_eDecoder.readInt());
        }
    }

    public void readPermId() throws IOException {
        if (this.m_version >= 4) {
            this.m_order.permId(this.m_eDecoder.readInt());
        }
    }

    public void readOutsideRth() throws IOException {
        if (this.m_version >= 4) {
            if (this.m_version < 18) {
                this.m_eDecoder.readBoolFromInt();
            } else {
                this.m_order.outsideRth(this.m_eDecoder.readBoolFromInt());
            }
        }
    }

    public void readHidden() throws IOException {
        if (this.m_version >= 4) {
            this.m_order.hidden(this.m_eDecoder.readInt() == 1);
        }
    }

    public void readDiscretionaryAmount() throws IOException {
        if (this.m_version >= 4) {
            this.m_order.discretionaryAmt(this.m_eDecoder.readDouble());
        }
    }

    public void readGoodAfterTime() throws IOException {
        if (this.m_version >= 5) {
            this.m_order.goodAfterTime(this.m_eDecoder.readStr());
        }
    }

    public void skipSharesAllocation() throws IOException {
        if (this.m_version >= 6) {
            this.m_eDecoder.readStr();
        }
    }

    public void readFAParams() throws IOException {
        if (this.m_version >= 7) {
            this.m_order.faGroup(this.m_eDecoder.readStr());
            this.m_order.faMethod(this.m_eDecoder.readStr());
            this.m_order.faPercentage(this.m_eDecoder.readStr());
            this.m_order.faProfile(this.m_eDecoder.readStr());
        }
    }

    public void readModelCode() throws IOException {
        if (this.m_serverVersion >= 103) {
            this.m_order.modelCode(this.m_eDecoder.readStr());
        }
    }

    public void readGoodTillDate() throws IOException {
        if (this.m_version >= 8) {
            this.m_order.goodTillDate(this.m_eDecoder.readStr());
        }
    }

    public void readRule80A() throws IOException {
        if (this.m_version >= 9) {
            this.m_order.rule80A(this.m_eDecoder.readStr());
        }
    }

    public void readPercentOffset() throws IOException {
        if (this.m_version >= 9) {
            this.m_order.percentOffset(this.m_eDecoder.readDoubleMax());
        }
    }

    public void readSettlingFirm() throws IOException {
        if (this.m_version >= 9) {
            this.m_order.settlingFirm(this.m_eDecoder.readStr());
        }
    }

    public void readShortSaleParams() throws IOException {
        if (this.m_version >= 9) {
            this.m_order.shortSaleSlot(this.m_eDecoder.readInt());
            this.m_order.designatedLocation(this.m_eDecoder.readStr());
            if (this.m_serverVersion == 51) {
                this.m_eDecoder.readInt();
            } else if (this.m_version >= 23) {
                this.m_order.exemptCode(this.m_eDecoder.readInt());
            }
        }
    }

    public void readAuctionStrategy() throws IOException {
        if (this.m_version >= 9) {
            this.m_order.auctionStrategy(this.m_eDecoder.readInt());
        }
    }

    public void readBoxOrderParams() throws IOException {
        if (this.m_version >= 9) {
            this.m_order.startingPrice(this.m_eDecoder.readDoubleMax());
            this.m_order.stockRefPrice(this.m_eDecoder.readDoubleMax());
            this.m_order.delta(this.m_eDecoder.readDoubleMax());
        }
    }

    public void readPegToStkOrVolOrderParams() throws IOException {
        if (this.m_version >= 9) {
            this.m_order.stockRangeLower(this.m_eDecoder.readDoubleMax());
            this.m_order.stockRangeUpper(this.m_eDecoder.readDoubleMax());
        }
    }

    public void readDisplaySize() throws IOException {
        if (this.m_version >= 9) {
            this.m_order.displaySize(this.m_eDecoder.readIntMax());
        }
    }

    public void readOldStyleOutsideRth() throws IOException {
        if (this.m_version >= 9 && this.m_version < 18) {
            this.m_eDecoder.readBoolFromInt();
        }
    }

    public void readBlockOrder() throws IOException {
        if (this.m_version >= 9) {
            this.m_order.blockOrder(this.m_eDecoder.readBoolFromInt());
        }
    }

    public void readSweepToFill() throws IOException {
        if (this.m_version >= 9) {
            this.m_order.sweepToFill(this.m_eDecoder.readBoolFromInt());
        }
    }

    public void readAllOrNone() throws IOException {
        if (this.m_version >= 9) {
            this.m_order.allOrNone(this.m_eDecoder.readBoolFromInt());
        }
    }

    public void readMinQty() throws IOException {
        if (this.m_version >= 9) {
            this.m_order.minQty(this.m_eDecoder.readIntMax());
        }
    }

    public void readOcaType() throws IOException {
        if (this.m_version >= 9) {
            this.m_order.ocaType(this.m_eDecoder.readInt());
        }
    }

    public void readETradeOnly() throws IOException {
        if (this.m_version >= 9) {
            this.m_eDecoder.readBoolFromInt();
        }
    }

    public void readFirmQuoteOnly() throws IOException {
        if (this.m_version >= 9) {
            this.m_eDecoder.readBoolFromInt();
        }
    }

    public void readNbboPriceCap() throws IOException {
        if (this.m_version >= 9) {
            this.m_eDecoder.readDoubleMax();
        }
    }

    public void readParentId() throws IOException {
        if (this.m_version >= 10) {
            this.m_order.parentId(this.m_eDecoder.readInt());
        }
    }

    public void readTriggerMethod() throws IOException {
        if (this.m_version >= 10) {
            this.m_order.triggerMethod(this.m_eDecoder.readInt());
        }
    }

    public void readVolOrderParams(boolean readOpenOrderAttribs) throws IOException {
        if (this.m_version >= 11) {
            this.m_order.volatility(this.m_eDecoder.readDoubleMax());
            this.m_order.volatilityType(this.m_eDecoder.readInt());
            if (this.m_version == 11) {
                int receivedInt = this.m_eDecoder.readInt();
                this.m_order.deltaNeutralOrderType(receivedInt == 0 ? "NONE" : "MKT");
            } else {
                this.m_order.deltaNeutralOrderType(this.m_eDecoder.readStr());
                this.m_order.deltaNeutralAuxPrice(this.m_eDecoder.readDoubleMax());
                if (this.m_version >= 27 && !Util.StringIsEmpty((String)this.m_order.getDeltaNeutralOrderType())) {
                    this.m_order.deltaNeutralConId(this.m_eDecoder.readInt());
                    if (readOpenOrderAttribs) {
                        this.m_order.deltaNeutralSettlingFirm(this.m_eDecoder.readStr());
                        this.m_order.deltaNeutralClearingAccount(this.m_eDecoder.readStr());
                        this.m_order.deltaNeutralClearingIntent(this.m_eDecoder.readStr());
                    }
                }
                if (this.m_version >= 31 && !Util.StringIsEmpty((String)this.m_order.getDeltaNeutralOrderType())) {
                    if (readOpenOrderAttribs) {
                        this.m_order.deltaNeutralOpenClose(this.m_eDecoder.readStr());
                    }
                    this.m_order.deltaNeutralShortSale(this.m_eDecoder.readBoolFromInt());
                    this.m_order.deltaNeutralShortSaleSlot(this.m_eDecoder.readInt());
                    this.m_order.deltaNeutralDesignatedLocation(this.m_eDecoder.readStr());
                }
            }
            this.m_order.continuousUpdate(this.m_eDecoder.readInt());
            if (this.m_serverVersion == 26) {
                this.m_order.stockRangeLower(this.m_eDecoder.readDouble());
                this.m_order.stockRangeUpper(this.m_eDecoder.readDouble());
            }
            this.m_order.referencePriceType(this.m_eDecoder.readInt());
        }
    }

    public void readTrailParams() throws IOException {
        if (this.m_version >= 13) {
            this.m_order.trailStopPrice(this.m_eDecoder.readDoubleMax());
        }
        if (this.m_version >= 30) {
            this.m_order.trailingPercent(this.m_eDecoder.readDoubleMax());
        }
    }

    public void readBasisPoints() throws IOException {
        if (this.m_version >= 14) {
            this.m_order.basisPoints(this.m_eDecoder.readDoubleMax());
            this.m_order.basisPointsType(this.m_eDecoder.readIntMax());
        }
    }

    public void readComboLegs() throws IOException {
        if (this.m_version >= 14) {
            this.m_contract.comboLegsDescrip(this.m_eDecoder.readStr());
        }
        if (this.m_version >= 29) {
            int orderComboLegsCount;
            int comboLegsCount = this.m_eDecoder.readInt();
            if (comboLegsCount > 0) {
                this.m_contract.comboLegs(new ArrayList(comboLegsCount));
                for (int i = 0; i < comboLegsCount; ++i) {
                    int conId = this.m_eDecoder.readInt();
                    int ratio = this.m_eDecoder.readInt();
                    String action = this.m_eDecoder.readStr();
                    String exchange = this.m_eDecoder.readStr();
                    int openClose = this.m_eDecoder.readInt();
                    int shortSaleSlot = this.m_eDecoder.readInt();
                    String designatedLocation = this.m_eDecoder.readStr();
                    int exemptCode = this.m_eDecoder.readInt();
                    ComboLeg comboLeg = new ComboLeg(conId, ratio, action, exchange, openClose, shortSaleSlot, designatedLocation, exemptCode);
                    this.m_contract.comboLegs().add(comboLeg);
                }
            }
            if ((orderComboLegsCount = this.m_eDecoder.readInt()) > 0) {
                this.m_order.orderComboLegs(new ArrayList(orderComboLegsCount));
                for (int i = 0; i < orderComboLegsCount; ++i) {
                    double price = this.m_eDecoder.readDoubleMax();
                    OrderComboLeg orderComboLeg = new OrderComboLeg(price);
                    this.m_order.orderComboLegs().add(orderComboLeg);
                }
            }
        }
    }

    public void readSmartComboRoutingParams() throws IOException {
        int smartComboRoutingParamsCount;
        if (this.m_version >= 26 && (smartComboRoutingParamsCount = this.m_eDecoder.readInt()) > 0) {
            this.m_order.smartComboRoutingParams(new ArrayList(smartComboRoutingParamsCount));
            for (int i = 0; i < smartComboRoutingParamsCount; ++i) {
                TagValue tagValue = new TagValue();
                tagValue.m_tag = this.m_eDecoder.readStr();
                tagValue.m_value = this.m_eDecoder.readStr();
                this.m_order.smartComboRoutingParams().add(tagValue);
            }
        }
    }

    public void readScaleOrderParams() throws IOException {
        if (this.m_version >= 15) {
            if (this.m_version >= 20) {
                this.m_order.scaleInitLevelSize(this.m_eDecoder.readIntMax());
                this.m_order.scaleSubsLevelSize(this.m_eDecoder.readIntMax());
            } else {
                this.m_eDecoder.readIntMax();
                this.m_order.scaleInitLevelSize(this.m_eDecoder.readIntMax());
            }
            this.m_order.scalePriceIncrement(this.m_eDecoder.readDoubleMax());
        }
        if (this.m_version >= 28 && this.m_order.scalePriceIncrement() > 0.0 && this.m_order.scalePriceIncrement() != Double.MAX_VALUE) {
            this.m_order.scalePriceAdjustValue(this.m_eDecoder.readDoubleMax());
            this.m_order.scalePriceAdjustInterval(this.m_eDecoder.readIntMax());
            this.m_order.scaleProfitOffset(this.m_eDecoder.readDoubleMax());
            this.m_order.scaleAutoReset(this.m_eDecoder.readBoolFromInt());
            this.m_order.scaleInitPosition(this.m_eDecoder.readIntMax());
            this.m_order.scaleInitFillQty(this.m_eDecoder.readIntMax());
            this.m_order.scaleRandomPercent(this.m_eDecoder.readBoolFromInt());
        }
    }

    public void readHedgeParams() throws IOException {
        if (this.m_version >= 24) {
            this.m_order.hedgeType(this.m_eDecoder.readStr());
            if (!Util.StringIsEmpty((String)this.m_order.getHedgeType())) {
                this.m_order.hedgeParam(this.m_eDecoder.readStr());
            }
        }
    }

    public void readOptOutSmartRouting() throws IOException {
        if (this.m_version >= 25) {
            this.m_order.optOutSmartRouting(this.m_eDecoder.readBoolFromInt());
        }
    }

    public void readClearingParams() throws IOException {
        if (this.m_version >= 19) {
            this.m_order.clearingAccount(this.m_eDecoder.readStr());
            this.m_order.clearingIntent(this.m_eDecoder.readStr());
        }
    }

    public void readNotHeld() throws IOException {
        if (this.m_version >= 22) {
            this.m_order.notHeld(this.m_eDecoder.readBoolFromInt());
        }
    }

    public void readDeltaNeutral() throws IOException {
        if (this.m_version >= 20 && this.m_eDecoder.readBoolFromInt()) {
            DeltaNeutralContract deltaNeutralContract = new DeltaNeutralContract();
            deltaNeutralContract.conid(this.m_eDecoder.readInt());
            deltaNeutralContract.delta(this.m_eDecoder.readDouble());
            deltaNeutralContract.price(this.m_eDecoder.readDouble());
            this.m_contract.deltaNeutralContract(deltaNeutralContract);
        }
    }

    public void readAlgoParams() throws IOException {
        if (this.m_version >= 21) {
            int algoParamsCount;
            this.m_order.algoStrategy(this.m_eDecoder.readStr());
            if (!Util.StringIsEmpty((String)this.m_order.getAlgoStrategy()) && (algoParamsCount = this.m_eDecoder.readInt()) > 0) {
                for (int i = 0; i < algoParamsCount; ++i) {
                    TagValue tagValue = new TagValue();
                    tagValue.m_tag = this.m_eDecoder.readStr();
                    tagValue.m_value = this.m_eDecoder.readStr();
                    this.m_order.algoParams().add(tagValue);
                }
            }
        }
    }

    public void readSolicited() throws IOException {
        if (this.m_version >= 33) {
            this.m_order.solicited(this.m_eDecoder.readBoolFromInt());
        }
    }

    public void readWhatIfInfoAndCommission() throws IOException {
        if (this.m_version >= 16) {
            this.m_order.whatIf(this.m_eDecoder.readBoolFromInt());
            this.readOrderStatus();
            if (this.m_serverVersion >= 142) {
                this.m_orderState.initMarginBefore(this.m_eDecoder.readStr());
                this.m_orderState.maintMarginBefore(this.m_eDecoder.readStr());
                this.m_orderState.equityWithLoanBefore(this.m_eDecoder.readStr());
                this.m_orderState.initMarginChange(this.m_eDecoder.readStr());
                this.m_orderState.maintMarginChange(this.m_eDecoder.readStr());
                this.m_orderState.equityWithLoanChange(this.m_eDecoder.readStr());
            }
            this.m_orderState.initMarginAfter(this.m_eDecoder.readStr());
            this.m_orderState.maintMarginAfter(this.m_eDecoder.readStr());
            this.m_orderState.equityWithLoanAfter(this.m_eDecoder.readStr());
            this.m_orderState.commission(this.m_eDecoder.readDoubleMax());
            this.m_orderState.minCommission(this.m_eDecoder.readDoubleMax());
            this.m_orderState.maxCommission(this.m_eDecoder.readDoubleMax());
            this.m_orderState.commissionCurrency(this.m_eDecoder.readStr());
            this.m_orderState.warningText(this.m_eDecoder.readStr());
        }
    }

    public void readOrderStatus() throws IOException {
        this.m_orderState.status(this.m_eDecoder.readStr());
    }

    public void readVolRandomizeFlags() throws IOException {
        if (this.m_version >= 34) {
            this.m_order.randomizeSize(this.m_eDecoder.readBoolFromInt());
            this.m_order.randomizePrice(this.m_eDecoder.readBoolFromInt());
        }
    }

    public void readPegToBenchParams() throws IOException {
        if (this.m_serverVersion >= 102 && this.m_order.orderType() == OrderType.PEG_BENCH) {
            this.m_order.referenceContractId(this.m_eDecoder.readInt());
            this.m_order.isPeggedChangeAmountDecrease(this.m_eDecoder.readBoolFromInt());
            this.m_order.peggedChangeAmount(this.m_eDecoder.readDouble());
            this.m_order.referenceChangeAmount(this.m_eDecoder.readDouble());
            this.m_order.referenceExchangeId(this.m_eDecoder.readStr());
        }
    }

    public void readConditions() throws IOException {
        int nConditions;
        if (this.m_serverVersion >= 102 && (nConditions = this.m_eDecoder.readInt()) > 0) {
            for (int i = 0; i < nConditions; ++i) {
                OrderConditionType orderConditionType = OrderConditionType.fromInt((int)this.m_eDecoder.readInt());
                OrderCondition condition = OrderCondition.create((OrderConditionType)orderConditionType);
                condition.readFrom((ObjectInput)this.m_eDecoder);
                this.m_order.conditions().add(condition);
            }
            this.m_order.conditionsIgnoreRth(this.m_eDecoder.readBoolFromInt());
            this.m_order.conditionsCancelOrder(this.m_eDecoder.readBoolFromInt());
        }
    }

    public void readAdjustedOrderParams() throws IOException {
        if (this.m_serverVersion >= 102) {
            this.m_order.adjustedOrderType(OrderType.get((String)this.m_eDecoder.readStr()));
            this.m_order.triggerPrice(this.m_eDecoder.readDoubleMax());
            this.readStopPriceAndLmtPriceOffset();
            this.m_order.adjustedStopPrice(this.m_eDecoder.readDoubleMax());
            this.m_order.adjustedStopLimitPrice(this.m_eDecoder.readDoubleMax());
            this.m_order.adjustedTrailingAmount(this.m_eDecoder.readDoubleMax());
            this.m_order.adjustableTrailingUnit(this.m_eDecoder.readInt());
        }
    }

    public void readStopPriceAndLmtPriceOffset() throws IOException {
        this.m_order.trailStopPrice(this.m_eDecoder.readDoubleMax());
        this.m_order.lmtPriceOffset(this.m_eDecoder.readDoubleMax());
    }

    public void readSoftDollarTier() throws IOException {
        if (this.m_serverVersion >= 106) {
            this.m_order.softDollarTier(new SoftDollarTier(this.m_eDecoder.readStr(), this.m_eDecoder.readStr(), this.m_eDecoder.readStr()));
        }
    }

    public void readCashQty() throws IOException {
        if (this.m_serverVersion >= 111) {
            this.m_order.cashQty(this.m_eDecoder.readDoubleMax());
        }
    }

    public void readDontUseAutoPriceForHedge() throws IOException {
        if (this.m_serverVersion >= 141) {
            this.m_order.dontUseAutoPriceForHedge(this.m_eDecoder.readBoolFromInt());
        }
    }

    public void readIsOmsContainer() throws IOException {
        if (this.m_serverVersion >= 145) {
            this.m_order.isOmsContainer(this.m_eDecoder.readBoolFromInt());
        }
    }

    public void readDiscretionaryUpToLimitPrice() throws IOException {
        if (this.m_serverVersion >= 148) {
            this.m_order.discretionaryUpToLimitPrice(this.m_eDecoder.readBoolFromInt());
        }
    }

    public void readAutoCancelDate() throws IOException {
        this.m_order.autoCancelDate(this.m_eDecoder.readStr());
    }

    public void readFilledQuantity() throws IOException {
        this.m_order.filledQuantity(this.m_eDecoder.readDecimal());
    }

    public void readRefFuturesConId() throws IOException {
        this.m_order.refFuturesConId(this.m_eDecoder.readInt());
    }

    public void readAutoCancelParent() throws IOException {
        this.readAutoCancelParent(100);
    }

    public void readAutoCancelParent(int minVersionAutoCancelParent) throws IOException {
        if (this.m_serverVersion >= minVersionAutoCancelParent) {
            this.m_order.autoCancelParent(this.m_eDecoder.readBoolFromInt());
        }
    }

    public void readShareholder() throws IOException {
        this.m_order.shareholder(this.m_eDecoder.readStr());
    }

    public void readImbalanceOnly() throws IOException {
        this.m_order.imbalanceOnly(this.m_eDecoder.readBoolFromInt());
    }

    public void readRouteMarketableToBbo() throws IOException {
        this.m_order.routeMarketableToBbo(this.m_eDecoder.readBoolFromInt());
    }

    public void readParentPermId() throws IOException {
        this.m_order.parentPermId(this.m_eDecoder.readLong());
    }

    public void readCompletedTime() throws IOException {
        this.m_orderState.completedTime(this.m_eDecoder.readStr());
    }

    public void readCompletedStatus() throws IOException {
        this.m_orderState.completedStatus(this.m_eDecoder.readStr());
    }

    public void readUsePriceMgmtAlgo() throws IOException {
        if (this.m_serverVersion >= 151) {
            this.m_order.usePriceMgmtAlgo(Boolean.valueOf(this.m_eDecoder.readBoolFromInt()));
        }
    }

    public void readDuration() throws IOException {
        if (this.m_serverVersion >= 158) {
            this.m_order.duration(this.m_eDecoder.readInt());
        }
    }

    public void readPostToAts() throws IOException {
        if (this.m_serverVersion >= 160) {
            this.m_order.postToAts(this.m_eDecoder.readIntMax());
        }
    }

    public void readPegBestPegMidOrderAttributes() throws IOException {
        if (this.m_serverVersion >= 170) {
            this.m_order.minTradeQty(this.m_eDecoder.readIntMax());
            this.m_order.minCompeteSize(this.m_eDecoder.readIntMax());
            this.m_order.competeAgainstBestOffset(this.m_eDecoder.readDoubleMax());
            this.m_order.midOffsetAtWhole(this.m_eDecoder.readDoubleMax());
            this.m_order.midOffsetAtHalf(this.m_eDecoder.readDoubleMax());
        }
    }
}

