/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.Bar;
import com.ib.client.BitMask;
import com.ib.client.CommissionReport;
import com.ib.client.Contract;
import com.ib.client.ContractDescription;
import com.ib.client.ContractDetails;
import com.ib.client.Decimal;
import com.ib.client.DeltaNeutralContract;
import com.ib.client.DepthMktDataDescription;
import com.ib.client.EClientErrors;
import com.ib.client.EClientMsgSink;
import com.ib.client.EDecoder;
import com.ib.client.EMessage;
import com.ib.client.EOrderDecoder;
import com.ib.client.EWrapper;
import com.ib.client.Execution;
import com.ib.client.FamilyCode;
import com.ib.client.HistogramEntry;
import com.ib.client.HistoricalSession;
import com.ib.client.HistoricalTick;
import com.ib.client.HistoricalTickBidAsk;
import com.ib.client.HistoricalTickLast;
import com.ib.client.NewsProvider;
import com.ib.client.Order;
import com.ib.client.OrderState;
import com.ib.client.PriceIncrement;
import com.ib.client.SoftDollarTier;
import com.ib.client.TagValue;
import com.ib.client.TickAttrib;
import com.ib.client.TickAttribBidAsk;
import com.ib.client.TickAttribLast;
import com.ib.client.TickType;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

/*
 * Exception performing whole class analysis ignored.
 */
class EDecoder
implements ObjectInput {
    private static final int END_CONN = -1;
    private static final int TICK_PRICE = 1;
    private static final int TICK_SIZE = 2;
    private static final int ORDER_STATUS = 3;
    private static final int ERR_MSG = 4;
    private static final int OPEN_ORDER = 5;
    private static final int ACCT_VALUE = 6;
    private static final int PORTFOLIO_VALUE = 7;
    private static final int ACCT_UPDATE_TIME = 8;
    private static final int NEXT_VALID_ID = 9;
    private static final int CONTRACT_DATA = 10;
    private static final int EXECUTION_DATA = 11;
    private static final int MARKET_DEPTH = 12;
    private static final int MARKET_DEPTH_L2 = 13;
    private static final int NEWS_BULLETINS = 14;
    private static final int MANAGED_ACCTS = 15;
    private static final int RECEIVE_FA = 16;
    private static final int HISTORICAL_DATA = 17;
    private static final int BOND_CONTRACT_DATA = 18;
    private static final int SCANNER_PARAMETERS = 19;
    private static final int SCANNER_DATA = 20;
    private static final int TICK_OPTION_COMPUTATION = 21;
    private static final int TICK_GENERIC = 45;
    private static final int TICK_STRING = 46;
    private static final int TICK_EFP = 47;
    private static final int CURRENT_TIME = 49;
    private static final int REAL_TIME_BARS = 50;
    private static final int FUNDAMENTAL_DATA = 51;
    private static final int CONTRACT_DATA_END = 52;
    private static final int OPEN_ORDER_END = 53;
    private static final int ACCT_DOWNLOAD_END = 54;
    private static final int EXECUTION_DATA_END = 55;
    private static final int DELTA_NEUTRAL_VALIDATION = 56;
    private static final int TICK_SNAPSHOT_END = 57;
    private static final int MARKET_DATA_TYPE = 58;
    private static final int COMMISSION_REPORT = 59;
    private static final int POSITION = 61;
    private static final int POSITION_END = 62;
    private static final int ACCOUNT_SUMMARY = 63;
    private static final int ACCOUNT_SUMMARY_END = 64;
    private static final int VERIFY_MESSAGE_API = 65;
    private static final int VERIFY_COMPLETED = 66;
    private static final int DISPLAY_GROUP_LIST = 67;
    private static final int DISPLAY_GROUP_UPDATED = 68;
    private static final int VERIFY_AND_AUTH_MESSAGE_API = 69;
    private static final int VERIFY_AND_AUTH_COMPLETED = 70;
    private static final int POSITION_MULTI = 71;
    private static final int POSITION_MULTI_END = 72;
    private static final int ACCOUNT_UPDATE_MULTI = 73;
    private static final int ACCOUNT_UPDATE_MULTI_END = 74;
    private static final int SECURITY_DEFINITION_OPTION_PARAMETER = 75;
    private static final int SECURITY_DEFINITION_OPTION_PARAMETER_END = 76;
    private static final int SOFT_DOLLAR_TIERS = 77;
    private static final int FAMILY_CODES = 78;
    private static final int SYMBOL_SAMPLES = 79;
    private static final int MKT_DEPTH_EXCHANGES = 80;
    private static final int TICK_REQ_PARAMS = 81;
    private static final int SMART_COMPONENTS = 82;
    private static final int NEWS_ARTICLE = 83;
    private static final int TICK_NEWS = 84;
    private static final int NEWS_PROVIDERS = 85;
    private static final int HISTORICAL_NEWS = 86;
    private static final int HISTORICAL_NEWS_END = 87;
    private static final int HEAD_TIMESTAMP = 88;
    private static final int HISTOGRAM_DATA = 89;
    private static final int HISTORICAL_DATA_UPDATE = 90;
    private static final int REROUTE_MKT_DATA_REQ = 91;
    private static final int REROUTE_MKT_DEPTH_REQ = 92;
    private static final int MARKET_RULE = 93;
    private static final int PNL = 94;
    private static final int PNL_SINGLE = 95;
    private static final int HISTORICAL_TICKS = 96;
    private static final int HISTORICAL_TICKS_BID_ASK = 97;
    private static final int HISTORICAL_TICKS_LAST = 98;
    private static final int TICK_BY_TICK = 99;
    private static final int ORDER_BOUND = 100;
    private static final int COMPLETED_ORDER = 101;
    private static final int COMPLETED_ORDERS_END = 102;
    private static final int REPLACE_FA_END = 103;
    private static final int WSH_META_DATA = 104;
    private static final int WSH_EVENT_DATA = 105;
    private static final int HISTORICAL_SCHEDULE = 106;
    private static final int USER_INFO = 107;
    static final int MAX_MSG_LENGTH = 0xFFFFFF;
    private static final int REDIRECT_MSG_ID = -1;
    private EClientMsgSink m_clientMsgSink;
    private EWrapper m_EWrapper;
    private int m_serverVersion;
    private IMessageReader m_messageReader;

    public EDecoder(int serverVersion, EWrapper callback) {
        this(serverVersion, callback, null);
    }

    public EDecoder(int serverVersion, EWrapper callback, EClientMsgSink sink) {
        this.m_clientMsgSink = sink;
        this.m_serverVersion = serverVersion;
        this.m_EWrapper = callback;
    }

    private void processFirstMsg() throws IOException {
        this.m_serverVersion = this.readInt();
        if (this.m_serverVersion == -1) {
            String newAddress = this.readStr();
            this.m_serverVersion = 0;
            if (this.m_clientMsgSink != null) {
                this.m_clientMsgSink.redirect(newAddress);
            }
            return;
        }
        if (this.m_serverVersion >= 20) {
            String twsTime = this.readStr();
            if (this.m_clientMsgSink != null) {
                this.m_clientMsgSink.serverVersion(this.m_serverVersion, twsTime);
            }
        } else if (this.m_clientMsgSink != null) {
            this.m_clientMsgSink.serverVersion(this.m_serverVersion, null);
        }
        this.m_EWrapper.connectAck();
    }

    private boolean readMessageToInternalBuf(InputStream dis) {
        this.m_messageReader = new PreV100MessageReader(dis);
        return true;
    }

    public int processMsg(EMessage msg) throws IOException {
        if (!this.readMessageToInternalBuf(msg.getStream())) {
            return 0;
        }
        if (this.m_serverVersion == 0) {
            this.processFirstMsg();
            return this.m_messageReader.msgLength();
        }
        int msgId = this.readInt();
        switch (msgId) {
            case -1: {
                return 0;
            }
            case 1: {
                this.processTickPriceMsg();
                break;
            }
            case 2: {
                this.processTickSizeMsg();
                break;
            }
            case 61: {
                this.processPositionMsg();
                break;
            }
            case 62: {
                this.processPositionEndMsg();
                break;
            }
            case 63: {
                this.processAccountSummaryMsg();
                break;
            }
            case 64: {
                this.processAccountSummaryEndMsg();
                break;
            }
            case 21: {
                this.processTickOptionComputationMsg();
                break;
            }
            case 45: {
                this.processTickGenericMsg();
                break;
            }
            case 46: {
                this.processTickStringMsg();
                break;
            }
            case 47: {
                this.processTickEFPMsg();
                break;
            }
            case 3: {
                this.processOrderStatusMsg();
                break;
            }
            case 6: {
                this.processAcctValueMsg();
                break;
            }
            case 7: {
                this.processPortfolioValueMsg();
                break;
            }
            case 8: {
                this.processAcctUpdateTimeMsg();
                break;
            }
            case 4: {
                this.processErrMsgMsg();
                break;
            }
            case 5: {
                this.processOpenOrderMsg();
                break;
            }
            case 9: {
                this.processNextValidIdMsg();
                break;
            }
            case 20: {
                this.processScannerDataMsg();
                break;
            }
            case 10: {
                this.processContractDataMsg();
                break;
            }
            case 18: {
                this.processBondContractDataMsg();
                break;
            }
            case 11: {
                this.processExecutionDataMsg();
                break;
            }
            case 12: {
                this.processMarketDepthMsg();
                break;
            }
            case 13: {
                this.processMarketDepthL2Msg();
                break;
            }
            case 14: {
                this.processNewsBulletinsMsg();
                break;
            }
            case 15: {
                this.processManagedAcctsMsg();
                break;
            }
            case 16: {
                this.processReceiveFaMsg();
                break;
            }
            case 17: {
                this.processHistoricalDataMsg();
                break;
            }
            case 19: {
                this.processScannerParametersMsg();
                break;
            }
            case 49: {
                this.processCurrentTimeMsg();
                break;
            }
            case 50: {
                this.processRealTimeBarsMsg();
                break;
            }
            case 51: {
                this.processFundamentalDataMsg();
                break;
            }
            case 52: {
                this.processContractDataEndMsg();
                break;
            }
            case 53: {
                this.processOpenOrderEndMsg();
                break;
            }
            case 54: {
                this.processAcctDownloadEndMsg();
                break;
            }
            case 55: {
                this.processExecutionDataEndMsg();
                break;
            }
            case 56: {
                this.processDeltaNeutralValidationMsg();
                break;
            }
            case 57: {
                this.processTickSnapshotEndMsg();
                break;
            }
            case 58: {
                this.processMarketDataTypeMsg();
                break;
            }
            case 59: {
                this.processCommissionReportMsg();
                break;
            }
            case 65: {
                this.processVerifyMessageApiMsg();
                break;
            }
            case 66: {
                this.processVerifyCompletedMsg();
                break;
            }
            case 67: {
                this.processDisplayGroupListMsg();
                break;
            }
            case 68: {
                this.processDisplayGroupUpdatedMsg();
                break;
            }
            case 69: {
                this.processVerifyAndAuthMessageMsg();
                break;
            }
            case 70: {
                this.processVerifyAndAuthCompletedMsg();
                break;
            }
            case 71: {
                this.processPositionMultiMsg();
                break;
            }
            case 72: {
                this.processPositionMultiEndMsg();
                break;
            }
            case 73: {
                this.processAccountUpdateMultiMsg();
                break;
            }
            case 74: {
                this.processAccountUpdateMultiEndMsg();
                break;
            }
            case 75: {
                this.processSecurityDefinitionOptionalParameterMsg();
                break;
            }
            case 76: {
                this.processSecurityDefinitionOptionalParameterEndMsg();
                break;
            }
            case 77: {
                this.processSoftDollarTiersMsg();
                break;
            }
            case 78: {
                this.processFamilyCodesMsg();
                break;
            }
            case 82: {
                this.processSmartComponentsMsg();
                break;
            }
            case 81: {
                this.processTickReqParamsMsg();
                break;
            }
            case 79: {
                this.processSymbolSamplesMsg();
                break;
            }
            case 80: {
                this.processMktDepthExchangesMsg();
                break;
            }
            case 88: {
                this.processHeadTimestampMsg();
                break;
            }
            case 84: {
                this.processTickNewsMsg();
                break;
            }
            case 85: {
                this.processNewsProvidersMsg();
                break;
            }
            case 83: {
                this.processNewsArticleMsg();
                break;
            }
            case 86: {
                this.processHistoricalNewsMsg();
                break;
            }
            case 87: {
                this.processHistoricalNewsEndMsg();
                break;
            }
            case 89: {
                this.processHistogramDataMsg();
                break;
            }
            case 90: {
                this.processHistoricalDataUpdateMsg();
                break;
            }
            case 91: {
                this.processRerouteMktDataReq();
                break;
            }
            case 92: {
                this.processRerouteMktDepthReq();
                break;
            }
            case 93: {
                this.processMarketRuleMsg();
                break;
            }
            case 94: {
                this.processPnLMsg();
                break;
            }
            case 95: {
                this.processPnLSingleMsg();
                break;
            }
            case 96: {
                this.processHistoricalTicks();
                break;
            }
            case 97: {
                this.processHistoricalTicksBidAsk();
                break;
            }
            case 98: {
                this.processHistoricalTicksLast();
                break;
            }
            case 99: {
                this.processTickByTickMsg();
                break;
            }
            case 100: {
                this.processOrderBoundMsg();
                break;
            }
            case 101: {
                this.processCompletedOrderMsg();
                break;
            }
            case 102: {
                this.processCompletedOrdersEndMsg();
                break;
            }
            case 103: {
                this.processReplaceFAEndMsg();
                break;
            }
            case 104: {
                this.processWshMetaData();
                break;
            }
            case 105: {
                this.processWshEventData();
                break;
            }
            case 106: {
                this.processHistoricalSchedule();
                break;
            }
            case 107: {
                this.processUserInfo();
                break;
            }
            default: {
                this.m_EWrapper.error(-1, EClientErrors.UNKNOWN_ID.code(), EClientErrors.UNKNOWN_ID.msg(), null);
                return 0;
            }
        }
        this.m_messageReader.close();
        return this.m_messageReader.msgLength();
    }

    private void processHistoricalTicksLast() throws IOException {
        int reqId = this.readInt();
        int tickCount = this.readInt();
        ArrayList<HistoricalTickLast> ticks = new ArrayList<HistoricalTickLast>();
        for (int i = 0; i < tickCount; ++i) {
            long time = this.readLong();
            BitMask mask = new BitMask(this.readInt());
            TickAttribLast tickAttribLast = new TickAttribLast();
            tickAttribLast.pastLimit(mask.get(0));
            tickAttribLast.unreported(mask.get(1));
            double price = this.readDouble();
            Decimal size = this.readDecimal();
            String exchange = this.readStr();
            String specialConditions = this.readStr();
            ticks.add(new HistoricalTickLast(time, tickAttribLast, price, size, exchange, specialConditions));
        }
        boolean done = this.readBoolean();
        this.m_EWrapper.historicalTicksLast(reqId, ticks, done);
    }

    private void processHistoricalTicksBidAsk() throws IOException {
        int reqId = this.readInt();
        int tickCount = this.readInt();
        ArrayList<HistoricalTickBidAsk> ticks = new ArrayList<HistoricalTickBidAsk>();
        for (int i = 0; i < tickCount; ++i) {
            long time = this.readLong();
            BitMask mask = new BitMask(this.readInt());
            TickAttribBidAsk tickAttribBidAsk = new TickAttribBidAsk();
            tickAttribBidAsk.askPastHigh(mask.get(0));
            tickAttribBidAsk.bidPastLow(mask.get(1));
            double priceBid = this.readDouble();
            double priceAsk = this.readDouble();
            Decimal sizeBid = this.readDecimal();
            Decimal sizeAsk = this.readDecimal();
            ticks.add(new HistoricalTickBidAsk(time, tickAttribBidAsk, priceBid, priceAsk, sizeBid, sizeAsk));
        }
        boolean done = this.readBoolean();
        this.m_EWrapper.historicalTicksBidAsk(reqId, ticks, done);
    }

    private void processHistoricalTicks() throws IOException {
        int reqId = this.readInt();
        int tickCount = this.readInt();
        ArrayList<HistoricalTick> ticks = new ArrayList<HistoricalTick>();
        for (int i = 0; i < tickCount; ++i) {
            long time = this.readLong();
            this.readInt();
            double price = this.readDouble();
            Decimal size = this.readDecimal();
            ticks.add(new HistoricalTick(time, price, size));
        }
        boolean done = this.readBoolean();
        this.m_EWrapper.historicalTicks(reqId, ticks, done);
    }

    private void processMarketRuleMsg() throws IOException {
        PriceIncrement[] priceIncrements;
        int marketRuleId = this.readInt();
        int nPriceIncrements = this.readInt();
        if (nPriceIncrements > 0) {
            priceIncrements = new PriceIncrement[nPriceIncrements];
            for (int i = 0; i < nPriceIncrements; ++i) {
                priceIncrements[i] = new PriceIncrement(this.readDouble(), this.readDouble());
            }
        } else {
            priceIncrements = new PriceIncrement[]{};
        }
        this.m_EWrapper.marketRule(marketRuleId, priceIncrements);
    }

    private void processRerouteMktDepthReq() throws IOException {
        int reqId = this.readInt();
        int conId = this.readInt();
        String exchange = this.readStr();
        this.m_EWrapper.rerouteMktDepthReq(reqId, conId, exchange);
    }

    private void processRerouteMktDataReq() throws IOException {
        int reqId = this.readInt();
        int conId = this.readInt();
        String exchange = this.readStr();
        this.m_EWrapper.rerouteMktDataReq(reqId, conId, exchange);
    }

    private void processHistoricalDataUpdateMsg() throws IOException {
        int reqId = this.readInt();
        int barCount = this.readInt();
        String date = this.readStr();
        double open = this.readDouble();
        double close = this.readDouble();
        double high = this.readDouble();
        double low = this.readDouble();
        Decimal WAP = this.readDecimal();
        Decimal volume = this.readDecimal();
        this.m_EWrapper.historicalDataUpdate(reqId, new Bar(date, open, high, low, close, volume, barCount, WAP));
    }

    private void processPnLSingleMsg() throws IOException {
        int reqId = this.readInt();
        Decimal pos = this.readDecimal();
        double dailyPnL = this.readDouble();
        double unrealizedPnL = Double.MAX_VALUE;
        double realizedPnL = Double.MAX_VALUE;
        if (this.m_serverVersion >= 129) {
            unrealizedPnL = this.readDouble();
        }
        if (this.m_serverVersion >= 135) {
            realizedPnL = this.readDouble();
        }
        double value = this.readDouble();
        this.m_EWrapper.pnlSingle(reqId, pos, dailyPnL, unrealizedPnL, realizedPnL, value);
    }

    private void processPnLMsg() throws IOException {
        int reqId = this.readInt();
        double dailyPnL = this.readDouble();
        double unrealizedPnL = Double.MAX_VALUE;
        double realizedPnL = Double.MAX_VALUE;
        if (this.m_serverVersion >= 129) {
            unrealizedPnL = this.readDouble();
        }
        if (this.m_serverVersion >= 135) {
            realizedPnL = this.readDouble();
        }
        this.m_EWrapper.pnl(reqId, dailyPnL, unrealizedPnL, realizedPnL);
    }

    private void processHistogramDataMsg() throws IOException {
        int reqId = this.readInt();
        int n = this.readInt();
        ArrayList<HistogramEntry> items = new ArrayList<HistogramEntry>(n);
        for (int i = 0; i < n; ++i) {
            items.add(new HistogramEntry(this.readDouble(), this.readDecimal()));
        }
        this.m_EWrapper.histogramData(reqId, items);
    }

    private void processHistoricalNewsEndMsg() throws IOException {
        int requestId = this.readInt();
        boolean hasMore = this.readBoolFromInt();
        this.m_EWrapper.historicalNewsEnd(requestId, hasMore);
    }

    private void processHistoricalNewsMsg() throws IOException {
        int requestId = this.readInt();
        String time = this.readStr();
        String providerCode = this.readStr();
        String articleId = this.readStr();
        String headline = this.readStr();
        this.m_EWrapper.historicalNews(requestId, time, providerCode, articleId, headline);
    }

    private void processNewsArticleMsg() throws IOException {
        int requestId = this.readInt();
        int articleType = this.readInt();
        String articleText = this.readStr();
        this.m_EWrapper.newsArticle(requestId, articleType, articleText);
    }

    private void processNewsProvidersMsg() throws IOException {
        NewsProvider[] newsProviders = new NewsProvider[]{};
        int nNewsProviders = this.readInt();
        if (nNewsProviders > 0) {
            newsProviders = new NewsProvider[nNewsProviders];
            for (int i = 0; i < nNewsProviders; ++i) {
                newsProviders[i] = new NewsProvider(this.readStr(), this.readStr());
            }
        }
        this.m_EWrapper.newsProviders(newsProviders);
    }

    private void processTickNewsMsg() throws IOException {
        int tickerId = this.readInt();
        long timeStamp = this.readLong();
        String providerCode = this.readStr();
        String articleId = this.readStr();
        String headline = this.readStr();
        String extraData = this.readStr();
        this.m_EWrapper.tickNews(tickerId, timeStamp, providerCode, articleId, headline, extraData);
    }

    private void processHeadTimestampMsg() throws IOException {
        int reqId = this.readInt();
        String headTimestamp = this.readStr();
        this.m_EWrapper.headTimestamp(reqId, headTimestamp);
    }

    private void processMktDepthExchangesMsg() throws IOException {
        DepthMktDataDescription[] depthMktDataDescriptions = new DepthMktDataDescription[]{};
        int nDepthMktDataDescriptions = this.readInt();
        if (nDepthMktDataDescriptions > 0) {
            depthMktDataDescriptions = new DepthMktDataDescription[nDepthMktDataDescriptions];
            for (int i = 0; i < nDepthMktDataDescriptions; ++i) {
                depthMktDataDescriptions[i] = this.m_serverVersion >= 120 ? new DepthMktDataDescription(this.readStr(), this.readStr(), this.readStr(), this.readStr(), this.readIntMax()) : new DepthMktDataDescription(this.readStr(), this.readStr(), "", this.readBoolFromInt() ? "Deep2" : "Deep", Integer.MAX_VALUE);
            }
        }
        this.m_EWrapper.mktDepthExchanges(depthMktDataDescriptions);
    }

    private void processSymbolSamplesMsg() throws IOException {
        int reqId = this.readInt();
        ContractDescription[] contractDescriptions = new ContractDescription[]{};
        int nContractDescriptions = this.readInt();
        if (nContractDescriptions > 0) {
            contractDescriptions = new ContractDescription[nContractDescriptions];
            for (int i = 0; i < nContractDescriptions; ++i) {
                ContractDescription contractDescription;
                Contract contract = new Contract();
                contract.conid(this.readInt());
                contract.symbol(this.readStr());
                contract.secType(this.readStr());
                contract.primaryExch(this.readStr());
                contract.currency(this.readStr());
                String[] derivativeSecTypes = new String[]{};
                int nDerivativeSecTypes = this.readInt();
                if (nDerivativeSecTypes > 0) {
                    derivativeSecTypes = new String[nDerivativeSecTypes];
                    for (int j = 0; j < nDerivativeSecTypes; ++j) {
                        derivativeSecTypes[j] = this.readStr();
                    }
                }
                if (this.m_serverVersion >= 176) {
                    contract.description(this.readStr());
                    contract.issuerId(this.readStr());
                }
                contractDescriptions[i] = contractDescription = new ContractDescription(contract, derivativeSecTypes);
            }
        }
        this.m_EWrapper.symbolSamples(reqId, contractDescriptions);
    }

    private void processFamilyCodesMsg() throws IOException {
        FamilyCode[] familyCodes = new FamilyCode[]{};
        int nFamilyCodes = this.readInt();
        if (nFamilyCodes > 0) {
            familyCodes = new FamilyCode[nFamilyCodes];
            for (int i = 0; i < nFamilyCodes; ++i) {
                familyCodes[i] = new FamilyCode(this.readStr(), this.readStr());
            }
        }
        this.m_EWrapper.familyCodes(familyCodes);
    }

    private void processSoftDollarTiersMsg() throws IOException {
        int reqId = this.readInt();
        int nTiers = this.readInt();
        SoftDollarTier[] tiers = new SoftDollarTier[nTiers];
        for (int i = 0; i < nTiers; ++i) {
            tiers[i] = new SoftDollarTier(this.readStr(), this.readStr(), this.readStr());
        }
        this.m_EWrapper.softDollarTiers(reqId, tiers);
    }

    private void processSecurityDefinitionOptionalParameterEndMsg() throws IOException {
        int reqId = this.readInt();
        this.m_EWrapper.securityDefinitionOptionalParameterEnd(reqId);
    }

    private void processSecurityDefinitionOptionalParameterMsg() throws IOException {
        int reqId = this.readInt();
        String exchange = this.readStr();
        int underlyingConId = this.readInt();
        String tradingClass = this.readStr();
        String multiplier = this.readStr();
        int expirationsSize = this.readInt();
        HashSet<String> expirations = new HashSet<String>();
        HashSet<Double> strikes = new HashSet<Double>();
        for (int i = 0; i < expirationsSize; ++i) {
            expirations.add(this.readStr());
        }
        int strikesSize = this.readInt();
        for (int i = 0; i < strikesSize; ++i) {
            strikes.add(this.readDouble());
        }
        this.m_EWrapper.securityDefinitionOptionalParameter(reqId, exchange, underlyingConId, tradingClass, multiplier, expirations, strikes);
    }

    private void processVerifyAndAuthCompletedMsg() throws IOException {
        this.readInt();
        String isSuccessfulStr = this.readStr();
        boolean isSuccessful = "true".equals(isSuccessfulStr);
        String errorText = this.readStr();
        this.m_EWrapper.verifyAndAuthCompleted(isSuccessful, errorText);
    }

    private void processVerifyAndAuthMessageMsg() throws IOException {
        this.readInt();
        String apiData = this.readStr();
        String xyzChallenge = this.readStr();
        this.m_EWrapper.verifyAndAuthMessageAPI(apiData, xyzChallenge);
    }

    private void processDisplayGroupUpdatedMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        String contractInfo = this.readStr();
        this.m_EWrapper.displayGroupUpdated(reqId, contractInfo);
    }

    private void processDisplayGroupListMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        String groups = this.readStr();
        this.m_EWrapper.displayGroupList(reqId, groups);
    }

    private void processVerifyCompletedMsg() throws IOException {
        this.readInt();
        String isSuccessfulStr = this.readStr();
        boolean isSuccessful = "true".equals(isSuccessfulStr);
        String errorText = this.readStr();
        this.m_EWrapper.verifyCompleted(isSuccessful, errorText);
    }

    private void processVerifyMessageApiMsg() throws IOException {
        this.readInt();
        String apiData = this.readStr();
        this.m_EWrapper.verifyMessageAPI(apiData);
    }

    private void processCommissionReportMsg() throws IOException {
        this.readInt();
        CommissionReport commissionReport = new CommissionReport();
        commissionReport.execId(this.readStr());
        commissionReport.commission(this.readDouble());
        commissionReport.currency(this.readStr());
        commissionReport.realizedPNL(this.readDouble());
        commissionReport.yield(this.readDouble());
        commissionReport.yieldRedemptionDate(this.readInt());
        this.m_EWrapper.commissionReport(commissionReport);
    }

    private void processMarketDataTypeMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        int marketDataType = this.readInt();
        this.m_EWrapper.marketDataType(reqId, marketDataType);
    }

    private void processTickSnapshotEndMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        this.m_EWrapper.tickSnapshotEnd(reqId);
    }

    private void processDeltaNeutralValidationMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        DeltaNeutralContract deltaNeutralContract = new DeltaNeutralContract(this.readInt(), this.readDouble(), this.readDouble());
        this.m_EWrapper.deltaNeutralValidation(reqId, deltaNeutralContract);
    }

    private void processExecutionDataEndMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        this.m_EWrapper.execDetailsEnd(reqId);
    }

    private void processAcctDownloadEndMsg() throws IOException {
        this.readInt();
        String accountName = this.readStr();
        this.m_EWrapper.accountDownloadEnd(accountName);
    }

    private void processOpenOrderEndMsg() throws IOException {
        this.readInt();
        this.m_EWrapper.openOrderEnd();
    }

    private void processContractDataEndMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        this.m_EWrapper.contractDetailsEnd(reqId);
    }

    private void processFundamentalDataMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        String data = this.readStr();
        this.m_EWrapper.fundamentalData(reqId, data);
    }

    private void processRealTimeBarsMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        long time = this.readLong();
        double open = this.readDouble();
        double high = this.readDouble();
        double low = this.readDouble();
        double close = this.readDouble();
        Decimal volume = this.readDecimal();
        Decimal wap = this.readDecimal();
        int count = this.readInt();
        this.m_EWrapper.realtimeBar(reqId, time, open, high, low, close, volume, wap, count);
    }

    private void processCurrentTimeMsg() throws IOException {
        this.readInt();
        long time = this.readLong();
        this.m_EWrapper.currentTime(time);
    }

    private void processScannerParametersMsg() throws IOException {
        this.readInt();
        String xml = this.readStr();
        this.m_EWrapper.scannerParameters(xml);
    }

    private void processHistoricalDataMsg() throws IOException {
        int version = Integer.MAX_VALUE;
        if (this.m_serverVersion < 124) {
            version = this.readInt();
        }
        int reqId = this.readInt();
        String startDateStr = "";
        String endDateStr = "";
        if (version >= 2) {
            startDateStr = this.readStr();
            endDateStr = this.readStr();
        }
        int itemCount = this.readInt();
        for (int ctr = 0; ctr < itemCount; ++ctr) {
            String date = this.readStr();
            double open = this.readDouble();
            double high = this.readDouble();
            double low = this.readDouble();
            double close = this.readDouble();
            Decimal volume = this.readDecimal();
            Decimal WAP = this.readDecimal();
            if (this.m_serverVersion < 124) {
                this.readStr();
            }
            int barCount = -1;
            if (version >= 3) {
                barCount = this.readInt();
            }
            this.m_EWrapper.historicalData(reqId, new Bar(date, open, high, low, close, volume, barCount, WAP));
        }
        this.m_EWrapper.historicalDataEnd(reqId, startDateStr, endDateStr);
    }

    private void processReceiveFaMsg() throws IOException {
        this.readInt();
        int faDataType = this.readInt();
        String xml = this.readStr();
        this.m_EWrapper.receiveFA(faDataType, xml);
    }

    private void processManagedAcctsMsg() throws IOException {
        this.readInt();
        String accountsList = this.readStr();
        this.m_EWrapper.managedAccounts(accountsList);
    }

    private void processNewsBulletinsMsg() throws IOException {
        this.readInt();
        int newsMsgId = this.readInt();
        int newsMsgType = this.readInt();
        String newsMessage = this.readStr();
        String originatingExch = this.readStr();
        this.m_EWrapper.updateNewsBulletin(newsMsgId, newsMsgType, newsMessage, originatingExch);
    }

    private void processMarketDepthL2Msg() throws IOException {
        this.readInt();
        int id = this.readInt();
        int position = this.readInt();
        String marketMaker = this.readStr();
        int operation = this.readInt();
        int side = this.readInt();
        double price = this.readDouble();
        Decimal size = this.readDecimal();
        boolean isSmartDepth = false;
        if (this.m_serverVersion >= 146) {
            isSmartDepth = this.readBoolFromInt();
        }
        this.m_EWrapper.updateMktDepthL2(id, position, marketMaker, operation, side, price, size, isSmartDepth);
    }

    private void processMarketDepthMsg() throws IOException {
        this.readInt();
        int id = this.readInt();
        int position = this.readInt();
        int operation = this.readInt();
        int side = this.readInt();
        double price = this.readDouble();
        Decimal size = this.readDecimal();
        this.m_EWrapper.updateMktDepth(id, position, operation, side, price, size);
    }

    private void processExecutionDataMsg() throws IOException {
        int version = this.m_serverVersion;
        if (this.m_serverVersion < 136) {
            version = this.readInt();
        }
        int reqId = -1;
        if (version >= 7) {
            reqId = this.readInt();
        }
        int orderId = this.readInt();
        Contract contract = new Contract();
        if (version >= 5) {
            contract.conid(this.readInt());
        }
        contract.symbol(this.readStr());
        contract.secType(this.readStr());
        contract.lastTradeDateOrContractMonth(this.readStr());
        contract.strike(this.readDouble());
        contract.right(this.readStr());
        if (version >= 9) {
            contract.multiplier(this.readStr());
        }
        contract.exchange(this.readStr());
        contract.currency(this.readStr());
        contract.localSymbol(this.readStr());
        if (version >= 10) {
            contract.tradingClass(this.readStr());
        }
        Execution exec = new Execution();
        exec.orderId(orderId);
        exec.execId(this.readStr());
        exec.time(this.readStr());
        exec.acctNumber(this.readStr());
        exec.exchange(this.readStr());
        exec.side(this.readStr());
        exec.shares(this.readDecimal());
        exec.price(this.readDouble());
        if (version >= 2) {
            exec.permId(this.readInt());
        }
        if (version >= 3) {
            exec.clientId(this.readInt());
        }
        if (version >= 4) {
            exec.liquidation(this.readInt());
        }
        if (version >= 6) {
            exec.cumQty(this.readDecimal());
            exec.avgPrice(this.readDouble());
        }
        if (version >= 8) {
            exec.orderRef(this.readStr());
        }
        if (version >= 9) {
            exec.evRule(this.readStr());
            exec.evMultiplier(this.readDouble());
        }
        if (this.m_serverVersion >= 103) {
            exec.modelCode(this.readStr());
        }
        if (this.m_serverVersion >= 136) {
            exec.lastLiquidity(this.readInt());
        }
        this.m_EWrapper.execDetails(reqId, contract, exec);
    }

    private void processBondContractDataMsg() throws IOException {
        int secIdListCount;
        int version = 6;
        if (this.m_serverVersion < 164) {
            version = this.readInt();
        }
        int reqId = -1;
        if (version >= 3) {
            reqId = this.readInt();
        }
        ContractDetails contract = new ContractDetails();
        contract.contract().symbol(this.readStr());
        contract.contract().secType(this.readStr());
        contract.cusip(this.readStr());
        contract.coupon(this.readDouble());
        this.readLastTradeDate(contract, true);
        contract.issueDate(this.readStr());
        contract.ratings(this.readStr());
        contract.bondType(this.readStr());
        contract.couponType(this.readStr());
        contract.convertible(this.readBoolFromInt());
        contract.callable(this.readBoolFromInt());
        contract.putable(this.readBoolFromInt());
        contract.descAppend(this.readStr());
        contract.contract().exchange(this.readStr());
        contract.contract().currency(this.readStr());
        contract.marketName(this.readStr());
        contract.contract().tradingClass(this.readStr());
        contract.contract().conid(this.readInt());
        contract.minTick(this.readDouble());
        if (this.m_serverVersion >= 110 && this.m_serverVersion < 164) {
            this.readInt();
        }
        contract.orderTypes(this.readStr());
        contract.validExchanges(this.readStr());
        if (version >= 2) {
            contract.nextOptionDate(this.readStr());
            contract.nextOptionType(this.readStr());
            contract.nextOptionPartial(this.readBoolFromInt());
            contract.notes(this.readStr());
        }
        if (version >= 4) {
            contract.longName(this.readStr());
        }
        if (version >= 6) {
            contract.evRule(this.readStr());
            contract.evMultiplier(this.readDouble());
        }
        if (version >= 5 && (secIdListCount = this.readInt()) > 0) {
            contract.secIdList(new ArrayList(secIdListCount));
            for (int i = 0; i < secIdListCount; ++i) {
                TagValue tagValue = new TagValue();
                tagValue.m_tag = this.readStr();
                tagValue.m_value = this.readStr();
                contract.secIdList().add(tagValue);
            }
        }
        if (this.m_serverVersion >= 121) {
            contract.aggGroup(this.readInt());
        }
        if (this.m_serverVersion >= 126) {
            contract.marketRuleIds(this.readStr());
        }
        if (this.m_serverVersion >= 164) {
            contract.minSize(this.readDecimal());
            contract.sizeIncrement(this.readDecimal());
            contract.suggestedSizeIncrement(this.readDecimal());
        }
        this.m_EWrapper.bondContractDetails(reqId, contract);
    }

    private void processContractDataMsg() throws IOException {
        int secIdListCount;
        int version = 8;
        if (this.m_serverVersion < 164) {
            version = this.readInt();
        }
        int reqId = -1;
        if (version >= 3) {
            reqId = this.readInt();
        }
        ContractDetails contract = new ContractDetails();
        contract.contract().symbol(this.readStr());
        contract.contract().secType(this.readStr());
        this.readLastTradeDate(contract, false);
        contract.contract().strike(this.readDouble());
        contract.contract().right(this.readStr());
        contract.contract().exchange(this.readStr());
        contract.contract().currency(this.readStr());
        contract.contract().localSymbol(this.readStr());
        contract.marketName(this.readStr());
        contract.contract().tradingClass(this.readStr());
        contract.contract().conid(this.readInt());
        contract.minTick(this.readDouble());
        if (this.m_serverVersion >= 110 && this.m_serverVersion < 164) {
            this.readInt();
        }
        contract.contract().multiplier(this.readStr());
        contract.orderTypes(this.readStr());
        contract.validExchanges(this.readStr());
        if (version >= 2) {
            contract.priceMagnifier(this.readInt());
        }
        if (version >= 4) {
            contract.underConid(this.readInt());
        }
        if (version >= 5) {
            contract.longName(this.m_serverVersion >= 153 ? EDecoder.decodeUnicodeEscapedString((String)this.readStr()) : this.readStr());
            contract.contract().primaryExch(this.readStr());
        }
        if (version >= 6) {
            contract.contractMonth(this.readStr());
            contract.industry(this.readStr());
            contract.category(this.readStr());
            contract.subcategory(this.readStr());
            contract.timeZoneId(this.readStr());
            contract.tradingHours(this.readStr());
            contract.liquidHours(this.readStr());
        }
        if (version >= 8) {
            contract.evRule(this.readStr());
            contract.evMultiplier(this.readDouble());
        }
        if (version >= 7 && (secIdListCount = this.readInt()) > 0) {
            contract.secIdList(new ArrayList(secIdListCount));
            for (int i = 0; i < secIdListCount; ++i) {
                TagValue tagValue = new TagValue();
                tagValue.m_tag = this.readStr();
                tagValue.m_value = this.readStr();
                contract.secIdList().add(tagValue);
            }
        }
        if (this.m_serverVersion >= 121) {
            contract.aggGroup(this.readInt());
        }
        if (this.m_serverVersion >= 122) {
            contract.underSymbol(this.readStr());
            contract.underSecType(this.readStr());
        }
        if (this.m_serverVersion >= 126) {
            contract.marketRuleIds(this.readStr());
        }
        if (this.m_serverVersion >= 134) {
            contract.realExpirationDate(this.readStr());
        }
        if (this.m_serverVersion >= 152) {
            contract.stockType(this.readStr());
        }
        if (this.m_serverVersion >= 163 && this.m_serverVersion < 164) {
            this.readDecimal();
        }
        if (this.m_serverVersion >= 164) {
            contract.minSize(this.readDecimal());
            contract.sizeIncrement(this.readDecimal());
            contract.suggestedSizeIncrement(this.readDecimal());
        }
        this.m_EWrapper.contractDetails(reqId, contract);
    }

    private void processScannerDataMsg() throws IOException {
        int version = this.readInt();
        int tickerId = this.readInt();
        int numberOfElements = this.readInt();
        for (int ctr = 0; ctr < numberOfElements; ++ctr) {
            int rank = this.readInt();
            ContractDetails contract = new ContractDetails();
            if (version >= 3) {
                contract.contract().conid(this.readInt());
            }
            contract.contract().symbol(this.readStr());
            contract.contract().secType(this.readStr());
            contract.contract().lastTradeDateOrContractMonth(this.readStr());
            contract.contract().strike(this.readDouble());
            contract.contract().right(this.readStr());
            contract.contract().exchange(this.readStr());
            contract.contract().currency(this.readStr());
            contract.contract().localSymbol(this.readStr());
            contract.marketName(this.readStr());
            contract.contract().tradingClass(this.readStr());
            String distance = this.readStr();
            String benchmark = this.readStr();
            String projection = this.readStr();
            String legsStr = null;
            if (version >= 2) {
                legsStr = this.readStr();
            }
            this.m_EWrapper.scannerData(tickerId, rank, contract, distance, benchmark, projection, legsStr);
        }
        this.m_EWrapper.scannerDataEnd(tickerId);
    }

    private void processNextValidIdMsg() throws IOException {
        this.readInt();
        int orderId = this.readInt();
        this.m_EWrapper.nextValidId(orderId);
    }

    private void processOpenOrderMsg() throws IOException {
        int version = this.m_serverVersion < 145 ? this.readInt() : this.m_serverVersion;
        Contract contract = new Contract();
        Order order = new Order();
        OrderState orderState = new OrderState();
        EOrderDecoder eOrderDecoder = new EOrderDecoder(this, contract, order, orderState, version, this.m_serverVersion);
        eOrderDecoder.readOrderId();
        eOrderDecoder.readContractFields();
        eOrderDecoder.readAction();
        eOrderDecoder.readTotalQuantity();
        eOrderDecoder.readOrderType();
        eOrderDecoder.readLmtPrice();
        eOrderDecoder.readAuxPrice();
        eOrderDecoder.readTIF();
        eOrderDecoder.readOcaGroup();
        eOrderDecoder.readAccount();
        eOrderDecoder.readOpenClose();
        eOrderDecoder.readOrigin();
        eOrderDecoder.readOrderRef();
        eOrderDecoder.readClientId();
        eOrderDecoder.readPermId();
        eOrderDecoder.readOutsideRth();
        eOrderDecoder.readHidden();
        eOrderDecoder.readDiscretionaryAmount();
        eOrderDecoder.readGoodAfterTime();
        eOrderDecoder.skipSharesAllocation();
        eOrderDecoder.readFAParams();
        eOrderDecoder.readModelCode();
        eOrderDecoder.readGoodTillDate();
        eOrderDecoder.readRule80A();
        eOrderDecoder.readPercentOffset();
        eOrderDecoder.readSettlingFirm();
        eOrderDecoder.readShortSaleParams();
        eOrderDecoder.readAuctionStrategy();
        eOrderDecoder.readBoxOrderParams();
        eOrderDecoder.readPegToStkOrVolOrderParams();
        eOrderDecoder.readDisplaySize();
        eOrderDecoder.readOldStyleOutsideRth();
        eOrderDecoder.readBlockOrder();
        eOrderDecoder.readSweepToFill();
        eOrderDecoder.readAllOrNone();
        eOrderDecoder.readMinQty();
        eOrderDecoder.readOcaType();
        eOrderDecoder.readETradeOnly();
        eOrderDecoder.readFirmQuoteOnly();
        eOrderDecoder.readNbboPriceCap();
        eOrderDecoder.readParentId();
        eOrderDecoder.readTriggerMethod();
        eOrderDecoder.readVolOrderParams(true);
        eOrderDecoder.readTrailParams();
        eOrderDecoder.readBasisPoints();
        eOrderDecoder.readComboLegs();
        eOrderDecoder.readSmartComboRoutingParams();
        eOrderDecoder.readScaleOrderParams();
        eOrderDecoder.readHedgeParams();
        eOrderDecoder.readOptOutSmartRouting();
        eOrderDecoder.readClearingParams();
        eOrderDecoder.readNotHeld();
        eOrderDecoder.readDeltaNeutral();
        eOrderDecoder.readAlgoParams();
        eOrderDecoder.readSolicited();
        eOrderDecoder.readWhatIfInfoAndCommission();
        eOrderDecoder.readVolRandomizeFlags();
        eOrderDecoder.readPegToBenchParams();
        eOrderDecoder.readConditions();
        eOrderDecoder.readAdjustedOrderParams();
        eOrderDecoder.readSoftDollarTier();
        eOrderDecoder.readCashQty();
        eOrderDecoder.readDontUseAutoPriceForHedge();
        eOrderDecoder.readIsOmsContainer();
        eOrderDecoder.readDiscretionaryUpToLimitPrice();
        eOrderDecoder.readUsePriceMgmtAlgo();
        eOrderDecoder.readDuration();
        eOrderDecoder.readPostToAts();
        eOrderDecoder.readAutoCancelParent(162);
        eOrderDecoder.readPegBestPegMidOrderAttributes();
        this.m_EWrapper.openOrder(order.orderId(), contract, order, orderState);
    }

    private void processErrMsgMsg() throws IOException {
        int version = this.readInt();
        if (version < 2) {
            String msg = this.readStr();
            this.m_EWrapper.error(msg);
        } else {
            int id = this.readInt();
            int errorCode = this.readInt();
            String errorMsg = this.m_serverVersion >= 153 ? EDecoder.decodeUnicodeEscapedString((String)this.readStr()) : this.readStr();
            String advancedOrderRejectJson = null;
            if (this.m_serverVersion >= 166) {
                advancedOrderRejectJson = EDecoder.decodeUnicodeEscapedString((String)this.readStr());
            }
            this.m_EWrapper.error(id, errorCode, errorMsg, advancedOrderRejectJson);
        }
    }

    private void processAcctUpdateTimeMsg() throws IOException {
        this.readInt();
        String timeStamp = this.readStr();
        this.m_EWrapper.updateAccountTime(timeStamp);
    }

    private void processPortfolioValueMsg() throws IOException {
        int version = this.readInt();
        Contract contract = new Contract();
        if (version >= 6) {
            contract.conid(this.readInt());
        }
        contract.symbol(this.readStr());
        contract.secType(this.readStr());
        contract.lastTradeDateOrContractMonth(this.readStr());
        contract.strike(this.readDouble());
        contract.right(this.readStr());
        if (version >= 7) {
            contract.multiplier(this.readStr());
            contract.primaryExch(this.readStr());
        }
        contract.currency(this.readStr());
        if (version >= 2) {
            contract.localSymbol(this.readStr());
        }
        if (version >= 8) {
            contract.tradingClass(this.readStr());
        }
        Decimal position = this.readDecimal();
        double marketPrice = this.readDouble();
        double marketValue = this.readDouble();
        double averageCost = 0.0;
        double unrealizedPNL = 0.0;
        double realizedPNL = 0.0;
        if (version >= 3) {
            averageCost = this.readDouble();
            unrealizedPNL = this.readDouble();
            realizedPNL = this.readDouble();
        }
        String accountName = null;
        if (version >= 4) {
            accountName = this.readStr();
        }
        if (version == 6 && this.m_serverVersion == 39) {
            contract.primaryExch(this.readStr());
        }
        this.m_EWrapper.updatePortfolio(contract, position, marketPrice, marketValue, averageCost, unrealizedPNL, realizedPNL, accountName);
    }

    private void processAcctValueMsg() throws IOException {
        int version = this.readInt();
        String key = this.readStr();
        String val = this.readStr();
        String cur = this.readStr();
        String accountName = null;
        if (version >= 2) {
            accountName = this.readStr();
        }
        this.m_EWrapper.updateAccountValue(key, val, cur, accountName);
    }

    private void processOrderStatusMsg() throws IOException {
        int version = this.m_serverVersion >= 131 ? Integer.MAX_VALUE : this.readInt();
        int id = this.readInt();
        String status = this.readStr();
        Decimal filled = this.readDecimal();
        Decimal remaining = this.readDecimal();
        double avgFillPrice = this.readDouble();
        int permId = 0;
        if (version >= 2) {
            permId = this.readInt();
        }
        int parentId = 0;
        if (version >= 3) {
            parentId = this.readInt();
        }
        double lastFillPrice = 0.0;
        if (version >= 4) {
            lastFillPrice = this.readDouble();
        }
        int clientId = 0;
        if (version >= 5) {
            clientId = this.readInt();
        }
        String whyHeld = null;
        if (version >= 6) {
            whyHeld = this.readStr();
        }
        double mktCapPrice = Double.MAX_VALUE;
        if (this.m_serverVersion >= 131) {
            mktCapPrice = this.readDouble();
        }
        this.m_EWrapper.orderStatus(id, status, filled, remaining, avgFillPrice, permId, parentId, lastFillPrice, clientId, whyHeld, mktCapPrice);
    }

    private void processTickEFPMsg() throws IOException {
        this.readInt();
        int tickerId = this.readInt();
        int tickType = this.readInt();
        double basisPoints = this.readDouble();
        String formattedBasisPoints = this.readStr();
        double impliedFuturesPrice = this.readDouble();
        int holdDays = this.readInt();
        String futureLastTradeDate = this.readStr();
        double dividendImpact = this.readDouble();
        double dividendsToLastTradeDate = this.readDouble();
        this.m_EWrapper.tickEFP(tickerId, tickType, basisPoints, formattedBasisPoints, impliedFuturesPrice, holdDays, futureLastTradeDate, dividendImpact, dividendsToLastTradeDate);
    }

    private void processTickStringMsg() throws IOException {
        this.readInt();
        int tickerId = this.readInt();
        int tickType = this.readInt();
        String value = this.readStr();
        this.m_EWrapper.tickString(tickerId, tickType, value);
    }

    private void processTickGenericMsg() throws IOException {
        this.readInt();
        int tickerId = this.readInt();
        int tickType = this.readInt();
        double value = this.readDouble();
        this.m_EWrapper.tickGeneric(tickerId, tickType, value);
    }

    private void processTickOptionComputationMsg() throws IOException {
        double delta;
        double impliedVol;
        int version = this.m_serverVersion >= 156 ? Integer.MAX_VALUE : this.readInt();
        int tickerId = this.readInt();
        int tickType = this.readInt();
        int tickAttrib = Integer.MAX_VALUE;
        if (this.m_serverVersion >= 156) {
            tickAttrib = this.readInt();
        }
        if (Double.compare(impliedVol = this.readDouble(), -1.0) == 0) {
            impliedVol = Double.MAX_VALUE;
        }
        if (Double.compare(delta = this.readDouble(), -2.0) == 0) {
            delta = Double.MAX_VALUE;
        }
        double optPrice = Double.MAX_VALUE;
        double pvDividend = Double.MAX_VALUE;
        double gamma = Double.MAX_VALUE;
        double vega = Double.MAX_VALUE;
        double theta = Double.MAX_VALUE;
        double undPrice = Double.MAX_VALUE;
        if (version >= 6 || tickType == TickType.MODEL_OPTION.index() || tickType == TickType.DELAYED_MODEL_OPTION.index()) {
            optPrice = this.readDouble();
            if (Double.compare(optPrice, -1.0) == 0) {
                optPrice = Double.MAX_VALUE;
            }
            if (Double.compare(pvDividend = this.readDouble(), -1.0) == 0) {
                pvDividend = Double.MAX_VALUE;
            }
        }
        if (version >= 6) {
            gamma = this.readDouble();
            if (Double.compare(gamma, -2.0) == 0) {
                gamma = Double.MAX_VALUE;
            }
            if (Double.compare(vega = this.readDouble(), -2.0) == 0) {
                vega = Double.MAX_VALUE;
            }
            if (Double.compare(theta = this.readDouble(), -2.0) == 0) {
                theta = Double.MAX_VALUE;
            }
            if (Double.compare(undPrice = this.readDouble(), -1.0) == 0) {
                undPrice = Double.MAX_VALUE;
            }
        }
        this.m_EWrapper.tickOptionComputation(tickerId, tickType, tickAttrib, impliedVol, delta, optPrice, pvDividend, gamma, vega, theta, undPrice);
    }

    private void processAccountSummaryEndMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        this.m_EWrapper.accountSummaryEnd(reqId);
    }

    private void processAccountSummaryMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        String account = this.readStr();
        String tag = this.readStr();
        String value = this.readStr();
        String currency = this.readStr();
        this.m_EWrapper.accountSummary(reqId, account, tag, value, currency);
    }

    private void processPositionEndMsg() throws IOException {
        this.readInt();
        this.m_EWrapper.positionEnd();
    }

    private void processPositionMsg() throws IOException {
        int version = this.readInt();
        String account = this.readStr();
        Contract contract = new Contract();
        contract.conid(this.readInt());
        contract.symbol(this.readStr());
        contract.secType(this.readStr());
        contract.lastTradeDateOrContractMonth(this.readStr());
        contract.strike(this.readDouble());
        contract.right(this.readStr());
        contract.multiplier(this.readStr());
        contract.exchange(this.readStr());
        contract.currency(this.readStr());
        contract.localSymbol(this.readStr());
        if (version >= 2) {
            contract.tradingClass(this.readStr());
        }
        Decimal pos = this.readDecimal();
        double avgCost = 0.0;
        if (version >= 3) {
            avgCost = this.readDouble();
        }
        this.m_EWrapper.position(account, contract, pos, avgCost);
    }

    private void processTickSizeMsg() throws IOException {
        this.readInt();
        int tickerId = this.readInt();
        int tickType = this.readInt();
        Decimal size = this.readDecimal();
        this.m_EWrapper.tickSize(tickerId, tickType, size);
    }

    private void processTickPriceMsg() throws IOException {
        int version = this.readInt();
        int tickerId = this.readInt();
        int tickType = this.readInt();
        double price = this.readDouble();
        Decimal size = Decimal.INVALID;
        TickAttrib attribs = new TickAttrib();
        if (version >= 2) {
            size = this.readDecimal();
        }
        if (version >= 3) {
            int attrMask = this.readInt();
            attribs.canAutoExecute(attrMask == 1);
            if (this.m_serverVersion >= 109) {
                BitMask mask = new BitMask(attrMask);
                attribs.canAutoExecute(mask.get(0));
                attribs.pastLimit(mask.get(1));
                if (this.m_serverVersion >= 132) {
                    attribs.preOpen(mask.get(2));
                }
            }
        }
        this.m_EWrapper.tickPrice(tickerId, tickType, price, attribs);
        if (version >= 2) {
            int sizeTickType = switch (tickType) {
                case 1 -> 0;
                case 2 -> 3;
                case 4 -> 5;
                case 66 -> 69;
                case 67 -> 70;
                case 68 -> 71;
                default -> -1;
            };
            if (sizeTickType != -1) {
                this.m_EWrapper.tickSize(tickerId, sizeTickType, size);
            }
        }
    }

    private void processPositionMultiMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        String account = this.readStr();
        Contract contract = new Contract();
        contract.conid(this.readInt());
        contract.symbol(this.readStr());
        contract.secType(this.readStr());
        contract.lastTradeDateOrContractMonth(this.readStr());
        contract.strike(this.readDouble());
        contract.right(this.readStr());
        contract.multiplier(this.readStr());
        contract.exchange(this.readStr());
        contract.currency(this.readStr());
        contract.localSymbol(this.readStr());
        contract.tradingClass(this.readStr());
        Decimal pos = this.readDecimal();
        double avgCost = this.readDouble();
        String modelCode = this.readStr();
        this.m_EWrapper.positionMulti(reqId, account, modelCode, contract, pos, avgCost);
    }

    private void processPositionMultiEndMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        this.m_EWrapper.positionMultiEnd(reqId);
    }

    private void processAccountUpdateMultiMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        String account = this.readStr();
        String modelCode = this.readStr();
        String key = this.readStr();
        String value = this.readStr();
        String currency = this.readStr();
        this.m_EWrapper.accountUpdateMulti(reqId, account, modelCode, key, value, currency);
    }

    private void processAccountUpdateMultiEndMsg() throws IOException {
        this.readInt();
        int reqId = this.readInt();
        this.m_EWrapper.accountUpdateMultiEnd(reqId);
    }

    private void processSmartComponentsMsg() throws IOException {
        int reqId = this.readInt();
        int n = this.readInt();
        HashMap<Integer, AbstractMap.SimpleEntry<String, Character>> theMap = new HashMap<Integer, AbstractMap.SimpleEntry<String, Character>>();
        for (int i = 0; i < n; ++i) {
            int bitNumber = this.readInt();
            String exchange = this.readStr();
            char exchangeLetter = this.readChar();
            theMap.put(bitNumber, new AbstractMap.SimpleEntry<String, Character>(exchange, Character.valueOf(exchangeLetter)));
        }
        this.m_EWrapper.smartComponents(reqId, theMap);
    }

    private void processTickReqParamsMsg() throws IOException {
        int tickerId = this.readInt();
        double minTick = this.readDouble();
        String bboExchange = this.readStr();
        int snapshotPermissions = this.readInt();
        this.m_EWrapper.tickReqParams(tickerId, minTick, bboExchange, snapshotPermissions);
    }

    private void processTickByTickMsg() throws IOException {
        int reqId = this.readInt();
        int tickType = this.readInt();
        long time = this.readLong();
        switch (tickType) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                double price = this.readDouble();
                Decimal size = this.readDecimal();
                BitMask mask = new BitMask(this.readInt());
                TickAttribLast tickAttribLast = new TickAttribLast();
                tickAttribLast.pastLimit(mask.get(0));
                tickAttribLast.unreported(mask.get(1));
                String exchange = this.readStr();
                String specialConditions = this.readStr();
                this.m_EWrapper.tickByTickAllLast(reqId, tickType, time, price, size, tickAttribLast, exchange, specialConditions);
                break;
            }
            case 3: {
                double bidPrice = this.readDouble();
                double askPrice = this.readDouble();
                Decimal bidSize = this.readDecimal();
                Decimal askSize = this.readDecimal();
                BitMask mask = new BitMask(this.readInt());
                TickAttribBidAsk tickAttribBidAsk = new TickAttribBidAsk();
                tickAttribBidAsk.bidPastLow(mask.get(0));
                tickAttribBidAsk.askPastHigh(mask.get(1));
                this.m_EWrapper.tickByTickBidAsk(reqId, time, bidPrice, askPrice, bidSize, askSize, tickAttribBidAsk);
                break;
            }
            case 4: {
                double midPoint = this.readDouble();
                this.m_EWrapper.tickByTickMidPoint(reqId, time, midPoint);
            }
        }
    }

    private void processOrderBoundMsg() throws IOException {
        long orderId = this.readLong();
        int apiClientId = this.readInt();
        int apiOrderId = this.readInt();
        this.m_EWrapper.orderBound(orderId, apiClientId, apiOrderId);
    }

    private void processCompletedOrderMsg() throws IOException {
        Contract contract = new Contract();
        Order order = new Order();
        OrderState orderState = new OrderState();
        EOrderDecoder eOrderDecoder = new EOrderDecoder(this, contract, order, orderState, Integer.MAX_VALUE, this.m_serverVersion);
        eOrderDecoder.readContractFields();
        eOrderDecoder.readAction();
        eOrderDecoder.readTotalQuantity();
        eOrderDecoder.readOrderType();
        eOrderDecoder.readLmtPrice();
        eOrderDecoder.readAuxPrice();
        eOrderDecoder.readTIF();
        eOrderDecoder.readOcaGroup();
        eOrderDecoder.readAccount();
        eOrderDecoder.readOpenClose();
        eOrderDecoder.readOrigin();
        eOrderDecoder.readOrderRef();
        eOrderDecoder.readPermId();
        eOrderDecoder.readOutsideRth();
        eOrderDecoder.readHidden();
        eOrderDecoder.readDiscretionaryAmount();
        eOrderDecoder.readGoodAfterTime();
        eOrderDecoder.readFAParams();
        eOrderDecoder.readModelCode();
        eOrderDecoder.readGoodTillDate();
        eOrderDecoder.readRule80A();
        eOrderDecoder.readPercentOffset();
        eOrderDecoder.readSettlingFirm();
        eOrderDecoder.readShortSaleParams();
        eOrderDecoder.readBoxOrderParams();
        eOrderDecoder.readPegToStkOrVolOrderParams();
        eOrderDecoder.readDisplaySize();
        eOrderDecoder.readSweepToFill();
        eOrderDecoder.readAllOrNone();
        eOrderDecoder.readMinQty();
        eOrderDecoder.readOcaType();
        eOrderDecoder.readTriggerMethod();
        eOrderDecoder.readVolOrderParams(false);
        eOrderDecoder.readTrailParams();
        eOrderDecoder.readComboLegs();
        eOrderDecoder.readSmartComboRoutingParams();
        eOrderDecoder.readScaleOrderParams();
        eOrderDecoder.readHedgeParams();
        eOrderDecoder.readClearingParams();
        eOrderDecoder.readNotHeld();
        eOrderDecoder.readDeltaNeutral();
        eOrderDecoder.readAlgoParams();
        eOrderDecoder.readSolicited();
        eOrderDecoder.readOrderStatus();
        eOrderDecoder.readVolRandomizeFlags();
        eOrderDecoder.readPegToBenchParams();
        eOrderDecoder.readConditions();
        eOrderDecoder.readStopPriceAndLmtPriceOffset();
        eOrderDecoder.readCashQty();
        eOrderDecoder.readDontUseAutoPriceForHedge();
        eOrderDecoder.readIsOmsContainer();
        eOrderDecoder.readAutoCancelDate();
        eOrderDecoder.readFilledQuantity();
        eOrderDecoder.readRefFuturesConId();
        eOrderDecoder.readAutoCancelParent();
        eOrderDecoder.readShareholder();
        eOrderDecoder.readImbalanceOnly();
        eOrderDecoder.readRouteMarketableToBbo();
        eOrderDecoder.readParentPermId();
        eOrderDecoder.readCompletedTime();
        eOrderDecoder.readCompletedStatus();
        eOrderDecoder.readPegBestPegMidOrderAttributes();
        this.m_EWrapper.completedOrder(contract, order, orderState);
    }

    private void processCompletedOrdersEndMsg() throws IOException {
        this.m_EWrapper.completedOrdersEnd();
    }

    private void processReplaceFAEndMsg() throws IOException {
        int reqId = this.readInt();
        String text = this.readStr();
        this.m_EWrapper.replaceFAEnd(reqId, text);
    }

    private void processWshMetaData() throws IOException {
        int reqId = this.readInt();
        String dataJson = this.readStr();
        this.m_EWrapper.wshMetaData(reqId, dataJson);
    }

    private void processWshEventData() throws IOException {
        int reqId = this.readInt();
        String dataJson = this.readStr();
        this.m_EWrapper.wshEventData(reqId, dataJson);
    }

    private void processHistoricalSchedule() throws IOException {
        int reqId = this.readInt();
        String startDateTime = this.readStr();
        String endDateTime = this.readStr();
        String timeZone = this.readStr();
        int sessionsCount = this.readInt();
        ArrayList<HistoricalSession> sessions = new ArrayList<HistoricalSession>();
        for (int i = 0; i < sessionsCount; ++i) {
            String sessionStartDateTime = this.readStr();
            String sessionEndDateTime = this.readStr();
            String sessionRefDate = this.readStr();
            sessions.add(new HistoricalSession(sessionStartDateTime, sessionEndDateTime, sessionRefDate));
        }
        this.m_EWrapper.historicalSchedule(reqId, startDateTime, endDateTime, timeZone, sessions);
    }

    private void processUserInfo() throws IOException {
        int reqId = this.readInt();
        String whiteBrandingId = this.readStr();
        this.m_EWrapper.userInfo(reqId, whiteBrandingId);
    }

    private void readLastTradeDate(ContractDetails contract, boolean isBond) throws IOException {
        String lastTradeDateOrContractMonth = this.readStr();
        if (lastTradeDateOrContractMonth != null) {
            String[] splitted;
            String[] stringArray = splitted = lastTradeDateOrContractMonth.contains("-") ? lastTradeDateOrContractMonth.split("-") : lastTradeDateOrContractMonth.split("\\s+");
            if (splitted.length > 0) {
                if (isBond) {
                    contract.maturity(splitted[0]);
                } else {
                    contract.contract().lastTradeDateOrContractMonth(splitted[0]);
                }
            }
            if (splitted.length > 1) {
                contract.lastTradeTime(splitted[1]);
            }
            if (isBond && splitted.length > 2) {
                contract.timeZoneId(splitted[2]);
            }
        }
    }

    public String readStr() throws IOException {
        return this.m_messageReader.readStr();
    }

    public boolean readBoolFromInt() throws IOException {
        String str = this.readStr();
        return str != null && Integer.parseInt(str) != 0;
    }

    @Override
    public int readInt() throws IOException {
        String str = this.readStr();
        return str == null ? 0 : Integer.parseInt(str);
    }

    public int readIntMax() throws IOException {
        String str = this.readStr();
        return str == null || str.length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(str);
    }

    @Override
    public long readLong() throws IOException {
        String str = this.readStr();
        return str == null ? 0L : Long.parseLong(str);
    }

    @Override
    public double readDouble() throws IOException {
        String str = this.readStr();
        return str == null ? 0.0 : Double.parseDouble(str);
    }

    public double readDoubleMax() throws IOException {
        String str = this.readStr();
        return str == null || str.length() == 0 ? Double.MAX_VALUE : Double.parseDouble(str);
    }

    public Decimal readDecimal() throws IOException {
        String str = this.readStr();
        return str == null || str.isEmpty() || str.equals(String.valueOf(Long.MAX_VALUE)) || str.equals(String.valueOf(Integer.MAX_VALUE)) || str.equals(String.valueOf(Double.MAX_VALUE)) ? Decimal.INVALID : Decimal.parse((String)str);
    }

    static String decodeUnicodeEscapedString(String str) {
        if (str == null) {
            return str;
        }
        String v = new String(str);
        try {
            int escapeIndex;
            while ((escapeIndex = v.indexOf("\\u")) != -1 && v.length() - escapeIndex >= 6) {
                String escapeString = v.substring(escapeIndex, escapeIndex + 6);
                int hexVal = Integer.parseInt(escapeString.replace("\\u", ""), 16);
                v = v.replace(escapeString, "" + (char)hexVal);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return v;
    }

    @Override
    public int skipBytes(int arg0) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        return this.readStr();
    }

    @Override
    public short readShort() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readLine() throws IOException {
        return this.readStr();
    }

    @Override
    public void readFully(byte[] arg0, int arg1, int arg2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readFully(byte[] arg0) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public float readFloat() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public char readChar() throws IOException {
        return this.readStr().charAt(0);
    }

    @Override
    public byte readByte() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readBoolFromInt();
    }

    @Override
    public long skip(long arg0) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(byte[] arg0) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.m_messageReader.close();
    }

    @Override
    public int available() throws IOException {
        throw new UnsupportedOperationException();
    }
}

