/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.Builder;
import com.ib.client.ComboLeg;
import com.ib.client.Contract;
import com.ib.client.DeltaNeutralContract;
import com.ib.client.EClientErrors;
import com.ib.client.EClientException;
import com.ib.client.EMessage;
import com.ib.client.EReaderSignal;
import com.ib.client.ETransport;
import com.ib.client.EWrapper;
import com.ib.client.ExecutionFilter;
import com.ib.client.IApiEnum;
import com.ib.client.Order;
import com.ib.client.OrderComboLeg;
import com.ib.client.OrderCondition;
import com.ib.client.OrderType;
import com.ib.client.ScannerSubscription;
import com.ib.client.SoftDollarTier;
import com.ib.client.TagValue;
import com.ib.client.Types;
import com.ib.client.Util;
import com.ib.client.WshEventData;
import java.io.IOException;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class EClient {
    protected static final int REDIRECT_COUNT_MAX = 2;
    protected static final int CLIENT_VERSION = 66;
    protected static final int MIN_SERVER_VER_SUPPORTED = 38;
    public static final int GROUPS = 1;
    public static final int PROFILES = 2;
    public static final int ALIASES = 3;
    private static final int REQ_MKT_DATA = 1;
    private static final int CANCEL_MKT_DATA = 2;
    protected static final int PLACE_ORDER = 3;
    private static final int CANCEL_ORDER = 4;
    private static final int REQ_OPEN_ORDERS = 5;
    private static final int REQ_ACCOUNT_DATA = 6;
    private static final int REQ_EXECUTIONS = 7;
    private static final int REQ_IDS = 8;
    private static final int REQ_CONTRACT_DATA = 9;
    private static final int REQ_MKT_DEPTH = 10;
    private static final int CANCEL_MKT_DEPTH = 11;
    private static final int REQ_NEWS_BULLETINS = 12;
    private static final int CANCEL_NEWS_BULLETINS = 13;
    private static final int SET_SERVER_LOGLEVEL = 14;
    private static final int REQ_AUTO_OPEN_ORDERS = 15;
    private static final int REQ_ALL_OPEN_ORDERS = 16;
    private static final int REQ_MANAGED_ACCTS = 17;
    private static final int REQ_FA = 18;
    private static final int REPLACE_FA = 19;
    private static final int REQ_HISTORICAL_DATA = 20;
    private static final int EXERCISE_OPTIONS = 21;
    private static final int REQ_SCANNER_SUBSCRIPTION = 22;
    private static final int CANCEL_SCANNER_SUBSCRIPTION = 23;
    private static final int REQ_SCANNER_PARAMETERS = 24;
    private static final int CANCEL_HISTORICAL_DATA = 25;
    private static final int REQ_CURRENT_TIME = 49;
    private static final int REQ_REAL_TIME_BARS = 50;
    private static final int CANCEL_REAL_TIME_BARS = 51;
    private static final int REQ_FUNDAMENTAL_DATA = 52;
    private static final int CANCEL_FUNDAMENTAL_DATA = 53;
    private static final int REQ_CALC_IMPLIED_VOLAT = 54;
    private static final int REQ_CALC_OPTION_PRICE = 55;
    private static final int CANCEL_CALC_IMPLIED_VOLAT = 56;
    private static final int CANCEL_CALC_OPTION_PRICE = 57;
    private static final int REQ_GLOBAL_CANCEL = 58;
    private static final int REQ_MARKET_DATA_TYPE = 59;
    private static final int REQ_POSITIONS = 61;
    private static final int REQ_ACCOUNT_SUMMARY = 62;
    private static final int CANCEL_ACCOUNT_SUMMARY = 63;
    private static final int CANCEL_POSITIONS = 64;
    private static final int VERIFY_REQUEST = 65;
    private static final int VERIFY_MESSAGE = 66;
    private static final int QUERY_DISPLAY_GROUPS = 67;
    private static final int SUBSCRIBE_TO_GROUP_EVENTS = 68;
    private static final int UPDATE_DISPLAY_GROUP = 69;
    private static final int UNSUBSCRIBE_FROM_GROUP_EVENTS = 70;
    private static final int START_API = 71;
    private static final int VERIFY_AND_AUTH_REQUEST = 72;
    private static final int VERIFY_AND_AUTH_MESSAGE = 73;
    private static final int REQ_POSITIONS_MULTI = 74;
    private static final int CANCEL_POSITIONS_MULTI = 75;
    private static final int REQ_ACCOUNT_UPDATES_MULTI = 76;
    private static final int CANCEL_ACCOUNT_UPDATES_MULTI = 77;
    private static final int REQ_SEC_DEF_OPT_PARAMS = 78;
    private static final int REQ_SOFT_DOLLAR_TIERS = 79;
    private static final int REQ_FAMILY_CODES = 80;
    private static final int REQ_MATCHING_SYMBOLS = 81;
    private static final int REQ_MKT_DEPTH_EXCHANGES = 82;
    private static final int REQ_SMART_COMPONENTS = 83;
    private static final int REQ_NEWS_ARTICLE = 84;
    private static final int REQ_NEWS_PROVIDERS = 85;
    private static final int REQ_HISTORICAL_NEWS = 86;
    private static final int REQ_HEAD_TIMESTAMP = 87;
    private static final int REQ_HISTOGRAM_DATA = 88;
    private static final int CANCEL_HISTOGRAM_DATA = 89;
    private static final int CANCEL_HEAD_TIMESTAMP = 90;
    private static final int REQ_MARKET_RULE = 91;
    private static final int REQ_PNL = 92;
    private static final int CANCEL_PNL = 93;
    private static final int REQ_PNL_SINGLE = 94;
    private static final int CANCEL_PNL_SINGLE = 95;
    private static final int REQ_HISTORICAL_TICKS = 96;
    private static final int REQ_TICK_BY_TICK_DATA = 97;
    private static final int CANCEL_TICK_BY_TICK_DATA = 98;
    private static final int REQ_COMPLETED_ORDERS = 99;
    private static final int REQ_WSH_META_DATA = 100;
    private static final int CANCEL_WSH_META_DATA = 101;
    private static final int REQ_WSH_EVENT_DATA = 102;
    private static final int CANCEL_WSH_EVENT_DATA = 103;
    private static final int REQ_USER_INFO = 104;
    private static final int MIN_SERVER_VER_REAL_TIME_BARS = 34;
    private static final int MIN_SERVER_VER_SCALE_ORDERS = 35;
    private static final int MIN_SERVER_VER_SNAPSHOT_MKT_DATA = 35;
    private static final int MIN_SERVER_VER_SSHORT_COMBO_LEGS = 35;
    private static final int MIN_SERVER_VER_WHAT_IF_ORDERS = 36;
    private static final int MIN_SERVER_VER_CONTRACT_CONID = 37;
    private static final int MIN_SERVER_VER_PTA_ORDERS = 39;
    private static final int MIN_SERVER_VER_FUNDAMENTAL_DATA = 40;
    private static final int MIN_SERVER_VER_DELTA_NEUTRAL = 40;
    private static final int MIN_SERVER_VER_CONTRACT_DATA_CHAIN = 40;
    private static final int MIN_SERVER_VER_SCALE_ORDERS2 = 40;
    private static final int MIN_SERVER_VER_ALGO_ORDERS = 41;
    private static final int MIN_SERVER_VER_EXECUTION_DATA_CHAIN = 42;
    private static final int MIN_SERVER_VER_NOT_HELD = 44;
    private static final int MIN_SERVER_VER_SEC_ID_TYPE = 45;
    private static final int MIN_SERVER_VER_PLACE_ORDER_CONID = 46;
    private static final int MIN_SERVER_VER_REQ_MKT_DATA_CONID = 47;
    private static final int MIN_SERVER_VER_REQ_CALC_IMPLIED_VOLAT = 49;
    private static final int MIN_SERVER_VER_REQ_CALC_OPTION_PRICE = 50;
    private static final int MIN_SERVER_VER_CANCEL_CALC_IMPLIED_VOLAT = 50;
    private static final int MIN_SERVER_VER_CANCEL_CALC_OPTION_PRICE = 50;
    private static final int MIN_SERVER_VER_SSHORTX_OLD = 51;
    private static final int MIN_SERVER_VER_SSHORTX = 52;
    private static final int MIN_SERVER_VER_REQ_GLOBAL_CANCEL = 53;
    private static final int MIN_SERVER_VER_HEDGE_ORDERS = 54;
    private static final int MIN_SERVER_VER_REQ_MARKET_DATA_TYPE = 55;
    private static final int MIN_SERVER_VER_OPT_OUT_SMART_ROUTING = 56;
    private static final int MIN_SERVER_VER_SMART_COMBO_ROUTING_PARAMS = 57;
    private static final int MIN_SERVER_VER_DELTA_NEUTRAL_CONID = 58;
    private static final int MIN_SERVER_VER_SCALE_ORDERS3 = 60;
    private static final int MIN_SERVER_VER_ORDER_COMBO_LEGS_PRICE = 61;
    private static final int MIN_SERVER_VER_TRAILING_PERCENT = 62;
    protected static final int MIN_SERVER_VER_DELTA_NEUTRAL_OPEN_CLOSE = 66;
    private static final int MIN_SERVER_VER_ACCT_SUMMARY = 67;
    protected static final int MIN_SERVER_VER_TRADING_CLASS = 68;
    protected static final int MIN_SERVER_VER_SCALE_TABLE = 69;
    protected static final int MIN_SERVER_VER_LINKING = 70;
    protected static final int MIN_SERVER_VER_ALGO_ID = 71;
    protected static final int MIN_SERVER_VER_OPTIONAL_CAPABILITIES = 72;
    protected static final int MIN_SERVER_VER_ORDER_SOLICITED = 73;
    protected static final int MIN_SERVER_VER_LINKING_AUTH = 74;
    protected static final int MIN_SERVER_VER_PRIMARYEXCH = 75;
    protected static final int MIN_SERVER_VER_RANDOMIZE_SIZE_AND_PRICE = 76;
    protected static final int MIN_SERVER_VER_FRACTIONAL_POSITIONS = 101;
    protected static final int MIN_SERVER_VER_PEGGED_TO_BENCHMARK = 102;
    protected static final int MIN_SERVER_VER_MODELS_SUPPORT = 103;
    protected static final int MIN_SERVER_VER_SEC_DEF_OPT_PARAMS_REQ = 104;
    protected static final int MIN_SERVER_VER_EXT_OPERATOR = 105;
    protected static final int MIN_SERVER_VER_SOFT_DOLLAR_TIER = 106;
    protected static final int MIN_SERVER_VER_REQ_FAMILY_CODES = 107;
    protected static final int MIN_SERVER_VER_REQ_MATCHING_SYMBOLS = 108;
    protected static final int MIN_SERVER_VER_PAST_LIMIT = 109;
    protected static final int MIN_SERVER_VER_MD_SIZE_MULTIPLIER = 110;
    protected static final int MIN_SERVER_VER_CASH_QTY = 111;
    protected static final int MIN_SERVER_VER_REQ_MKT_DEPTH_EXCHANGES = 112;
    protected static final int MIN_SERVER_VER_TICK_NEWS = 113;
    protected static final int MIN_SERVER_VER_REQ_SMART_COMPONENTS = 114;
    protected static final int MIN_SERVER_VER_REQ_NEWS_PROVIDERS = 115;
    protected static final int MIN_SERVER_VER_REQ_NEWS_ARTICLE = 116;
    protected static final int MIN_SERVER_VER_REQ_HISTORICAL_NEWS = 117;
    protected static final int MIN_SERVER_VER_REQ_HEAD_TIMESTAMP = 118;
    protected static final int MIN_SERVER_VER_REQ_HISTOGRAM = 119;
    protected static final int MIN_SERVER_VER_SERVICE_DATA_TYPE = 120;
    protected static final int MIN_SERVER_VER_AGG_GROUP = 121;
    protected static final int MIN_SERVER_VER_UNDERLYING_INFO = 122;
    protected static final int MIN_SERVER_VER_CANCEL_HEADTIMESTAMP = 123;
    protected static final int MIN_SERVER_VER_SYNT_REALTIME_BARS = 124;
    protected static final int MIN_SERVER_VER_CFD_REROUTE = 125;
    protected static final int MIN_SERVER_VER_MARKET_RULES = 126;
    protected static final int MIN_SERVER_VER_PNL = 127;
    protected static final int MIN_SERVER_VER_NEWS_QUERY_ORIGINS = 128;
    protected static final int MIN_SERVER_VER_UNREALIZED_PNL = 129;
    protected static final int MIN_SERVER_VER_HISTORICAL_TICKS = 130;
    protected static final int MIN_SERVER_VER_MARKET_CAP_PRICE = 131;
    protected static final int MIN_SERVER_VER_PRE_OPEN_BID_ASK = 132;
    protected static final int MIN_SERVER_VER_REAL_EXPIRATION_DATE = 134;
    protected static final int MIN_SERVER_VER_REALIZED_PNL = 135;
    protected static final int MIN_SERVER_VER_LAST_LIQUIDITY = 136;
    protected static final int MIN_SERVER_VER_TICK_BY_TICK = 137;
    protected static final int MIN_SERVER_VER_DECISION_MAKER = 138;
    protected static final int MIN_SERVER_VER_MIFID_EXECUTION = 139;
    protected static final int MIN_SERVER_VER_TICK_BY_TICK_IGNORE_SIZE = 140;
    protected static final int MIN_SERVER_VER_AUTO_PRICE_FOR_HEDGE = 141;
    protected static final int MIN_SERVER_VER_WHAT_IF_EXT_FIELDS = 142;
    protected static final int MIN_SERVER_VER_SCANNER_GENERIC_OPTS = 143;
    protected static final int MIN_SERVER_VER_API_BIND_ORDER = 144;
    protected static final int MIN_SERVER_VER_ORDER_CONTAINER = 145;
    protected static final int MIN_SERVER_VER_SMART_DEPTH = 146;
    protected static final int MIN_SERVER_VER_REMOVE_NULL_ALL_CASTING = 147;
    protected static final int MIN_SERVER_VER_D_PEG_ORDERS = 148;
    protected static final int MIN_SERVER_VER_MKT_DEPTH_PRIM_EXCHANGE = 149;
    protected static final int MIN_SERVER_VER_REQ_COMPLETED_ORDERS = 150;
    protected static final int MIN_SERVER_VER_PRICE_MGMT_ALGO = 151;
    protected static final int MIN_SERVER_VER_STOCK_TYPE = 152;
    protected static final int MIN_SERVER_VER_ENCODE_MSG_ASCII7 = 153;
    protected static final int MIN_SERVER_VER_SEND_ALL_FAMILY_CODES = 154;
    protected static final int MIN_SERVER_VER_NO_DEFAULT_OPEN_CLOSE = 155;
    protected static final int MIN_SERVER_VER_PRICE_BASED_VOLATILITY = 156;
    protected static final int MIN_SERVER_VER_REPLACE_FA_END = 157;
    protected static final int MIN_SERVER_VER_DURATION = 158;
    protected static final int MIN_SERVER_VER_MARKET_DATA_IN_SHARES = 159;
    protected static final int MIN_SERVER_VER_POST_TO_ATS = 160;
    protected static final int MIN_SERVER_VER_WSHE_CALENDAR = 161;
    protected static final int MIN_SERVER_VER_AUTO_CANCEL_PARENT = 162;
    protected static final int MIN_SERVER_VER_FRACTIONAL_SIZE_SUPPORT = 163;
    protected static final int MIN_SERVER_VER_SIZE_RULES = 164;
    protected static final int MIN_SERVER_VER_HISTORICAL_SCHEDULE = 165;
    protected static final int MIN_SERVER_VER_ADVANCED_ORDER_REJECT = 166;
    protected static final int MIN_SERVER_VER_USER_INFO = 167;
    protected static final int MIN_SERVER_VER_CRYPTO_AGGREGATED_TRADES = 168;
    protected static final int MIN_SERVER_VER_MANUAL_ORDER_TIME = 169;
    protected static final int MIN_SERVER_VER_PEGBEST_PEGMID_OFFSETS = 170;
    protected static final int MIN_SERVER_VER_WSH_EVENT_DATA_FILTERS = 171;
    protected static final int MIN_SERVER_VER_IPO_PRICES = 172;
    protected static final int MIN_SERVER_VER_WSH_EVENT_DATA_FILTERS_DATE = 173;
    protected static final int MIN_SERVER_VER_INSTRUMENT_TIMEZONE = 174;
    protected static final int MIN_SERVER_VER_HMDS_MARKET_DATA_IN_SHARES = 175;
    protected static final int MIN_SERVER_VER_BOND_ISSUERID = 176;
    public static final int MIN_VERSION = 100;
    public static final int MAX_VERSION = 176;
    protected EReaderSignal m_signal;
    protected EWrapper m_eWrapper;
    protected int m_serverVersion;
    protected String m_TwsTime;
    protected int m_clientId;
    protected boolean m_extraAuth;
    protected boolean m_useV100Plus = true;
    private String m_optionalCapabilities;
    private String m_connectOptions = "";
    protected String m_host;
    protected ETransport m_socketTransport;

    public static String faMsgTypeName(int faDataType) {
        switch (faDataType) {
            case 1: {
                return "GROUPS";
            }
            case 2: {
                return "PROFILES";
            }
            case 3: {
                return "ALIASES";
            }
        }
        return null;
    }

    public boolean isUseV100Plus() {
        return this.m_useV100Plus;
    }

    public int serverVersion() {
        return this.m_serverVersion;
    }

    public String getTwsConnectionTime() {
        return this.m_TwsTime;
    }

    public EWrapper wrapper() {
        return this.m_eWrapper;
    }

    public abstract boolean isConnected();

    protected synchronized void setExtraAuth(boolean extraAuth) {
        this.m_extraAuth = extraAuth;
    }

    public void optionalCapabilities(String val) {
        this.m_optionalCapabilities = val;
    }

    public String optionalCapabilities() {
        return this.m_optionalCapabilities;
    }

    public EClient(EWrapper eWrapper, EReaderSignal signal) {
        this.m_eWrapper = eWrapper;
        this.m_signal = signal;
        this.m_clientId = -1;
        this.m_extraAuth = false;
        this.m_optionalCapabilities = "";
        this.m_serverVersion = 0;
    }

    protected void sendConnectRequest() throws IOException {
        if (!this.m_useV100Plus || this.m_connectOptions == null) {
            this.send(66);
        } else {
            this.sendV100APIHeader();
        }
    }

    public void disableUseV100Plus() {
        if (this.isConnected()) {
            this.m_eWrapper.error(-1, EClientErrors.ALREADY_CONNECTED.code(), EClientErrors.ALREADY_CONNECTED.msg(), null);
            return;
        }
        this.m_connectOptions = "";
        this.m_useV100Plus = false;
    }

    public void setConnectOptions(String options) {
        if (this.isConnected()) {
            this.m_eWrapper.error(-1, EClientErrors.ALREADY_CONNECTED.code(), EClientErrors.ALREADY_CONNECTED.msg(), null);
            return;
        }
        this.m_connectOptions = options;
    }

    protected void connectionError() {
        this.m_eWrapper.error(-1, EClientErrors.CONNECT_FAIL.code(), EClientErrors.CONNECT_FAIL.msg(), null);
    }

    protected String checkConnected(String host) {
        if (this.isConnected()) {
            this.m_eWrapper.error(-1, EClientErrors.ALREADY_CONNECTED.code(), EClientErrors.ALREADY_CONNECTED.msg(), null);
            return null;
        }
        if (EClient.IsEmpty((String)host)) {
            host = "127.0.0.1";
        }
        return host;
    }

    public abstract void eDisconnect();

    public synchronized void startAPI() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        int VERSION = 2;
        try {
            Builder b = this.prepareBuffer();
            b.send(71);
            b.send(2);
            b.send(this.m_clientId);
            if (this.m_serverVersion >= 72) {
                b.send(this.m_optionalCapabilities);
            }
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(-1, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_STARTAPI, e.toString());
            this.close();
        }
    }

    public synchronized void cancelScannerSubscription(int tickerId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 24) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support API scanner subscription.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(23);
            b.send(1);
            b.send(tickerId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_CANSCANNER, e.toString());
            this.close();
        }
    }

    public synchronized void reqScannerParameters() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 24) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support API scanner subscription.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(24);
            b.send(1);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_REQSCANNERPARAMETERS, e.toString());
            this.close();
        }
    }

    public synchronized void reqScannerSubscription(int tickerId, ScannerSubscription subscription, List<TagValue> scannerSubscriptionOptions, List<TagValue> scannerSubscriptionFilterOptions) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 24) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support API scanner subscription.");
            return;
        }
        if (this.m_serverVersion < 143 && scannerSubscriptionFilterOptions != null) {
            this.error(-1, EClientErrors.UPDATE_TWS, " It does not support API scanner subscription generic filter options");
            return;
        }
        int VERSION = 4;
        try {
            Builder b = this.prepareBuffer();
            b.send(22);
            if (this.m_serverVersion < 143) {
                b.send(4);
            }
            b.send(tickerId);
            b.sendMax(subscription.numberOfRows());
            b.send(subscription.instrument());
            b.send(subscription.locationCode());
            b.send(subscription.scanCode());
            b.sendMax(subscription.abovePrice());
            b.sendMax(subscription.belowPrice());
            b.sendMax(subscription.aboveVolume());
            b.sendMax(subscription.marketCapAbove());
            b.sendMax(subscription.marketCapBelow());
            b.send(subscription.moodyRatingAbove());
            b.send(subscription.moodyRatingBelow());
            b.send(subscription.spRatingAbove());
            b.send(subscription.spRatingBelow());
            b.send(subscription.maturityDateAbove());
            b.send(subscription.maturityDateBelow());
            b.sendMax(subscription.couponRateAbove());
            b.sendMax(subscription.couponRateBelow());
            b.send(Boolean.valueOf(subscription.excludeConvertible()));
            if (this.m_serverVersion >= 25) {
                b.sendMax(subscription.averageOptionVolumeAbove());
                b.send(subscription.scannerSettingPairs());
            }
            if (this.m_serverVersion >= 27) {
                b.send(subscription.stockTypeFilter());
            }
            if (this.m_serverVersion >= 143) {
                b.send(scannerSubscriptionFilterOptions);
            }
            if (this.m_serverVersion >= 70) {
                b.send(scannerSubscriptionOptions);
            }
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(tickerId, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_REQSCANNER, e.toString());
            this.close();
        }
    }

    public synchronized void reqMktData(int tickerId, Contract contract, String genericTickList, boolean snapshot, boolean regulatorySnapshot, List<TagValue> mktDataOptions) {
        if (!this.isConnected()) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 35 && snapshot) {
            this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support snapshot market data requests.");
            return;
        }
        if (this.m_serverVersion < 40 && contract.deltaNeutralContract() != null) {
            this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support delta-neutral orders.");
            return;
        }
        if (this.m_serverVersion < 47 && contract.conid() > 0) {
            this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support conId parameter.");
            return;
        }
        if (this.m_serverVersion < 68 && !EClient.IsEmpty((String)contract.tradingClass())) {
            this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support tradingClass parameter in reqMarketData.");
            return;
        }
        int VERSION = 11;
        try {
            Builder b = this.prepareBuffer();
            b.send(1);
            b.send(11);
            b.send(tickerId);
            if (this.m_serverVersion >= 47) {
                b.send(contract.conid());
            }
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.lastTradeDateOrContractMonth());
            b.send(contract.strike());
            b.send(contract.getRight());
            if (this.m_serverVersion >= 15) {
                b.send(contract.multiplier());
            }
            b.send(contract.exchange());
            if (this.m_serverVersion >= 14) {
                b.send(contract.primaryExch());
            }
            b.send(contract.currency());
            if (this.m_serverVersion >= 2) {
                b.send(contract.localSymbol());
            }
            if (this.m_serverVersion >= 68) {
                b.send(contract.tradingClass());
            }
            if (this.m_serverVersion >= 8 && Types.SecType.BAG.name().equalsIgnoreCase(contract.getSecType())) {
                if (contract.comboLegs() == null) {
                    b.send(0);
                } else {
                    b.send(contract.comboLegs().size());
                    for (int i = 0; i < contract.comboLegs().size(); ++i) {
                        ComboLeg comboLeg = (ComboLeg)contract.comboLegs().get(i);
                        b.send(comboLeg.conid());
                        b.send(comboLeg.ratio());
                        b.send(comboLeg.getAction());
                        b.send(comboLeg.exchange());
                    }
                }
            }
            if (this.m_serverVersion >= 40) {
                if (contract.deltaNeutralContract() != null) {
                    DeltaNeutralContract deltaNeutralContract = contract.deltaNeutralContract();
                    b.send(Boolean.valueOf(true));
                    b.send(deltaNeutralContract.conid());
                    b.send(deltaNeutralContract.delta());
                    b.send(deltaNeutralContract.price());
                } else {
                    b.send(Boolean.valueOf(false));
                }
            }
            if (this.m_serverVersion >= 31) {
                b.send(genericTickList);
            }
            if (this.m_serverVersion >= 35) {
                b.send(Boolean.valueOf(snapshot));
            }
            if (this.m_serverVersion >= 114) {
                b.send(Boolean.valueOf(regulatorySnapshot));
            }
            if (this.m_serverVersion >= 70) {
                b.send(mktDataOptions);
            }
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(tickerId, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_REQMKT, e.toString());
            this.close();
        }
    }

    public synchronized void cancelHistoricalData(int tickerId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 24) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support historical data query cancellation.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(25);
            b.send(1);
            b.send(tickerId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_CANHISTDATA, e.toString());
            this.close();
        }
    }

    public synchronized void cancelRealTimeBars(int tickerId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 34) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support realtime bar data query cancellation.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(51);
            b.send(1);
            b.send(tickerId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_CANRTBARS, e.toString());
            this.close();
        }
    }

    public synchronized void reqHistoricalData(int tickerId, Contract contract, String endDateTime, String durationStr, String barSizeSetting, String whatToShow, int useRTH, int formatDate, boolean keepUpToDate, List<TagValue> chartOptions) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        int VERSION = 6;
        try {
            if (this.m_serverVersion < 16) {
                this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support historical data backfill.");
                return;
            }
            if (!(this.m_serverVersion >= 68 || EClient.IsEmpty((String)contract.tradingClass()) && contract.conid() <= 0)) {
                this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support conId and tradingClass parameters in reqHistoricalData.");
                return;
            }
            if (this.m_serverVersion < 165 && !EClient.IsEmpty((String)whatToShow) && whatToShow.equalsIgnoreCase(Types.WhatToShow.SCHEDULE.name())) {
                this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support requesting of historical schedule.");
                return;
            }
            Builder b = this.prepareBuffer();
            b.send(20);
            if (this.m_serverVersion < 124) {
                b.send(6);
            }
            b.send(tickerId);
            if (this.m_serverVersion >= 68) {
                b.send(contract.conid());
            }
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.lastTradeDateOrContractMonth());
            b.send(contract.strike());
            b.send(contract.getRight());
            b.send(contract.multiplier());
            b.send(contract.exchange());
            b.send(contract.primaryExch());
            b.send(contract.currency());
            b.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                b.send(contract.tradingClass());
            }
            if (this.m_serverVersion >= 31) {
                b.send(contract.includeExpired() ? 1 : 0);
            }
            if (this.m_serverVersion >= 20) {
                b.send(endDateTime);
                b.send(barSizeSetting);
            }
            b.send(durationStr);
            b.send(useRTH);
            b.send(whatToShow);
            if (this.m_serverVersion > 16) {
                b.send(formatDate);
            }
            if (Types.SecType.BAG.name().equalsIgnoreCase(contract.getSecType())) {
                if (contract.comboLegs() == null) {
                    b.send(0);
                } else {
                    b.send(contract.comboLegs().size());
                    for (int i = 0; i < contract.comboLegs().size(); ++i) {
                        ComboLeg comboLeg = (ComboLeg)contract.comboLegs().get(i);
                        b.send(comboLeg.conid());
                        b.send(comboLeg.ratio());
                        b.send(comboLeg.getAction());
                        b.send(comboLeg.exchange());
                    }
                }
            }
            if (this.m_serverVersion >= 124) {
                b.send(Boolean.valueOf(keepUpToDate));
            }
            if (this.m_serverVersion >= 70) {
                b.send(chartOptions);
            }
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(tickerId, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_REQHISTDATA, e.toString());
            this.close();
        }
    }

    public synchronized void reqHeadTimestamp(int tickerId, Contract contract, String whatToShow, int useRTH, int formatDate) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        try {
            if (this.m_serverVersion < 118) {
                this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support head time stamp requests.");
                return;
            }
            Builder b = this.prepareBuffer();
            b.send(87);
            b.send(tickerId);
            b.send(contract);
            b.send(useRTH);
            b.send(whatToShow);
            b.send(formatDate);
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(tickerId, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_REQHEADTIMESTAMP, e.toString());
            this.close();
        }
    }

    public synchronized void cancelHeadTimestamp(int tickerId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        try {
            if (this.m_serverVersion < 123) {
                this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support head time stamp requests canceling.");
                return;
            }
            Builder b = this.prepareBuffer();
            b.send(90);
            b.send(tickerId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_CANHEADTIMESTAMP, e.toString());
            this.close();
        }
    }

    public synchronized void reqRealTimeBars(int tickerId, Contract contract, int barSize, String whatToShow, boolean useRTH, List<TagValue> realTimeBarsOptions) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 34) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support real time bars.");
            return;
        }
        if (!(this.m_serverVersion >= 68 || EClient.IsEmpty((String)contract.tradingClass()) && contract.conid() <= 0)) {
            this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support conId and tradingClass parameters in reqRealTimeBars.");
            return;
        }
        int VERSION = 3;
        try {
            Builder b = this.prepareBuffer();
            b.send(50);
            b.send(3);
            b.send(tickerId);
            if (this.m_serverVersion >= 68) {
                b.send(contract.conid());
            }
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.lastTradeDateOrContractMonth());
            b.send(contract.strike());
            b.send(contract.getRight());
            b.send(contract.multiplier());
            b.send(contract.exchange());
            b.send(contract.primaryExch());
            b.send(contract.currency());
            b.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                b.send(contract.tradingClass());
            }
            b.send(barSize);
            b.send(whatToShow);
            b.send(Boolean.valueOf(useRTH));
            if (this.m_serverVersion >= 70) {
                b.send(realTimeBarsOptions);
            }
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(tickerId, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_REQRTBARS, e.toString());
            this.close();
        }
    }

    public synchronized void reqContractDetails(int reqId, Contract contract) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 4) {
            this.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg());
            return;
        }
        if (!(this.m_serverVersion >= 45 || EClient.IsEmpty((String)contract.getSecIdType()) && EClient.IsEmpty((String)contract.secId()))) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support secIdType and secId parameters.");
            return;
        }
        if (this.m_serverVersion < 68 && !EClient.IsEmpty((String)contract.tradingClass())) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support tradingClass parameter in reqContractDetails.");
            return;
        }
        if (this.m_serverVersion < 70 && !EClient.IsEmpty((String)contract.primaryExch())) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support primaryExchange parameter in reqContractDetails.");
            return;
        }
        if (this.m_serverVersion < 176 && !EClient.IsEmpty((String)contract.issuerId())) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support issuerId parameter in reqContractDetails.");
            return;
        }
        int VERSION = 8;
        try {
            Builder b = this.prepareBuffer();
            b.send(9);
            b.send(8);
            if (this.m_serverVersion >= 40) {
                b.send(reqId);
            }
            if (this.m_serverVersion >= 37) {
                b.send(contract.conid());
            }
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.lastTradeDateOrContractMonth());
            b.send(contract.strike());
            b.send(contract.getRight());
            if (this.m_serverVersion >= 15) {
                b.send(contract.multiplier());
            }
            if (this.m_serverVersion >= 75) {
                b.send(contract.exchange());
                b.send(contract.primaryExch());
            } else if (this.m_serverVersion >= 70) {
                if (!EClient.IsEmpty((String)contract.primaryExch()) && ("BEST".equals(contract.exchange()) || "SMART".equals(contract.exchange()))) {
                    b.send(contract.exchange() + ":" + contract.primaryExch());
                } else {
                    b.send(contract.exchange());
                }
            }
            b.send(contract.currency());
            b.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                b.send(contract.tradingClass());
            }
            if (this.m_serverVersion >= 31) {
                b.send(Boolean.valueOf(contract.includeExpired()));
            }
            if (this.m_serverVersion >= 45) {
                b.send(contract.getSecIdType());
                b.send(contract.secId());
            }
            if (this.m_serverVersion >= 176) {
                b.send(contract.issuerId());
            }
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(reqId, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_REQCONTRACT, e.toString());
            this.close();
        }
    }

    public synchronized void reqMktDepth(int tickerId, Contract contract, int numRows, boolean isSmartDepth, List<TagValue> mktDepthOptions) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 6) {
            this.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg());
            return;
        }
        if (!(this.m_serverVersion >= 68 || EClient.IsEmpty((String)contract.tradingClass()) && contract.conid() <= 0)) {
            this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support conId and tradingClass parameters in reqMktDepth.");
            return;
        }
        if (this.m_serverVersion < 146 && isSmartDepth) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support SMART depth request.");
            return;
        }
        if (this.m_serverVersion < 149 && !EClient.IsEmpty((String)contract.primaryExch())) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support primaryExch parameter in reqMktDepth.");
            return;
        }
        int VERSION = 5;
        try {
            Builder b = this.prepareBuffer();
            b.send(10);
            b.send(5);
            b.send(tickerId);
            if (this.m_serverVersion >= 68) {
                b.send(contract.conid());
            }
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.lastTradeDateOrContractMonth());
            b.send(contract.strike());
            b.send(contract.getRight());
            if (this.m_serverVersion >= 15) {
                b.send(contract.multiplier());
            }
            b.send(contract.exchange());
            if (this.m_serverVersion >= 149) {
                b.send(contract.primaryExch());
            }
            b.send(contract.currency());
            b.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                b.send(contract.tradingClass());
            }
            if (this.m_serverVersion >= 19) {
                b.send(numRows);
            }
            if (this.m_serverVersion >= 146) {
                b.send(Boolean.valueOf(isSmartDepth));
            }
            if (this.m_serverVersion >= 70) {
                b.send(mktDepthOptions);
            }
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(tickerId, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_REQMKTDEPTH, e.toString());
            this.close();
        }
    }

    public synchronized void cancelMktData(int tickerId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(2);
            b.send(1);
            b.send(tickerId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_CANMKT, e.toString());
            this.close();
        }
    }

    public synchronized void cancelMktDepth(int tickerId, boolean isSmartDepth) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 6) {
            this.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg());
            return;
        }
        if (this.m_serverVersion < 146 && isSmartDepth) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support SMART depth cancel.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(11);
            b.send(1);
            b.send(tickerId);
            if (this.m_serverVersion >= 146) {
                b.send(Boolean.valueOf(isSmartDepth));
            }
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_CANMKTDEPTH, e.toString());
            this.close();
        }
    }

    public synchronized void exerciseOptions(int tickerId, Contract contract, int exerciseAction, int exerciseQuantity, String account, int override) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        int VERSION = 2;
        try {
            if (this.m_serverVersion < 21) {
                this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support options exercise from the API.");
                return;
            }
            if (!(this.m_serverVersion >= 68 || EClient.IsEmpty((String)contract.tradingClass()) && contract.conid() <= 0)) {
                this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support conId and tradingClass parameters in exerciseOptions.");
                return;
            }
            Builder b = this.prepareBuffer();
            b.send(21);
            b.send(2);
            b.send(tickerId);
            if (this.m_serverVersion >= 68) {
                b.send(contract.conid());
            }
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.lastTradeDateOrContractMonth());
            b.send(contract.strike());
            b.send(contract.getRight());
            b.send(contract.multiplier());
            b.send(contract.exchange());
            b.send(contract.currency());
            b.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                b.send(contract.tradingClass());
            }
            b.send(exerciseAction);
            b.send(exerciseQuantity);
            b.send(account);
            b.send(override);
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(tickerId, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_REQMKT, e.toString());
            this.close();
        }
    }

    public synchronized void placeOrder(int id, Contract contract, Order order) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 35 && (order.scaleInitLevelSize() != Integer.MAX_VALUE || order.scalePriceIncrement() != Double.MAX_VALUE)) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support Scale orders.");
            return;
        }
        if (this.m_serverVersion < 35 && !contract.comboLegs().isEmpty()) {
            for (ComboLeg comboLeg : contract.comboLegs()) {
                if (comboLeg.shortSaleSlot() == 0 && EClient.IsEmpty((String)comboLeg.designatedLocation())) continue;
                this.error(id, EClientErrors.UPDATE_TWS, "  It does not support SSHORT flag for combo legs.");
                return;
            }
        }
        if (this.m_serverVersion < 36 && order.whatIf()) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support what-if orders.");
            return;
        }
        if (this.m_serverVersion < 40 && contract.deltaNeutralContract() != null) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support delta-neutral orders.");
            return;
        }
        if (this.m_serverVersion < 40 && order.scaleSubsLevelSize() != Integer.MAX_VALUE) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support Subsequent Level Size for Scale orders.");
            return;
        }
        if (this.m_serverVersion < 41 && !EClient.IsEmpty((String)order.getAlgoStrategy())) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support algo orders.");
            return;
        }
        if (this.m_serverVersion < 44 && order.notHeld()) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support notHeld parameter.");
            return;
        }
        if (!(this.m_serverVersion >= 45 || EClient.IsEmpty((String)contract.getSecIdType()) && EClient.IsEmpty((String)contract.secId()))) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support secIdType and secId parameters.");
            return;
        }
        if (this.m_serverVersion < 46 && contract.conid() > 0) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support conId parameter.");
            return;
        }
        if (this.m_serverVersion < 52 && order.exemptCode() != -1) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support exemptCode parameter.");
            return;
        }
        if (this.m_serverVersion < 52 && !contract.comboLegs().isEmpty()) {
            for (ComboLeg comboLeg : contract.comboLegs()) {
                if (comboLeg.exemptCode() == -1) continue;
                this.error(id, EClientErrors.UPDATE_TWS, "  It does not support exemptCode parameter.");
                return;
            }
        }
        if (this.m_serverVersion < 54 && !EClient.IsEmpty((String)order.getHedgeType())) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support hedge orders.");
            return;
        }
        if (this.m_serverVersion < 56 && order.optOutSmartRouting()) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support optOutSmartRouting parameter.");
            return;
        }
        if (!(this.m_serverVersion >= 58 || order.deltaNeutralConId() <= 0 && EClient.IsEmpty((String)order.deltaNeutralSettlingFirm()) && EClient.IsEmpty((String)order.deltaNeutralClearingAccount()) && EClient.IsEmpty((String)order.deltaNeutralClearingIntent()))) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support deltaNeutral parameters: ConId, SettlingFirm, ClearingAccount, ClearingIntent");
            return;
        }
        if (!(this.m_serverVersion >= 66 || EClient.IsEmpty((String)order.deltaNeutralOpenClose()) && !order.deltaNeutralShortSale() && order.deltaNeutralShortSaleSlot() <= 0 && EClient.IsEmpty((String)order.deltaNeutralDesignatedLocation()))) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support deltaNeutral parameters: OpenClose, ShortSale, ShortSaleSlot, DesignatedLocation");
            return;
        }
        if (this.m_serverVersion < 60 && order.scalePriceIncrement() > 0.0 && order.scalePriceIncrement() != Double.MAX_VALUE && (order.scalePriceAdjustValue() != Double.MAX_VALUE || order.scalePriceAdjustInterval() != Integer.MAX_VALUE || order.scaleProfitOffset() != Double.MAX_VALUE || order.scaleAutoReset() || order.scaleInitPosition() != Integer.MAX_VALUE || order.scaleInitFillQty() != Integer.MAX_VALUE || order.scaleRandomPercent())) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support Scale order parameters: PriceAdjustValue, PriceAdjustInterval, ProfitOffset, AutoReset, InitPosition, InitFillQty and RandomPercent");
            return;
        }
        if (this.m_serverVersion < 61 && Types.SecType.BAG.name().equalsIgnoreCase(contract.getSecType()) && !order.orderComboLegs().isEmpty()) {
            for (OrderComboLeg orderComboLeg : order.orderComboLegs()) {
                if (orderComboLeg.price() == Double.MAX_VALUE) continue;
                this.error(id, EClientErrors.UPDATE_TWS, "  It does not support per-leg prices for order combo legs.");
                return;
            }
        }
        if (this.m_serverVersion < 62 && order.trailingPercent() != Double.MAX_VALUE) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support trailing percent parameter");
            return;
        }
        if (this.m_serverVersion < 68 && !EClient.IsEmpty((String)contract.tradingClass())) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support tradingClass parameters in placeOrder.");
            return;
        }
        if (this.m_serverVersion < 71 && !EClient.IsEmpty((String)order.algoId())) {
            this.error(id, EClientErrors.UPDATE_TWS, " It does not support algoId parameter");
        }
        if (!(this.m_serverVersion >= 69 || EClient.IsEmpty((String)order.scaleTable()) && EClient.IsEmpty((String)order.activeStartTime()) && EClient.IsEmpty((String)order.activeStopTime()))) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support scaleTable, activeStartTime and activeStopTime parameters.");
            return;
        }
        if (this.m_serverVersion < 73 && order.solicited()) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support order solicited parameter.");
            return;
        }
        if (this.m_serverVersion < 103 && !EClient.IsEmpty((String)order.modelCode())) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support model code parameter.");
            return;
        }
        if (this.m_serverVersion < 105 && !EClient.IsEmpty((String)order.extOperator())) {
            this.error(id, EClientErrors.UPDATE_TWS, " It does not support ext operator");
        }
        if (!(this.m_serverVersion >= 106 || EClient.IsEmpty((String)order.softDollarTier().name()) && EClient.IsEmpty((String)order.softDollarTier().value()))) {
            this.error(id, EClientErrors.UPDATE_TWS, " It does not support soft dollar tier");
        }
        if (this.m_serverVersion < 111 && order.cashQty() != Double.MAX_VALUE) {
            this.error(id, EClientErrors.UPDATE_TWS, " It does not support cash quantity parameter");
            return;
        }
        if (!(this.m_serverVersion >= 138 || EClient.IsEmpty((String)order.mifid2DecisionMaker()) && EClient.IsEmpty((String)order.mifid2DecisionAlgo()))) {
            this.error(id, EClientErrors.UPDATE_TWS, " It does not support MIFID II decision maker parameters");
            return;
        }
        if (!(this.m_serverVersion >= 139 || EClient.IsEmpty((String)order.mifid2ExecutionTrader()) && EClient.IsEmpty((String)order.mifid2ExecutionAlgo()))) {
            this.error(id, EClientErrors.UPDATE_TWS, " It does not support MIFID II execution parameters");
            return;
        }
        if (this.m_serverVersion < 141 && order.dontUseAutoPriceForHedge()) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support don't use auto price for hedge parameter.");
            return;
        }
        if (this.m_serverVersion < 145 && order.isOmsContainer()) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support oms container parameter.");
            return;
        }
        if (this.m_serverVersion < 148 && order.discretionaryUpToLimitPrice()) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support D-Peg orders.");
            return;
        }
        if (this.m_serverVersion < 151 && order.usePriceMgmtAlgo() != null) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support price management algo parameter");
            return;
        }
        if (this.m_serverVersion < 158 && order.duration() != Integer.MAX_VALUE) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support duration attribute");
            return;
        }
        if (this.m_serverVersion < 160 && order.postToAts() != Integer.MAX_VALUE) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support postToAts attribute");
            return;
        }
        if (this.m_serverVersion < 162 && order.autoCancelParent()) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support autoCancelParent attribute");
            return;
        }
        if (this.m_serverVersion < 166 && !EClient.IsEmpty((String)order.advancedErrorOverride())) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support advanced error override attribute");
            return;
        }
        if (this.m_serverVersion < 169 && !EClient.IsEmpty((String)order.manualOrderTime())) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support manual order time attribute");
            return;
        }
        if (this.m_serverVersion < 170 && (order.minTradeQty() != Integer.MAX_VALUE || order.minCompeteSize() != Integer.MAX_VALUE || order.competeAgainstBestOffset() != Double.MAX_VALUE || order.midOffsetAtWhole() != Double.MAX_VALUE || order.midOffsetAtHalf() != Double.MAX_VALUE)) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support PEG BEST / PEG MID order parameters: minTradeQty, minCompeteSize, competeAgainstBestOffset, midOffsetAtWhole and midOffsetAtHalf");
            return;
        }
        int VERSION = this.m_serverVersion < 44 ? 27 : 45;
        try {
            Builder b = this.prepareBuffer();
            b.send(3);
            if (this.m_serverVersion < 145) {
                b.send(VERSION);
            }
            b.send(id);
            if (this.m_serverVersion >= 46) {
                b.send(contract.conid());
            }
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.lastTradeDateOrContractMonth());
            b.send(contract.strike());
            b.send(contract.getRight());
            if (this.m_serverVersion >= 15) {
                b.send(contract.multiplier());
            }
            b.send(contract.exchange());
            if (this.m_serverVersion >= 14) {
                b.send(contract.primaryExch());
            }
            b.send(contract.currency());
            if (this.m_serverVersion >= 2) {
                b.send(contract.localSymbol());
            }
            if (this.m_serverVersion >= 68) {
                b.send(contract.tradingClass());
            }
            if (this.m_serverVersion >= 45) {
                b.send(contract.getSecIdType());
                b.send(contract.secId());
            }
            b.send(order.getAction());
            if (this.m_serverVersion >= 101) {
                b.send(order.totalQuantity().toString());
            } else {
                b.send((int)order.totalQuantity().longValue());
            }
            b.send(order.getOrderType());
            if (this.m_serverVersion < 61) {
                b.send(order.lmtPrice() == Double.MAX_VALUE ? 0.0 : order.lmtPrice());
            } else {
                b.sendMax(order.lmtPrice());
            }
            if (this.m_serverVersion < 62) {
                b.send(order.auxPrice() == Double.MAX_VALUE ? 0.0 : order.auxPrice());
            } else {
                b.sendMax(order.auxPrice());
            }
            b.send(order.getTif());
            b.send(order.ocaGroup());
            b.send(order.account());
            b.send(order.openClose());
            b.send(order.origin());
            b.send(order.orderRef());
            b.send(Boolean.valueOf(order.transmit()));
            if (this.m_serverVersion >= 4) {
                b.send(order.parentId());
            }
            if (this.m_serverVersion >= 5) {
                b.send(Boolean.valueOf(order.blockOrder()));
                b.send(Boolean.valueOf(order.sweepToFill()));
                b.send(order.displaySize());
                b.send(order.getTriggerMethod());
                if (this.m_serverVersion < 38) {
                    b.send(Boolean.valueOf(false));
                } else {
                    b.send(Boolean.valueOf(order.outsideRth()));
                }
            }
            if (this.m_serverVersion >= 7) {
                b.send(Boolean.valueOf(order.hidden()));
            }
            if (this.m_serverVersion >= 8 && Types.SecType.BAG.name().equalsIgnoreCase(contract.getSecType())) {
                if (contract.comboLegs() == null) {
                    b.send(0);
                } else {
                    b.send(contract.comboLegs().size());
                    for (ComboLeg comboLeg : contract.comboLegs()) {
                        b.send(comboLeg.conid());
                        b.send(comboLeg.ratio());
                        b.send(comboLeg.getAction());
                        b.send(comboLeg.exchange());
                        b.send(comboLeg.getOpenClose());
                        if (this.m_serverVersion >= 35) {
                            b.send(comboLeg.shortSaleSlot());
                            b.send(comboLeg.designatedLocation());
                        }
                        if (this.m_serverVersion < 51) continue;
                        b.send(comboLeg.exemptCode());
                    }
                }
            }
            if (this.m_serverVersion >= 61 && Types.SecType.BAG.name().equalsIgnoreCase(contract.getSecType())) {
                if (order.orderComboLegs() == null) {
                    b.send(0);
                } else {
                    b.send(order.orderComboLegs().size());
                    for (OrderComboLeg orderComboLeg : order.orderComboLegs()) {
                        b.sendMax(orderComboLeg.price());
                    }
                }
            }
            if (this.m_serverVersion >= 57 && Types.SecType.BAG.name().equalsIgnoreCase(contract.getSecType())) {
                List smartComboRoutingParams = order.smartComboRoutingParams();
                int smartComboRoutingParamsCount = smartComboRoutingParams == null ? 0 : smartComboRoutingParams.size();
                b.send(smartComboRoutingParamsCount);
                if (smartComboRoutingParamsCount > 0) {
                    for (TagValue tagValue : smartComboRoutingParams) {
                        b.send(tagValue.m_tag);
                        b.send(tagValue.m_value);
                    }
                }
            }
            if (this.m_serverVersion >= 9) {
                b.send("");
            }
            if (this.m_serverVersion >= 10) {
                b.send(order.discretionaryAmt());
            }
            if (this.m_serverVersion >= 11) {
                b.send(order.goodAfterTime());
            }
            if (this.m_serverVersion >= 12) {
                b.send(order.goodTillDate());
            }
            if (this.m_serverVersion >= 13) {
                b.send(order.faGroup());
                b.send(order.getFaMethod());
                b.send(order.faPercentage());
                b.send(order.faProfile());
            }
            if (this.m_serverVersion >= 103) {
                b.send(order.modelCode());
            }
            if (this.m_serverVersion >= 18) {
                b.send(order.shortSaleSlot());
                b.send(order.designatedLocation());
            }
            if (this.m_serverVersion >= 51) {
                b.send(order.exemptCode());
            }
            if (this.m_serverVersion >= 19) {
                b.send(order.getOcaType());
                if (this.m_serverVersion < 38) {
                    b.send(Boolean.valueOf(false));
                }
                b.send(order.getRule80A());
                b.send(order.settlingFirm());
                b.send(Boolean.valueOf(order.allOrNone()));
                b.sendMax(order.minQty());
                b.sendMax(order.percentOffset());
                b.send(Boolean.valueOf(false));
                b.send(Boolean.valueOf(false));
                b.sendMax(Double.MAX_VALUE);
                b.sendMax(order.auctionStrategy());
                b.sendMax(order.startingPrice());
                b.sendMax(order.stockRefPrice());
                b.sendMax(order.delta());
                double lower = this.m_serverVersion == 26 && order.getOrderType().equals("VOL") ? Double.MAX_VALUE : order.stockRangeLower();
                double upper = this.m_serverVersion == 26 && order.getOrderType().equals("VOL") ? Double.MAX_VALUE : order.stockRangeUpper();
                b.sendMax(lower);
                b.sendMax(upper);
            }
            if (this.m_serverVersion >= 22) {
                b.send(Boolean.valueOf(order.overridePercentageConstraints()));
            }
            if (this.m_serverVersion >= 26) {
                b.sendMax(order.volatility());
                b.send(order.getVolatilityType());
                if (this.m_serverVersion < 28) {
                    b.send(Boolean.valueOf(order.getDeltaNeutralOrderType().equalsIgnoreCase("MKT")));
                } else {
                    b.send(order.getDeltaNeutralOrderType());
                    b.sendMax(order.deltaNeutralAuxPrice());
                    if (this.m_serverVersion >= 58 && !EClient.IsEmpty((String)order.getDeltaNeutralOrderType())) {
                        b.send(order.deltaNeutralConId());
                        b.send(order.deltaNeutralSettlingFirm());
                        b.send(order.deltaNeutralClearingAccount());
                        b.send(order.deltaNeutralClearingIntent());
                    }
                    if (this.m_serverVersion >= 66 && !EClient.IsEmpty((String)order.getDeltaNeutralOrderType())) {
                        b.send(order.deltaNeutralOpenClose());
                        b.send(Boolean.valueOf(order.deltaNeutralShortSale()));
                        b.send(order.deltaNeutralShortSaleSlot());
                        b.send(order.deltaNeutralDesignatedLocation());
                    }
                }
                b.send(order.continuousUpdate());
                if (this.m_serverVersion == 26) {
                    double lower = order.getOrderType().equals("VOL") ? order.stockRangeLower() : Double.MAX_VALUE;
                    double upper = order.getOrderType().equals("VOL") ? order.stockRangeUpper() : Double.MAX_VALUE;
                    b.sendMax(lower);
                    b.sendMax(upper);
                }
                b.send(order.getReferencePriceType());
            }
            if (this.m_serverVersion >= 30) {
                b.sendMax(order.trailStopPrice());
            }
            if (this.m_serverVersion >= 62) {
                b.sendMax(order.trailingPercent());
            }
            if (this.m_serverVersion >= 35) {
                if (this.m_serverVersion >= 40) {
                    b.sendMax(order.scaleInitLevelSize());
                    b.sendMax(order.scaleSubsLevelSize());
                } else {
                    b.send("");
                    b.sendMax(order.scaleInitLevelSize());
                }
                b.sendMax(order.scalePriceIncrement());
            }
            if (this.m_serverVersion >= 60 && order.scalePriceIncrement() > 0.0 && order.scalePriceIncrement() != Double.MAX_VALUE) {
                b.sendMax(order.scalePriceAdjustValue());
                b.sendMax(order.scalePriceAdjustInterval());
                b.sendMax(order.scaleProfitOffset());
                b.send(Boolean.valueOf(order.scaleAutoReset()));
                b.sendMax(order.scaleInitPosition());
                b.sendMax(order.scaleInitFillQty());
                b.send(Boolean.valueOf(order.scaleRandomPercent()));
            }
            if (this.m_serverVersion >= 69) {
                b.send(order.scaleTable());
                b.send(order.activeStartTime());
                b.send(order.activeStopTime());
            }
            if (this.m_serverVersion >= 54) {
                b.send(order.getHedgeType());
                if (!EClient.IsEmpty((String)order.getHedgeType())) {
                    b.send(order.hedgeParam());
                }
            }
            if (this.m_serverVersion >= 56) {
                b.send(Boolean.valueOf(order.optOutSmartRouting()));
            }
            if (this.m_serverVersion >= 39) {
                b.send(order.clearingAccount());
                b.send(order.clearingIntent());
            }
            if (this.m_serverVersion >= 44) {
                b.send(Boolean.valueOf(order.notHeld()));
            }
            if (this.m_serverVersion >= 40) {
                if (contract.deltaNeutralContract() != null) {
                    DeltaNeutralContract deltaNeutralContract = contract.deltaNeutralContract();
                    b.send(Boolean.valueOf(true));
                    b.send(deltaNeutralContract.conid());
                    b.send(deltaNeutralContract.delta());
                    b.send(deltaNeutralContract.price());
                } else {
                    b.send(Boolean.valueOf(false));
                }
            }
            if (this.m_serverVersion >= 41) {
                b.send(order.getAlgoStrategy());
                if (!EClient.IsEmpty((String)order.getAlgoStrategy())) {
                    List algoParams = order.algoParams();
                    int algoParamsCount = algoParams.size();
                    b.send(algoParamsCount);
                    for (TagValue tagValue : algoParams) {
                        b.send(tagValue.m_tag);
                        b.send(tagValue.m_value);
                    }
                }
            }
            if (this.m_serverVersion >= 71) {
                b.send(order.algoId());
            }
            if (this.m_serverVersion >= 36) {
                b.send(Boolean.valueOf(order.whatIf()));
            }
            if (this.m_serverVersion >= 70) {
                b.send(order.orderMiscOptions());
            }
            if (this.m_serverVersion >= 73) {
                b.send(Boolean.valueOf(order.solicited()));
            }
            if (this.m_serverVersion >= 76) {
                b.send(Boolean.valueOf(order.randomizeSize()));
                b.send(Boolean.valueOf(order.randomizePrice()));
            }
            if (this.m_serverVersion >= 102) {
                if (order.orderType() == OrderType.PEG_BENCH) {
                    b.send(order.referenceContractId());
                    b.send(Boolean.valueOf(order.isPeggedChangeAmountDecrease()));
                    b.send(order.peggedChangeAmount());
                    b.send(order.referenceChangeAmount());
                    b.send(order.referenceExchangeId());
                }
                b.send(order.conditions().size());
                if (order.conditions().size() > 0) {
                    for (OrderCondition item : order.conditions()) {
                        b.send(item.type().val());
                        item.writeTo((ObjectOutput)b);
                    }
                    b.send(Boolean.valueOf(order.conditionsIgnoreRth()));
                    b.send(Boolean.valueOf(order.conditionsCancelOrder()));
                }
                b.send((IApiEnum)order.adjustedOrderType());
                b.send(order.triggerPrice());
                b.send(order.lmtPriceOffset());
                b.send(order.adjustedStopPrice());
                b.send(order.adjustedStopLimitPrice());
                b.send(order.adjustedTrailingAmount());
                b.send(order.adjustableTrailingUnit());
            }
            if (this.m_serverVersion >= 105) {
                b.send(order.extOperator());
            }
            if (this.m_serverVersion >= 106) {
                SoftDollarTier tier = order.softDollarTier();
                b.send(tier.name());
                b.send(tier.value());
            }
            if (this.m_serverVersion >= 111) {
                b.sendMax(order.cashQty());
            }
            if (this.m_serverVersion >= 138) {
                b.send(order.mifid2DecisionMaker());
                b.send(order.mifid2DecisionAlgo());
            }
            if (this.m_serverVersion >= 139) {
                b.send(order.mifid2ExecutionTrader());
                b.send(order.mifid2ExecutionAlgo());
            }
            if (this.m_serverVersion >= 141) {
                b.send(Boolean.valueOf(order.dontUseAutoPriceForHedge()));
            }
            if (this.m_serverVersion >= 145) {
                b.send(Boolean.valueOf(order.isOmsContainer()));
            }
            if (this.m_serverVersion >= 148) {
                b.send(Boolean.valueOf(order.discretionaryUpToLimitPrice()));
            }
            if (this.m_serverVersion >= 151) {
                b.send(order.usePriceMgmtAlgo());
            }
            if (this.m_serverVersion >= 158) {
                b.send(order.duration());
            }
            if (this.m_serverVersion >= 160) {
                b.send(order.postToAts());
            }
            if (this.m_serverVersion >= 162) {
                b.send(Boolean.valueOf(order.autoCancelParent()));
            }
            if (this.m_serverVersion >= 166) {
                b.send(order.advancedErrorOverride());
            }
            if (this.m_serverVersion >= 169) {
                b.send(order.manualOrderTime());
            }
            if (this.m_serverVersion >= 170) {
                if (contract.exchange().equals("IBKRATS")) {
                    b.sendMax(order.minTradeQty());
                }
                boolean sendMidOffsets = false;
                if (order.orderType().equals((Object)OrderType.PEG_BEST)) {
                    b.sendMax(order.minCompeteSize());
                    b.sendMax(order.competeAgainstBestOffset());
                    if (order.isCompeteAgainstBestOffsetUpToMid()) {
                        sendMidOffsets = true;
                    }
                } else if (order.orderType().equals((Object)OrderType.PEG_MID)) {
                    sendMidOffsets = true;
                }
                if (sendMidOffsets) {
                    b.sendMax(order.midOffsetAtWhole());
                    b.sendMax(order.midOffsetAtHalf());
                }
            }
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(id, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(id, EClientErrors.FAIL_SEND_ORDER, e.toString());
            this.close();
        }
    }

    public synchronized void reqAccountUpdates(boolean subscribe, String acctCode) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        int VERSION = 2;
        try {
            Builder b = this.prepareBuffer();
            b.send(6);
            b.send(2);
            b.send(Boolean.valueOf(subscribe));
            if (this.m_serverVersion >= 9) {
                b.send(acctCode);
            }
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(-1, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_ACCT, e.toString());
            this.close();
        }
    }

    public synchronized void reqExecutions(int reqId, ExecutionFilter filter) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        int VERSION = 3;
        try {
            Builder b = this.prepareBuffer();
            b.send(7);
            b.send(3);
            if (this.m_serverVersion >= 42) {
                b.send(reqId);
            }
            if (this.m_serverVersion >= 9) {
                b.send(filter.clientId());
                b.send(filter.acctCode());
                b.send(filter.time());
                b.send(filter.symbol());
                b.send(filter.secType());
                b.send(filter.exchange());
                b.send(filter.side());
            }
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(reqId, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_EXEC, e.toString());
            this.close();
        }
    }

    public synchronized void cancelOrder(int id, String manualOrderCancelTime) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 169 && !EClient.IsEmpty((String)manualOrderCancelTime)) {
            this.error(id, EClientErrors.UPDATE_TWS, "  It does not support manual order cancel time attribute");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(4);
            b.send(1);
            b.send(id);
            if (this.m_serverVersion >= 169) {
                b.send(manualOrderCancelTime);
            }
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(id, EClientErrors.FAIL_SEND_CORDER, e.toString());
            this.close();
        }
    }

    public synchronized void reqOpenOrders() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(5);
            b.send(1);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_OORDER, e.toString());
            this.close();
        }
    }

    public synchronized void reqIds(int numIds) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(8);
            b.send(1);
            b.send(numIds);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_CORDER, e.toString());
            this.close();
        }
    }

    public synchronized void reqNewsBulletins(boolean allMsgs) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(12);
            b.send(1);
            b.send(Boolean.valueOf(allMsgs));
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_CORDER, e.toString());
            this.close();
        }
    }

    public synchronized void cancelNewsBulletins() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(13);
            b.send(1);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_CORDER, e.toString());
            this.close();
        }
    }

    public synchronized void setServerLogLevel(int logLevel) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(14);
            b.send(1);
            b.send(logLevel);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_SERVER_LOG_LEVEL, e.toString());
            this.close();
        }
    }

    public synchronized void reqAutoOpenOrders(boolean bAutoBind) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(15);
            b.send(1);
            b.send(Boolean.valueOf(bAutoBind));
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_OORDER, e.toString());
            this.close();
        }
    }

    public synchronized void reqAllOpenOrders() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(16);
            b.send(1);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_OORDER, e.toString());
            this.close();
        }
    }

    public synchronized void reqManagedAccts() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(17);
            b.send(1);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_OORDER, e.toString());
            this.close();
        }
    }

    public synchronized void requestFA(int faDataType) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 13) {
            this.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg());
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(18);
            b.send(1);
            b.send(faDataType);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(faDataType, EClientErrors.FAIL_SEND_FA_REQUEST, e.toString());
            this.close();
        }
    }

    public synchronized void replaceFA(int reqId, int faDataType, String xml) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 13) {
            this.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg());
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(19);
            b.send(1);
            b.send(faDataType);
            b.send(xml);
            if (this.m_serverVersion >= 157) {
                b.send(reqId);
            }
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(reqId, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_FA_REPLACE, e.toString());
            this.close();
        }
    }

    public synchronized void reqCurrentTime() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 33) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support current time requests.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(49);
            b.send(1);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_REQCURRTIME, e.toString());
            this.close();
        }
    }

    public synchronized void reqFundamentalData(int reqId, Contract contract, String reportType, List<TagValue> fundamentalDataOptions) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 40) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support fundamental data requests.");
            return;
        }
        if (this.m_serverVersion < 68 && contract.conid() > 0) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support conId parameter in reqFundamentalData.");
            return;
        }
        int VERSION = 2;
        try {
            Builder b = this.prepareBuffer();
            b.send(52);
            b.send(2);
            b.send(reqId);
            if (this.m_serverVersion >= 68) {
                b.send(contract.conid());
            }
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.exchange());
            b.send(contract.primaryExch());
            b.send(contract.currency());
            b.send(contract.localSymbol());
            b.send(reportType);
            if (this.m_serverVersion >= 70) {
                b.send(fundamentalDataOptions);
            }
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(reqId, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_REQFUNDDATA, e.toString());
            this.close();
        }
    }

    public synchronized void cancelFundamentalData(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 40) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support fundamental data requests.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(53);
            b.send(1);
            b.send(reqId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_CANFUNDDATA, e.toString());
            this.close();
        }
    }

    public synchronized void calculateImpliedVolatility(int reqId, Contract contract, double optionPrice, double underPrice, List<TagValue> impliedVolatilityOptions) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 49) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support calculate implied volatility requests.");
            return;
        }
        if (this.m_serverVersion < 68 && !EClient.IsEmpty((String)contract.tradingClass())) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support tradingClass parameter in calculateImpliedVolatility.");
            return;
        }
        int VERSION = 2;
        try {
            Builder b = this.prepareBuffer();
            b.send(54);
            b.send(2);
            b.send(reqId);
            b.send(contract.conid());
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.lastTradeDateOrContractMonth());
            b.send(contract.strike());
            b.send(contract.getRight());
            b.send(contract.multiplier());
            b.send(contract.exchange());
            b.send(contract.primaryExch());
            b.send(contract.currency());
            b.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                b.send(contract.tradingClass());
            }
            b.send(optionPrice);
            b.send(underPrice);
            if (this.m_serverVersion >= 70) {
                b.send(impliedVolatilityOptions);
            }
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(reqId, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_REQCALCIMPLIEDVOLAT, e.toString());
            this.close();
        }
    }

    public synchronized void cancelCalculateImpliedVolatility(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 50) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support calculate implied volatility cancellation.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(56);
            b.send(1);
            b.send(reqId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_CANCALCIMPLIEDVOLAT, e.toString());
            this.close();
        }
    }

    public synchronized void calculateOptionPrice(int reqId, Contract contract, double volatility, double underPrice, List<TagValue> optionPriceOptions) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 50) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support calculate option price requests.");
            return;
        }
        if (this.m_serverVersion < 68 && !EClient.IsEmpty((String)contract.tradingClass())) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support tradingClass parameter in calculateOptionPrice.");
            return;
        }
        int VERSION = 2;
        try {
            Builder b = this.prepareBuffer();
            b.send(55);
            b.send(2);
            b.send(reqId);
            b.send(contract.conid());
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.lastTradeDateOrContractMonth());
            b.send(contract.strike());
            b.send(contract.getRight());
            b.send(contract.multiplier());
            b.send(contract.exchange());
            b.send(contract.primaryExch());
            b.send(contract.currency());
            b.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                b.send(contract.tradingClass());
            }
            b.send(volatility);
            b.send(underPrice);
            if (this.m_serverVersion >= 70) {
                b.send(optionPriceOptions);
            }
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(reqId, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_REQCALCOPTIONPRICE, e.toString());
            this.close();
        }
    }

    public synchronized void cancelCalculateOptionPrice(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 50) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support calculate option price cancellation.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(57);
            b.send(1);
            b.send(reqId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_CANCALCOPTIONPRICE, e.toString());
            this.close();
        }
    }

    public synchronized void reqGlobalCancel() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 53) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support globalCancel requests.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(58);
            b.send(1);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_REQGLOBALCANCEL, e.toString());
            this.close();
        }
    }

    public synchronized void reqMarketDataType(int marketDataType) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 55) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support marketDataType requests.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(59);
            b.send(1);
            b.send(marketDataType);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_REQMARKETDATATYPE, e.toString());
            this.close();
        }
    }

    public synchronized void reqPositions() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 67) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support position requests.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        try {
            b.send(61);
            b.send(1);
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_REQPOSITIONS, e.toString());
        }
    }

    public synchronized void reqSecDefOptParams(int reqId, String underlyingSymbol, String futFopExchange, String underlyingSecType, int underlyingConId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 104) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support security definition option requests.");
            return;
        }
        Builder b = this.prepareBuffer();
        try {
            b.send(78);
            b.send(reqId);
            b.send(underlyingSymbol);
            b.send(futFopExchange);
            b.send(underlyingSecType);
            b.send(underlyingConId);
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(reqId, e.error(), e.text());
        }
        catch (IOException e) {
            this.error(reqId, EClientErrors.FAIL_SEND_REQSECDEFOPTPARAMS, e.toString());
            this.close();
        }
    }

    public synchronized void reqSoftDollarTiers(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 106) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support soft dollar tier requests.");
            return;
        }
        Builder b = this.prepareBuffer();
        try {
            b.send(79);
            b.send(reqId);
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_REQSOFTDOLLARTIERS, e.toString());
        }
    }

    public synchronized void cancelPositions() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 67) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support position cancellation.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        try {
            b.send(64);
            b.send(1);
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_CANPOSITIONS, e.toString());
        }
    }

    public synchronized void reqPositionsMulti(int reqId, String account, String modelCode) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 103) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support positions multi request.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        try {
            b.send(74);
            b.send(1);
            b.send(reqId);
            b.send(account);
            b.send(modelCode);
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(reqId, e.error(), e.text());
        }
        catch (IOException e) {
            this.error(reqId, EClientErrors.FAIL_SEND_REQPOSITIONSMULTI, e.toString());
            this.close();
        }
    }

    public synchronized void cancelPositionsMulti(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 103) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support positions multi cancellation.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        try {
            b.send(75);
            b.send(1);
            b.send(reqId);
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_CANPOSITIONSMULTI, e.toString());
        }
    }

    public synchronized void cancelAccountUpdatesMulti(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 103) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support account updates multi cancellation.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        try {
            b.send(77);
            b.send(1);
            b.send(reqId);
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(reqId, EClientErrors.FAIL_SEND_CANACCOUNTUPDATESMULTI, e.toString());
        }
    }

    public synchronized void reqAccountUpdatesMulti(int reqId, String account, String modelCode, boolean ledgerAndNLV) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 103) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support account updates multi requests.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        try {
            b.send(76);
            b.send(1);
            b.send(reqId);
            b.send(account);
            b.send(modelCode);
            b.send(Boolean.valueOf(ledgerAndNLV));
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(reqId, e.error(), e.text());
        }
        catch (IOException e) {
            this.error(reqId, EClientErrors.FAIL_SEND_REQACCOUNTUPDATESMULTI, e.toString());
            this.close();
        }
    }

    public synchronized void reqAccountSummary(int reqId, String group, String tags) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 67) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support account summary requests.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        try {
            b.send(62);
            b.send(1);
            b.send(reqId);
            b.send(group);
            b.send(tags);
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(reqId, e.error(), e.text());
        }
        catch (IOException e) {
            this.error(reqId, EClientErrors.FAIL_SEND_REQACCOUNTDATA, e.toString());
            this.close();
        }
    }

    public synchronized void cancelAccountSummary(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 67) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support account summary cancellation.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        try {
            b.send(63);
            b.send(1);
            b.send(reqId);
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_CANACCOUNTDATA, e.toString());
        }
    }

    public synchronized void verifyRequest(String apiName, String apiVersion) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 70) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support verification request.");
            return;
        }
        if (!this.m_extraAuth) {
            this.error(-1, EClientErrors.FAIL_SEND_VERIFYMESSAGE, "  Intent to authenticate needs to be expressed during initial connect request.");
            return;
        }
        boolean VERSION = true;
        try {
            Builder b = this.prepareBuffer();
            b.send(65);
            b.send(1);
            b.send(apiName);
            b.send(apiVersion);
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(-1, e.error(), e.text());
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_VERIFYREQUEST, e.toString());
            this.close();
        }
    }

    public synchronized void verifyMessage(String apiData) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 70) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support verification message sending.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        try {
            b.send(66);
            b.send(1);
            b.send(apiData);
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(-1, e.error(), e.text());
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_VERIFYMESSAGE, e.toString());
            this.close();
        }
    }

    public synchronized void verifyAndAuthRequest(String apiName, String apiVersion, String opaqueIsvKey) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 74) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support verification request.");
            return;
        }
        if (!this.m_extraAuth) {
            this.error(-1, EClientErrors.FAIL_SEND_VERIFYANDAUTHREQUEST, "  Intent to authenticate needs to be expressed during initial connect request.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        try {
            b.send(72);
            b.send(1);
            b.send(apiName);
            b.send(apiVersion);
            b.send(opaqueIsvKey);
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(-1, e.error(), e.text());
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_VERIFYANDAUTHREQUEST, e.toString());
            this.close();
        }
    }

    public synchronized void verifyAndAuthMessage(String apiData, String xyzResponse) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 74) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support verification message sending.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        try {
            b.send(73);
            b.send(1);
            b.send(apiData);
            b.send(xyzResponse);
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(-1, e.error(), e.text());
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_VERIFYANDAUTHMESSAGE, e.toString());
            this.close();
        }
    }

    public synchronized void queryDisplayGroups(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 70) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support queryDisplayGroups request.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        try {
            b.send(67);
            b.send(1);
            b.send(reqId);
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_QUERYDISPLAYGROUPS, e.toString());
        }
    }

    public synchronized void subscribeToGroupEvents(int reqId, int groupId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 70) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support subscribeToGroupEvents request.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        try {
            b.send(68);
            b.send(1);
            b.send(reqId);
            b.send(groupId);
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_SUBSCRIBETOGROUPEVENTS, e.toString());
        }
    }

    public synchronized void updateDisplayGroup(int reqId, String contractInfo) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 70) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support updateDisplayGroup request.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        try {
            b.send(69);
            b.send(1);
            b.send(reqId);
            b.send(contractInfo);
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(reqId, e.error(), e.text());
        }
        catch (IOException e) {
            this.error(reqId, EClientErrors.FAIL_SEND_UPDATEDISPLAYGROUP, e.toString());
            this.close();
        }
    }

    public synchronized void unsubscribeFromGroupEvents(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 70) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support unsubscribeFromGroupEvents request.");
            return;
        }
        boolean VERSION = true;
        Builder b = this.prepareBuffer();
        try {
            b.send(70);
            b.send(1);
            b.send(reqId);
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_UNSUBSCRIBEFROMGROUPEVENTS, e.toString());
        }
    }

    public synchronized void reqMatchingSymbols(int reqId, String pattern) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 108) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support matching symbols request.");
            return;
        }
        Builder b = this.prepareBuffer();
        try {
            b.send(81);
            b.send(reqId);
            b.send(pattern);
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(reqId, e.error(), e.text());
        }
        catch (IOException e) {
            this.error(reqId, EClientErrors.FAIL_SEND_REQMATCHINGSYMBOLS, e.toString());
            this.close();
        }
    }

    public synchronized void reqFamilyCodes() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 107) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support family codes request.");
            return;
        }
        Builder b = this.prepareBuffer();
        try {
            b.send(80);
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_REQFAMILYCODES, e.toString());
        }
    }

    public synchronized void reqMktDepthExchanges() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 112) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support market depth exchanges request.");
            return;
        }
        Builder b = this.prepareBuffer();
        try {
            b.send(82);
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_REQMKTDEPTHEXCHANGES, e.toString());
        }
    }

    public synchronized void reqSmartComponents(int reqId, String bboExchange) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 114) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support smart components request.");
            return;
        }
        Builder b = this.prepareBuffer();
        try {
            b.send(83);
            b.send(reqId);
            b.send(bboExchange);
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(reqId, e.error(), e.text());
        }
        catch (IOException e) {
            this.error(reqId, EClientErrors.FAIL_SEND_REQSMARTCOMPONENTS, e.toString());
            this.close();
        }
    }

    public synchronized void reqNewsProviders() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 115) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support news providers request.");
            return;
        }
        Builder b = this.prepareBuffer();
        try {
            b.send(85);
            this.closeAndSend(b);
        }
        catch (IOException e) {
            this.error(-1, EClientErrors.FAIL_SEND_REQNEWSPROVIDERS, e.toString());
        }
    }

    public synchronized void reqNewsArticle(int requestId, String providerCode, String articleId, List<TagValue> newsArticleOptions) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 116) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support news article request.");
            return;
        }
        Builder b = this.prepareBuffer();
        try {
            b.send(84);
            b.send(requestId);
            b.send(providerCode);
            b.send(articleId);
            if (this.m_serverVersion >= 128) {
                b.send(newsArticleOptions);
            }
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(requestId, e.error(), e.text());
        }
        catch (IOException e) {
            this.error(requestId, EClientErrors.FAIL_SEND_REQNEWSARTICLE, e.toString());
            this.close();
        }
    }

    public synchronized void reqHistoricalNews(int requestId, int conId, String providerCodes, String startDateTime, String endDateTime, int totalResults, List<TagValue> historicalNewsOptions) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 117) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support historical news request.");
            return;
        }
        Builder b = this.prepareBuffer();
        try {
            b.send(86);
            b.send(requestId);
            b.send(conId);
            b.send(providerCodes);
            b.send(startDateTime);
            b.send(endDateTime);
            b.send(totalResults);
            if (this.m_serverVersion >= 128) {
                b.send(historicalNewsOptions);
            }
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(requestId, e.error(), e.text());
        }
        catch (IOException e) {
            this.error(requestId, EClientErrors.FAIL_SEND_REQHISTORICALNEWS, e.toString());
            this.close();
        }
    }

    public synchronized void reqHistogramData(int tickerId, Contract contract, boolean useRTH, String timePeriod) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        try {
            if (this.m_serverVersion < 119) {
                this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support histogram requests.");
                return;
            }
            Builder b = this.prepareBuffer();
            b.send(88);
            b.send(tickerId);
            b.send(contract);
            b.send(useRTH ? 1 : 0);
            b.send(timePeriod);
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(tickerId, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_REQHISTDATA, e.toString());
            this.close();
        }
    }

    public synchronized void cancelHistogramData(int tickerId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 119) {
            this.error(tickerId, EClientErrors.UPDATE_TWS, "  It does not support head time stamp requests.");
            return;
        }
        try {
            Builder b = this.prepareBuffer();
            b.send(89);
            b.send(tickerId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(tickerId, EClientErrors.FAIL_SEND_CANHISTDATA, e.toString());
            this.close();
        }
    }

    public synchronized void reqMarketRule(int marketRuleId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 126) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support market rule requests.");
            return;
        }
        try {
            Builder b = this.prepareBuffer();
            b.send(91);
            b.send(marketRuleId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_REQMARKETRULE, e.toString());
            this.close();
        }
    }

    public synchronized void reqPnL(int reqId, String account, String modelCode) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 127) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support PnL requests.");
            return;
        }
        try {
            Builder b = this.prepareBuffer();
            b.send(92);
            b.send(reqId);
            b.send(account);
            b.send(modelCode);
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(reqId, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_REQPNL, e.toString());
            this.close();
        }
    }

    public synchronized void cancelPnL(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 127) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support PnL requests.");
            return;
        }
        try {
            Builder b = this.prepareBuffer();
            b.send(93);
            b.send(reqId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_CANPNL, e.toString());
            this.close();
        }
    }

    public synchronized void reqPnLSingle(int reqId, String account, String modelCode, int conId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 127) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support PnL requests.");
            return;
        }
        try {
            Builder b = this.prepareBuffer();
            b.send(94);
            b.send(reqId);
            b.send(account);
            b.send(modelCode);
            b.send(conId);
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(reqId, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_REQPNL_SINGLE, e.toString());
            this.close();
        }
    }

    public synchronized void cancelPnLSingle(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 127) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support PnL requests.");
            return;
        }
        try {
            Builder b = this.prepareBuffer();
            b.send(95);
            b.send(reqId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_CANPNL_SINGLE, e.toString());
            this.close();
        }
    }

    public synchronized void reqHistoricalTicks(int reqId, Contract contract, String startDateTime, String endDateTime, int numberOfTicks, String whatToShow, int useRth, boolean ignoreSize, List<TagValue> miscOptions) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 130) {
            this.error(reqId, EClientErrors.UPDATE_TWS, "  It does not support historical ticks request.");
            return;
        }
        try {
            Builder b = this.prepareBuffer();
            b.send(96);
            b.send(reqId);
            b.send(contract);
            b.send(startDateTime);
            b.send(endDateTime);
            b.send(numberOfTicks);
            b.send(whatToShow);
            b.send(useRth);
            b.send(Boolean.valueOf(ignoreSize));
            b.send(miscOptions);
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(reqId, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_HISTORICAL_TICK, e.toString());
            this.close();
        }
    }

    public synchronized void reqTickByTickData(int reqId, Contract contract, String tickType, int numberOfTicks, boolean ignoreSize) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 137) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support tick-by-tick data requests.");
            return;
        }
        if (this.m_serverVersion < 140 && (numberOfTicks != 0 || ignoreSize)) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support ignoreSize and numberOfTicks parameters in tick-by-tick data requests.");
            return;
        }
        try {
            Builder b = this.prepareBuffer();
            b.send(97);
            b.send(reqId);
            b.send(contract.conid());
            b.send(contract.symbol());
            b.send(contract.getSecType());
            b.send(contract.lastTradeDateOrContractMonth());
            b.send(contract.strike());
            b.send(contract.getRight());
            b.send(contract.multiplier());
            b.send(contract.exchange());
            b.send(contract.primaryExch());
            b.send(contract.currency());
            b.send(contract.localSymbol());
            b.send(contract.tradingClass());
            b.send(tickType);
            if (this.m_serverVersion >= 140) {
                b.send(numberOfTicks);
                b.send(Boolean.valueOf(ignoreSize));
            }
            this.closeAndSend(b);
        }
        catch (EClientException e) {
            this.error(reqId, e.error(), e.text());
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_REQTICKBYTICK, e.toString());
            this.close();
        }
    }

    public synchronized void cancelTickByTickData(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 137) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support tick-by-tick data cancels.");
            return;
        }
        try {
            Builder b = this.prepareBuffer();
            b.send(98);
            b.send(reqId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_CANTICKBYTICK, e.toString());
            this.close();
        }
    }

    public synchronized void reqCompletedOrders(boolean apiOnly) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 150) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support completed orders requests.");
            return;
        }
        try {
            Builder b = this.prepareBuffer();
            b.send(99);
            b.send(Boolean.valueOf(apiOnly));
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_REQ_COMPLETED_ORDERS, e.toString());
            this.close();
        }
    }

    public synchronized void reqWshMetaData(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 161) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support WSHE Calendar API.");
            return;
        }
        try {
            Builder b = this.prepareBuffer();
            b.send(100);
            b.send(reqId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_REQ_WSH_META_DATA, e.toString());
            this.close();
        }
    }

    public synchronized void cancelWshMetaData(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 161) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support WSHE Calendar API.");
            return;
        }
        try {
            Builder b = this.prepareBuffer();
            b.send(101);
            b.send(reqId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_CAN_WSH_META_DATA, e.toString());
            this.close();
        }
    }

    public synchronized void reqWshEventData(int reqId, WshEventData wshEventData) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 161) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support WSHE Calendar API.");
            return;
        }
        if (this.m_serverVersion < 171 && (!EClient.IsEmpty((String)wshEventData.filter()) || wshEventData.fillWatchlist() || wshEventData.fillPortfolio() || wshEventData.fillCompetitors())) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support WSH event data filters.");
            return;
        }
        if (!(this.m_serverVersion >= 173 || EClient.IsEmpty((String)wshEventData.startDate()) && EClient.IsEmpty((String)wshEventData.endDate()) && wshEventData.totalLimit() == Integer.MAX_VALUE)) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support WSH event data date filters.");
            return;
        }
        try {
            Builder b = this.prepareBuffer();
            b.send(102);
            b.send(reqId);
            b.send(wshEventData.conId());
            if (this.m_serverVersion >= 171) {
                b.send(wshEventData.filter());
                b.send(Boolean.valueOf(wshEventData.fillWatchlist()));
                b.send(Boolean.valueOf(wshEventData.fillPortfolio()));
                b.send(Boolean.valueOf(wshEventData.fillCompetitors()));
            }
            if (this.m_serverVersion >= 173) {
                b.send(wshEventData.startDate());
                b.send(wshEventData.endDate());
                b.send(wshEventData.totalLimit());
            }
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_REQ_WSH_META_DATA, e.toString());
            this.close();
        }
    }

    public synchronized void cancelWshEventData(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 161) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support WSHE Calendar API.");
            return;
        }
        try {
            Builder b = this.prepareBuffer();
            b.send(103);
            b.send(reqId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(-1, EClientErrors.FAIL_SEND_CAN_WSH_EVENT_DATA, e.toString());
            this.close();
        }
    }

    public synchronized void reqUserInfo(int reqId) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 167) {
            this.error(reqId, EClientErrors.UPDATE_TWS, " It does not support user info requests.");
            return;
        }
        try {
            Builder b = this.prepareBuffer();
            b.send(104);
            b.send(reqId);
            this.closeAndSend(b);
        }
        catch (Exception e) {
            this.error(reqId, EClientErrors.FAIL_SEND_REQUSERINFO, e.toString());
            this.close();
        }
    }

    @Deprecated
    protected synchronized void error(String err) {
        this.m_eWrapper.error(err);
    }

    protected synchronized void error(int id, int errorCode, String errorMsg) {
        this.m_eWrapper.error(id, errorCode, errorMsg, null);
    }

    protected void close() {
        this.eDisconnect();
        this.wrapper().connectionClosed();
    }

    protected void error(int id, EClientErrors.CodeMsgPair pair, String tail) {
        this.error(id, pair.code(), pair.msg() + tail);
    }

    protected abstract Builder prepareBuffer();

    protected abstract void closeAndSend(Builder var1) throws IOException;

    private void sendV100APIHeader() throws IOException {
        try (Builder builder = new Builder(1024);){
            builder.send("API\u0000".getBytes(StandardCharsets.UTF_8));
            Object out = this.buildVersionString(100, 176);
            if (!EClient.IsEmpty((String)this.m_connectOptions)) {
                out = (String)out + " " + this.m_connectOptions;
            }
            int lengthPos = builder.allocateLengthHeader();
            builder.send(((String)out).getBytes(StandardCharsets.UTF_8));
            builder.updateLength(lengthPos);
            this.sendMsg(new EMessage(builder));
        }
    }

    private String buildVersionString(int minVersion, int maxVersion) {
        return "v" + String.valueOf(minVersion < maxVersion ? minVersion + ".." + maxVersion : Integer.valueOf(minVersion));
    }

    protected void sendMsg(EMessage msg) throws IOException {
        this.m_socketTransport.send(msg);
    }

    private static boolean IsEmpty(String str) {
        return Util.StringIsEmpty((String)str);
    }

    protected void notConnected() {
        this.error(-1, EClientErrors.NOT_CONNECTED, "");
    }

    public String connectedHost() {
        return this.m_host;
    }

    protected void send(int val) throws IOException {
        this.send(String.valueOf(val));
    }

    protected void send(String str) throws IOException {
        try (Builder builder = new Builder(1024);){
            builder.send(str);
            this.sendMsg(new EMessage(builder));
        }
    }
}

