/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.Util;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;

/*
 * Exception performing whole class analysis ignored.
 */
public class Decimal
implements Comparable<Decimal> {
    private static final String NAN_STRING = Double.toString(Double.NaN);
    public static final MathContext MATH_CONTEXT = MathContext.DECIMAL64;
    public static final Decimal ZERO = new Decimal(BigDecimal.ZERO);
    public static final Decimal ONE = new Decimal(BigDecimal.ONE);
    public static final Decimal MINUS_ONE = ONE.negate();
    public static final Decimal INVALID = new Decimal(BigDecimal.valueOf(Long.MIN_VALUE));
    public static final Decimal NaN = new /* Unavailable Anonymous Inner Class!! */;
    public static final Decimal ONE_HUNDRED = new Decimal(BigDecimal.valueOf(100L));
    private final BigDecimal m_value;

    public int hashCode() {
        return this.m_value.hashCode();
    }

    public BigDecimal value() {
        return this.m_value;
    }

    public boolean isZero() {
        return Decimal.isZero((BigDecimal)this.m_value);
    }

    private static boolean isZero(BigDecimal d) {
        return d == BigDecimal.ZERO || d.signum() == 0;
    }

    public boolean isValid() {
        return this != INVALID && this != NaN;
    }

    public static Decimal get(BigDecimal v) {
        Decimal result = v == null ? INVALID : (Decimal.isZero((BigDecimal)v) ? ZERO : new Decimal(v));
        return result;
    }

    public static final Decimal get(double v) {
        Decimal result;
        if (v == Double.MAX_VALUE) {
            result = INVALID;
        } else if (v == 0.0) {
            result = ZERO;
        } else if (Double.isNaN(v) || Double.isInfinite(v)) {
            result = NaN;
        } else {
            DecimalFormat df = new DecimalFormat("#");
            df.setMaximumFractionDigits(16);
            result = Decimal.parse((String)df.format(v));
        }
        return result;
    }

    public static Decimal get(long v) {
        Decimal result = v == Long.MAX_VALUE ? INVALID : (v == 0L ? ZERO : new Decimal(v));
        return result;
    }

    private Decimal(double value) {
        BigDecimal bd = new BigDecimal(value, MATH_CONTEXT);
        this.m_value = bd.setScale(16, MATH_CONTEXT.getRoundingMode());
    }

    private Decimal(long value) {
        BigDecimal bd = new BigDecimal(value, MATH_CONTEXT);
        this.m_value = bd.setScale(16, MATH_CONTEXT.getRoundingMode());
    }

    private Decimal(BigDecimal value) {
        this.m_value = value.setScale(16, MATH_CONTEXT.getRoundingMode());
    }

    public static boolean isValidNotZeroValue(Decimal value) {
        return Decimal.isValid((Decimal)value) && !value.isZero();
    }

    public static boolean isValid(Decimal value) {
        return value != null && value.isValid();
    }

    public static Decimal parse(String text) {
        if (Util.StringIsEmpty((String)text)) {
            return null;
        }
        if (NAN_STRING.equals(text)) {
            return NaN;
        }
        try {
            text = text.trim().replaceAll(",", "");
            BigDecimal decimal = new BigDecimal(text.toCharArray(), 0, text.length(), MATH_CONTEXT);
            return new Decimal(decimal);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Decimal negate() {
        return this.isValid() ? Decimal.get((BigDecimal)this.m_value.negate()) : this;
    }

    public Decimal add(Decimal another) {
        return !Decimal.isValid((Decimal)another) || another.isZero() ? this : (this.isZero() || !this.isValid() ? another : Decimal.get((BigDecimal)this.m_value.add(another.value())));
    }

    public Decimal divide(Decimal another) {
        Decimal result;
        if (ONE.equals((Object)another) || this.isZero()) {
            result = this;
        } else {
            result = INVALID;
            if (this.isValid() && Decimal.isValid((Decimal)another)) {
                try {
                    result = Decimal.get((BigDecimal)this.m_value.divide(another.value(), MATH_CONTEXT));
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public Decimal multiply(Decimal another) {
        return another == null ? null : (this.isZero() || another.isZero() ? ZERO : (this.isValid() && another.isValid() ? (ONE.equals((Object)another) ? this : Decimal.get((BigDecimal)this.m_value.multiply(another.value()))) : INVALID));
    }

    public boolean equals(Object another) {
        return another instanceof Decimal && this.compareTo((Decimal)another) == 0;
    }

    @Override
    public int compareTo(Decimal another) {
        return another == this ? 0 : (another == null ? 1 : (this.isValid() ? (another.isValid() ? this.m_value.compareTo(another.m_value) : 1) : (another.isValid() ? -1 : 0)));
    }

    public static int compare(Decimal value1, Decimal value2) {
        return value1.value().compareTo(value2.value());
    }

    public String toString() {
        return this.isValid() ? this.m_value.stripTrailingZeros().toPlainString() : "";
    }

    public long longValue() {
        return this.isValid() ? this.m_value.longValue() : Long.MAX_VALUE;
    }
}

