/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.Builder;
import com.ib.client.Contract;
import com.ib.client.EClientErrors;
import com.ib.client.EClientException;
import com.ib.client.IApiEnum;
import com.ib.client.TagValue;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/*
 * Exception performing whole class analysis ignored.
 */
class Builder
implements ObjectOutput {
    private static final char SEP = '\u0000';
    private static final byte[] EMPTY_LENGTH_HEADER = new byte[4];
    private final ByteBuffer m_sb;

    public Builder(int size) {
        this.m_sb = new ByteBuffer(size);
    }

    public void send(int a) throws EClientException {
        this.send(String.valueOf(a));
    }

    public void sendMax(int a) throws EClientException {
        this.send(a == Integer.MAX_VALUE ? "" : String.valueOf(a));
    }

    public void send(double a) throws EClientException {
        this.send(String.valueOf(a));
    }

    public void sendMax(double a) throws EClientException {
        this.send(a == Double.MAX_VALUE ? "" : String.valueOf(a));
    }

    public void send(Boolean a) throws EClientException {
        this.sendMax(a == null ? Integer.MAX_VALUE : (a != false ? 1 : 0));
    }

    public void send(IApiEnum a) throws EClientException {
        this.send(a == null ? null : a.getApiString());
    }

    public void send(String a) throws EClientException {
        if (a != null && !Builder.isAsciiPrintable((String)a)) {
            throw new EClientException(EClientErrors.INVALID_SYMBOL, a);
        }
        if (a != null) {
            byte[] buffer = a.getBytes(StandardCharsets.UTF_8);
            this.m_sb.write(buffer, 0, buffer.length);
        }
        this.m_sb.write(0);
    }

    public void send(byte[] bytes) {
        if (bytes != null) {
            this.m_sb.write(bytes, 0, bytes.length);
        }
    }

    public void send(List<TagValue> miscOptions) throws EClientException {
        String miscOptionsString = ((List)Optional.ofNullable(miscOptions).orElse(new ArrayList())).stream().map(option -> option.m_tag + "=" + option.m_value + ";").reduce("", (sum, option) -> sum + option);
        this.send(miscOptionsString);
    }

    public void send(Contract contract) throws EClientException {
        this.send(contract.conid());
        this.send(contract.symbol());
        this.send(contract.getSecType());
        this.send(contract.lastTradeDateOrContractMonth());
        this.send(contract.strike());
        this.send(contract.getRight());
        this.send(contract.multiplier());
        this.send(contract.exchange());
        this.send(contract.primaryExch());
        this.send(contract.currency());
        this.send(contract.localSymbol());
        this.send(contract.tradingClass());
        this.send(contract.includeExpired() ? 1 : 0);
    }

    public int allocateLengthHeader() {
        int lengthHeaderPosition = this.m_sb.size();
        this.m_sb.write(EMPTY_LENGTH_HEADER, 0, EMPTY_LENGTH_HEADER.length);
        return lengthHeaderPosition;
    }

    public void updateLength(int lengthHeaderPosition) {
        this.m_sb.updateLength(lengthHeaderPosition);
    }

    public void writeTo(DataOutputStream dos) throws IOException {
        this.m_sb.writeTo(dos);
    }

    static void intToBytes(int val, byte[] b, int position) {
        b[position] = (byte)(0xFF & val >> 24);
        b[position + 1] = (byte)(0xFF & val >> 16);
        b[position + 2] = (byte)(0xFF & val >> 8);
        b[position + 3] = (byte)(0xFF & val);
    }

    private static boolean isAsciiPrintable(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Builder.isAsciiPrintable((char)str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    @Override
    public void writeBoolean(boolean arg0) throws IOException {
        this.send(Boolean.valueOf(arg0));
    }

    @Override
    public void writeByte(int arg0) throws IOException {
        this.send(arg0);
    }

    @Override
    public void writeBytes(String arg0) throws IOException {
        this.send(arg0);
    }

    @Override
    public void writeChar(int arg0) throws IOException {
        this.send(arg0);
    }

    @Override
    public void writeChars(String arg0) throws IOException {
        this.send(arg0);
    }

    @Override
    public void writeDouble(double arg0) throws IOException {
        this.send(arg0);
    }

    @Override
    public void writeFloat(float arg0) throws IOException {
        this.send((double)arg0);
    }

    @Override
    public void writeInt(int arg0) throws IOException {
        this.send(arg0);
    }

    @Override
    public void writeLong(long arg0) throws IOException {
        this.send((double)arg0);
    }

    @Override
    public void writeShort(int arg0) throws IOException {
        this.send(arg0);
    }

    @Override
    public void writeUTF(String arg0) throws IOException {
        this.send(arg0);
    }

    @Override
    public void close() throws IOException {
        this.m_sb.close();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(int arg0) throws IOException {
    }

    @Override
    public void write(byte[] arg0) throws IOException {
    }

    @Override
    public void write(byte[] arg0, int arg1, int arg2) throws IOException {
    }

    @Override
    public void writeObject(Object arg0) throws IOException {
    }
}

